/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.price;

import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Contract;
import com.xorrus.trading.common.contract.Option;
import com.xorrus.trading.ib.tws.api.type.TickType;
import com.xorrus.trading.ib.tws.price.IMarketDataFlow;
import com.xorrus.trading.ib.tws.price.IRememberMarketDataFlow;
import com.xorrus.trading.ib.tws.price.OptionChain;
import com.xorrus.trading.ib.tws.price.PricedOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001e\u0018\u0000 A2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0005=>?@AB/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0082@\u00a2\u0006\u0002\u0010%J\n\u0010&\u001a\u0004\u0018\u00010\u0002H\u0002J\u0018\u0010'\u001a\u00020\u00022\u0006\u0010(\u001a\u00020\u00022\u0006\u0010)\u001a\u00020\u0002H\u0002J\u001c\u0010*\u001a\u00020\"2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0096@\u00a2\u0006\u0002\u0010+J\u0010\u0010,\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u0007H\u0002J\u0010\u0010.\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u0007H\u0002J\u0010\u0010/\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\b\u00100\u001a\u00020\"H\u0002J\b\u00101\u001a\u00020\"H\u0002J\b\u00105\u001a\u00020\"H\u0002J\u001b\u00106\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u00107\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b8J\u000f\u00109\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b:J\u000f\u0010;\u001a\u0004\u0018\u00010\u0007H\u0000\u00a2\u0006\u0002\b<R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0007X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u00102\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104\u00a8\u0006B"}, d2={"Lcom/xorrus/trading/ib/tws/price/StrikeFinder;", "Lkotlinx/coroutines/flow/Flow;", "Lcom/xorrus/trading/ib/tws/price/PricedOption;", "aboFlow", "Lcom/xorrus/trading/ib/tws/price/IRememberMarketDataFlow;", "options", "", "Lcom/xorrus/trading/common/contract/Option;", "cfg", "Lcom/xorrus/trading/ib/tws/price/StrikeFinder$IConfiguration;", "maxTwsAbos", "", "<init>", "(Lcom/xorrus/trading/ib/tws/price/IRememberMarketDataFlow;Ljava/util/List;Lcom/xorrus/trading/ib/tws/price/StrikeFinder$IConfiguration;I)V", "getAboFlow", "()Lcom/xorrus/trading/ib/tws/price/IRememberMarketDataFlow;", "optionAbos", "getOptionAbos", "()Ljava/util/List;", "optionchain", "Lcom/xorrus/trading/ib/tws/price/OptionChain;", "getOptionchain$tws_api", "()Lcom/xorrus/trading/ib/tws/price/OptionChain;", "below", "getBelow$tws_api", "()Lcom/xorrus/trading/common/contract/Option;", "setBelow$tws_api", "(Lcom/xorrus/trading/common/contract/Option;)V", "above", "getAbove$tws_api", "setAbove$tws_api", "collector", "Lkotlinx/coroutines/flow/FlowCollector;", "onTickUpdate", "", "tickData", "Lcom/xorrus/trading/ib/tws/price/IMarketDataFlow$TickData;", "(Lcom/xorrus/trading/ib/tws/price/IMarketDataFlow$TickData;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findTargetOption", "calculateTargetOption", "belowPriced", "abovePriced", "collect", "(Lkotlinx/coroutines/flow/FlowCollector;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateStrikeTooLow", "option", "updateStrikeTooHigh", "updateStrikeBounds", "updateSubscriptions", "removeUnnecessarySubscriptions", "availableAbos", "getAvailableAbos", "()I", "addSubscriptions", "selectUnsubscribedStrikes", "newAbos", "selectUnsubscribedStrikes$tws_api", "getOptionAboveUpperBound", "getOptionAboveUpperBound$tws_api", "getOptionBelowLowerBound", "getOptionBelowLowerBound$tws_api", "IConfiguration", "LowestPutStrike", "HighestCallStrike", "StrikeComparison", "Companion", "tws-api"})
@SourceDebugExtension(value={"SMAP\nStrikeFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StrikeFinder.kt\ncom/xorrus/trading/ib/tws/price/StrikeFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,362:1\n1#2:363\n1563#3:364\n1634#3,3:365\n774#3:368\n865#3,2:369\n1740#3,3:371\n774#3:374\n865#3,2:375\n1563#3:377\n1634#3,3:378\n1869#3,2:381\n1563#3:383\n1634#3,3:384\n1563#3:387\n1634#3,3:388\n1869#3,2:391\n1563#3:393\n1634#3,3:394\n774#3:397\n865#3,2:398\n774#3:400\n865#3,2:401\n774#3:403\n865#3,2:404\n774#3:406\n865#3,2:407\n1563#3:409\n1634#3,3:410\n*S KotlinDebug\n*F\n+ 1 StrikeFinder.kt\ncom/xorrus/trading/ib/tws/price/StrikeFinder\n*L\n97#1:364\n97#1:365,3\n133#1:368\n133#1:369,2\n134#1:371,3\n264#1:374\n264#1:375,2\n270#1:377\n270#1:378,3\n273#1:381,2\n276#1:383\n276#1:384,3\n293#1:387\n293#1:388,3\n295#1:391,2\n298#1:393\n298#1:394,3\n313#1:397\n313#1:398,2\n320#1:400\n320#1:401,2\n321#1:403\n321#1:404,2\n322#1:406\n322#1:407,2\n336#1:409\n336#1:410,3\n*E\n"})
public final class StrikeFinder
implements Flow<PricedOption> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IRememberMarketDataFlow aboFlow;
    @NotNull
    private final IConfiguration cfg;
    private final int maxTwsAbos;
    @NotNull
    private final OptionChain optionchain;
    @Nullable
    private Option below;
    @Nullable
    private Option above;
    private FlowCollector<? super PricedOption> collector;
    @NotNull
    private static final Logger logger;
    public static final int MIN_REQUIRED_ABOS = 10;

    public StrikeFinder(@NotNull IRememberMarketDataFlow aboFlow, @NotNull List<Option> options, @NotNull IConfiguration cfg, int maxTwsAbos) {
        Intrinsics.checkNotNullParameter((Object)aboFlow, (String)"aboFlow");
        Intrinsics.checkNotNullParameter(options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)cfg, (String)"cfg");
        this.aboFlow = aboFlow;
        this.cfg = cfg;
        this.maxTwsAbos = maxTwsAbos;
        this.optionchain = new OptionChain(options);
        if (!(this.maxTwsAbos >= 10)) {
            boolean bl = false;
            String string = "Der Algorithmus ben\u00f6tigt mindestens 10 TWS-Subscription - es sind aber nur " + this.maxTwsAbos;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public /* synthetic */ StrikeFinder(IRememberMarketDataFlow iRememberMarketDataFlow, List list, IConfiguration iConfiguration, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 10;
        }
        this(iRememberMarketDataFlow, list, iConfiguration, n);
    }

    @NotNull
    public final IRememberMarketDataFlow getAboFlow() {
        return this.aboFlow;
    }

    private final List<Option> getOptionAbos() {
        List<Contract> list = this.aboFlow.getAbos();
        Intrinsics.checkNotNull(list, (String)"null cannot be cast to non-null type kotlin.collections.List<com.xorrus.trading.common.contract.Option>");
        return list;
    }

    @NotNull
    public final OptionChain getOptionchain$tws_api() {
        return this.optionchain;
    }

    @Nullable
    public final Option getBelow$tws_api() {
        return this.below;
    }

    public final void setBelow$tws_api(@Nullable Option option) {
        this.below = option;
    }

    @Nullable
    public final Option getAbove$tws_api() {
        return this.above;
    }

    public final void setAbove$tws_api(@Nullable Option option) {
        this.above = option;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Object onTickUpdate(IMarketDataFlow.TickData tickData, Continuation<? super Unit> $completion) {
        PricedOption pricedOption;
        StrikeFinder strikeFinder = this;
        synchronized (strikeFinder) {
            PricedOption found;
            Collection<XBigNum> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            boolean bl = false;
            Object[] objectArray = new Object[]{tickData.getPrice(), tickData.getTickType().name(), tickData.getContract()};
            logger.debug("onTickUpdate: {} {} {}", objectArray);
            this.updateStrikeBounds(tickData);
            this.updateSubscriptions();
            objectArray = new Object[3];
            Option option = this.below;
            objectArray[0] = option != null ? option.getStrike() : null;
            Option option2 = this.above;
            objectArray[1] = option2 != null ? option2.getStrike() : null;
            Iterable iterable = this.getOptionAbos();
            int n = 2;
            Object[] objectArray2 = objectArray;
            String string = "{} / {} abos = {} ";
            Logger logger = StrikeFinder.logger;
            boolean $i$f$map = false;
            void var13_14 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Option option3 = (Option)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getStrike());
            }
            collection = (List)destination$iv$iv;
            objectArray2[n] = CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)collection), null, null, null, (int)0, null, null, (int)63, null);
            logger.debug(string, objectArray);
            pricedOption = found = this.findTargetOption();
        }
        PricedOption found = pricedOption;
        if (found != null) {
            FlowCollector<? super PricedOption> flowCollector = this.collector;
            if (flowCollector == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"collector");
                flowCollector = null;
            }
            Object object = flowCollector.emit((Object)found, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    private final PricedOption findTargetOption() {
        block11: {
            if (this.below == null || this.above == null) {
                return null;
            }
            v0 = this.below;
            Intrinsics.checkNotNull((Object)v0);
            belowBid = this.aboFlow.getPrice((Contract)v0, TickType.BID);
            v1 = this.below;
            Intrinsics.checkNotNull((Object)v1);
            belowAsk = this.aboFlow.getPrice((Contract)v1, TickType.ASK);
            v2 = this.above;
            Intrinsics.checkNotNull((Object)v2);
            aboveBid = this.aboFlow.getPrice((Contract)v2, TickType.BID);
            v3 = this.above;
            Intrinsics.checkNotNull((Object)v3);
            aboveAsk = this.aboFlow.getPrice((Contract)v3, TickType.ASK);
            if (belowBid == null || belowAsk == null || aboveBid == null || aboveAsk == null) {
                return null;
            }
            v4 = this.above;
            Intrinsics.checkNotNull((Object)v4);
            abovePriced = new PricedOption(v4, aboveBid.getPrice(), aboveAsk.getPrice());
            v5 = this.below;
            Intrinsics.checkNotNull((Object)v5);
            belowPriced = new PricedOption(v5, belowBid.getPrice(), belowAsk.getPrice());
            if (this.optionchain.areNeighbors(this.above, this.below)) {
                return this.cfg.selectSolution(belowPriced, abovePriced);
            }
            var8_7 = this.optionchain.getOptions();
            $i$f$filter = false;
            var10_9 = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Option)element$iv$iv;
                $i$a$-filter-StrikeFinder$findTargetOption$noAnswerFromBetweenOptions$1 = false;
                v6 = it.getStrike();
                v7 = this.below;
                Intrinsics.checkNotNull((Object)v7);
                if (v6.compareTo(v7.getStrike()) <= 0) ** GOTO lbl-1000
                v8 = it.getStrike();
                v9 = this.above;
                Intrinsics.checkNotNull((Object)v9);
                if (v8.compareTo(v9.getStrike()) < 0) {
                    v10 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v10 = false;
                }
                if (!v10) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v11 = true;
            } else {
                for (T element$iv : $this$all$iv) {
                    option = (Option)element$iv;
                    $i$a$-all-StrikeFinder$findTargetOption$noAnswerFromBetweenOptions$2 = false;
                    if (!this.aboFlow.getAbos().contains(option)) {
                        v12 = false;
                    } else {
                        bidTickData = this.aboFlow.getPrice((Contract)option, TickType.BID);
                        askTickData = this.aboFlow.getPrice((Contract)option, TickType.ASK);
                        v12 = bidTickData == null || askTickData == null ? false : (this.cfg.evaluate(bidTickData) != StrikeComparison.NO_ANSWER ? false : this.cfg.evaluate(askTickData) == StrikeComparison.NO_ANSWER);
                    }
                    if (v12) continue;
                    v11 = false;
                    break block11;
                }
                v11 = true;
            }
        }
        noAnswerFromBetweenOptions = v11;
        return noAnswerFromBetweenOptions != false ? this.calculateTargetOption(belowPriced, abovePriced) : null;
    }

    private final PricedOption calculateTargetOption(PricedOption belowPriced, PricedOption abovePriced) {
        XBigNum xBigNum = belowPriced.getAsk();
        Intrinsics.checkNotNull((Object)xBigNum);
        XBigNum xBigNum2 = belowPriced.getBid();
        Intrinsics.checkNotNull((Object)xBigNum2);
        XBigNum l1 = xBigNum.minus(xBigNum2);
        XBigNum xBigNum3 = abovePriced.getAsk();
        Intrinsics.checkNotNull((Object)xBigNum3);
        XBigNum xBigNum4 = abovePriced.getBid();
        Intrinsics.checkNotNull((Object)xBigNum4);
        XBigNum l2 = xBigNum3.minus(xBigNum4);
        Option option = this.below;
        Intrinsics.checkNotNull((Object)option);
        XBigNum x1 = option.getStrike();
        Option option2 = this.above;
        Intrinsics.checkNotNull((Object)option2);
        XBigNum x2 = option2.getStrike();
        XBigNum strike = x2.times(l1).plus(x1.times(l2)).div(l1.plus(l2));
        Option option3 = this.optionchain.nearestStrike(strike);
        IMarketDataFlow.TickData tickData = this.aboFlow.getPrice((Contract)option3, TickType.BID);
        Intrinsics.checkNotNull((Object)tickData);
        XBigNum xBigNum5 = tickData.getPrice();
        IMarketDataFlow.TickData tickData2 = this.aboFlow.getPrice((Contract)option3, TickType.ASK);
        Intrinsics.checkNotNull((Object)tickData2);
        return new PricedOption(option3, xBigNum5, tickData2.getPrice());
    }

    @Nullable
    public Object collect(@NotNull FlowCollector<? super PricedOption> collector2, @NotNull Continuation<? super Unit> $completion) {
        this.collector = collector2;
        Object object = FlowKt.onCompletion((Flow)FlowKt.onStart((Flow)this.aboFlow, (Function2)((Function2)new Function2<FlowCollector<? super IMarketDataFlow.TickData>, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ StrikeFinder this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        StrikeFinder.access$addSubscriptions(this.this$0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(FlowCollector<? super IMarketDataFlow.TickData> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (Function3)((Function3)new Function3<FlowCollector<? super IMarketDataFlow.TickData>, Throwable, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ StrikeFinder this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$forEach$iv;
                        ResultKt.throwOnFailure((Object)$result);
                        Iterable iterable = StrikeFinder.access$getOptionAbos(this.this$0);
                        StrikeFinder strikeFinder = this.this$0;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            Option option = (Option)element$iv;
                            boolean bl = false;
                            strikeFinder.getAboFlow().removeAbo((Contract)option);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(FlowCollector<? super IMarketDataFlow.TickData> p1, Throwable p2, Continuation<? super Unit> p3) {
                return new /* invalid duplicate definition of identical inner class */.invokeSuspend(Unit.INSTANCE);
            }
        })).collect(new FlowCollector(this){
            final /* synthetic */ StrikeFinder this$0;
            {
                this.this$0 = $receiver;
            }

            public final Object emit(IMarketDataFlow.TickData tickData, Continuation<? super Unit> $completion) {
                Object object = StrikeFinder.access$onTickUpdate(this.this$0, tickData, $completion);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        }, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void updateStrikeTooLow(Option option) {
        block6: {
            block5: {
                if (this.below == null) break block5;
                XBigNum xBigNum = option.getStrike();
                Option option2 = this.below;
                Intrinsics.checkNotNull((Object)option2);
                if (xBigNum.compareTo(option2.getStrike()) <= 0) break block6;
            }
            this.below = option;
            if (this.above != null) {
                Option option3 = this.below;
                Intrinsics.checkNotNull((Object)option3);
                XBigNum xBigNum = option3.getStrike();
                Option option4 = this.above;
                Intrinsics.checkNotNull((Object)option4);
                if (xBigNum.compareTo(option4.getStrike()) >= 0) {
                    Option option5 = this.below;
                    Intrinsics.checkNotNull((Object)option5);
                    this.above = this.optionchain.getAbove(option5);
                }
            }
        }
    }

    private final void updateStrikeTooHigh(Option option) {
        block6: {
            block5: {
                if (this.above == null) break block5;
                XBigNum xBigNum = option.getStrike();
                Option option2 = this.above;
                Intrinsics.checkNotNull((Object)option2);
                if (xBigNum.compareTo(option2.getStrike()) >= 0) break block6;
            }
            this.above = option;
            if (this.below != null) {
                Option option3 = this.above;
                Intrinsics.checkNotNull((Object)option3);
                XBigNum xBigNum = option3.getStrike();
                Option option4 = this.below;
                Intrinsics.checkNotNull((Object)option4);
                if (xBigNum.compareTo(option4.getStrike()) <= 0) {
                    Option option5 = this.above;
                    Intrinsics.checkNotNull((Object)option5);
                    this.below = this.optionchain.getBelow(option5);
                }
            }
        }
    }

    private final void updateStrikeBounds(IMarketDataFlow.TickData tickData) {
        StrikeComparison result = this.cfg.evaluate(tickData);
        if (!(tickData.getContract() instanceof Option)) {
            boolean bl = false;
            String string = "TickData.contract muss vom Typ Option sein, sonst kann keine Grenze aktualisiert werden";
            throw new IllegalArgumentException(string.toString());
        }
        switch (WhenMappings.$EnumSwitchMapping$0[result.ordinal()]) {
            case 1: {
                this.updateStrikeTooLow((Option)tickData.getContract());
                break;
            }
            case 2: {
                this.updateStrikeTooHigh((Option)tickData.getContract());
                break;
            }
            case 3: {
                return;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void updateSubscriptions() {
        this.removeUnnecessarySubscriptions();
        this.addSubscriptions();
    }

    /*
     * WARNING - void declaration
     */
    private final void removeUnnecessarySubscriptions() {
        Collection<XBigNum> collection;
        Object item$iv$iv;
        Iterator iterator;
        Iterator $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        void $this$map$iv;
        boolean $i$f$map;
        Logger logger;
        String string;
        Option it;
        void $this$filterTo$iv$iv;
        Option maximum = this.getOptionAboveUpperBound$tws_api();
        Option minimum = this.getOptionBelowLowerBound$tws_api();
        Iterable $this$filter$iv = this.getOptionAbos();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Option)element$iv$iv;
            boolean bl = false;
            if (!(minimum != null && it.getStrike().compareTo(minimum.getStrike()) < 0 || maximum != null && it.getStrike().compareTo(maximum.getStrike()) > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List unnecessarySubscriptions = (List)destination$iv$iv;
        if (!((Collection)unnecessarySubscriptions).isEmpty()) {
            $this$filter$iv = unnecessarySubscriptions;
            string = "Uninteressante Abos l\u00f6schen: {}";
            logger = StrikeFinder.logger;
            $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                item$iv$iv = iterator.next();
                it = (Option)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getStrike());
            }
            collection = (List)destination$iv$iv;
            logger.debug(string, (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)collection), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        }
        Iterable $this$forEach$iv = unnecessarySubscriptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Option option = (Option)element$iv;
            boolean bl = false;
            this.aboFlow.removeAbo((Contract)option);
        }
        $this$forEach$iv = this.getOptionAbos();
        string = "Alle Abos: {}";
        logger = StrikeFinder.logger;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it = (Option)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getStrike());
        }
        collection = (List)destination$iv$iv;
        logger.debug(string, (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)collection), (CharSequence)", ", null, null, (int)0, null, StrikeFinder::removeUnnecessarySubscriptions$lambda$4, (int)30, null));
    }

    private final int getAvailableAbos() {
        return this.maxTwsAbos - ((Collection)this.aboFlow.getAbos()).size();
    }

    /*
     * WARNING - void declaration
     */
    private final void addSubscriptions() {
        Option it;
        Collection<XBigNum> collection;
        Object item$iv$iv;
        Iterator iterator;
        Iterator $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        void $this$map$iv;
        boolean $i$f$map;
        Logger logger;
        String string;
        if (this.getAvailableAbos() <= 0) {
            return;
        }
        List<Option> nextAboStrikes = this.selectUnsubscribedStrikes$tws_api(this.getAvailableAbos());
        if (!((Collection)nextAboStrikes).isEmpty()) {
            Iterable iterable = nextAboStrikes;
            string = "Neue Abos: {}";
            logger = StrikeFinder.logger;
            $i$f$map = false;
            void var4_6 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                item$iv$iv = iterator.next();
                Option option = (Option)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getStrike());
            }
            collection = (List)destination$iv$iv;
            logger.debug(string, (Object)CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        }
        Iterable $this$forEach$iv = nextAboStrikes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Option option = (Option)element$iv;
            boolean bl = false;
            this.aboFlow.addAbo((Contract)option);
        }
        $this$forEach$iv = this.getOptionAbos();
        string = "Alle Abos: {}";
        logger = StrikeFinder.logger;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            item$iv$iv = iterator.next();
            it = (Option)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getStrike());
        }
        collection = (List)destination$iv$iv;
        logger.debug(string, (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)collection), (CharSequence)", ", null, null, (int)0, null, StrikeFinder::addSubscriptions$lambda$3, (int)30, null));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Option> selectUnsubscribedStrikes$tws_api(int newAbos) {
        void $this$mapTo$iv$iv;
        Option it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        if (!(newAbos >= 1)) {
            boolean $i$a$-require-StrikeFinder$selectUnsubscribedStrikes$22 = false;
            String $i$a$-require-StrikeFinder$selectUnsubscribedStrikes$22 = "maxAbos muss mindestens 1 sein";
            throw new IllegalArgumentException($i$a$-require-StrikeFinder$selectUnsubscribedStrikes$22.toString());
        }
        if (this.optionchain.areNeighbors(this.below, this.above)) {
            void $this$filterTo$iv$iv2;
            Object[] objectArray = new Option[4];
            objectArray[0] = this.below;
            objectArray[1] = this.above;
            Option option = this.below;
            Intrinsics.checkNotNull((Object)option);
            objectArray[2] = this.optionchain.getBelow(option);
            Option option2 = this.above;
            Intrinsics.checkNotNull((Object)option2);
            objectArray[3] = this.optionchain.getAbove(option2);
            Iterable $this$filter$iv2 = CollectionsKt.listOfNotNull((Object[])objectArray);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv2;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Option it2 = (Option)element$iv$iv;
                boolean bl = false;
                if (!(!this.aboFlow.getAbos().contains(it2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        Option max = this.above;
        Option min = this.below;
        Iterable destination$iv$iv = this.optionchain.getOptions();
        boolean $i$f$filter = false;
        void var7_16 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Option)element$iv$iv;
            boolean bl = false;
            if (!(!this.aboFlow.getAbos().contains(it))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Option)element$iv$iv;
            boolean bl = false;
            if (!(min == null || min.getStrike().compareTo(it.getStrike()) <= 0)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Option)element$iv$iv;
            boolean bl = false;
            if (!(max == null || it.getStrike().compareTo(max.getStrike()) <= 0)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List options = (List)destination$iv$iv2;
        if (options.size() <= newAbos) {
            return options;
        }
        double step = (double)options.size() / (double)(newAbos - 1);
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)newAbos);
        boolean $i$f$map = false;
        Iterable $i$f$filterTo2 = $this$map$iv;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void aboNumber;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv3;
            boolean bl = false;
            int index = RangesKt.coerceAtMost((int)((int)((double)aboNumber * step)), (int)CollectionsKt.getLastIndex((List)options));
            collection.add((Option)options.get(index));
        }
        return (List)destination$iv$iv3;
    }

    @Nullable
    public final Option getOptionAboveUpperBound$tws_api() {
        Option option;
        Option option2 = this.above;
        if (option2 != null) {
            Option it = option2;
            boolean bl = false;
            option = this.optionchain.getAbove(it);
        } else {
            option = null;
        }
        return option;
    }

    @Nullable
    public final Option getOptionBelowLowerBound$tws_api() {
        Option option;
        Option option2 = this.below;
        if (option2 != null) {
            Option it = option2;
            boolean bl = false;
            option = this.optionchain.getBelow(it);
        } else {
            option = null;
        }
        return option;
    }

    private static final CharSequence removeUnnecessarySubscriptions$lambda$4(XBigNum it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    private static final CharSequence addSubscriptions$lambda$3(XBigNum it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.toString();
    }

    public static final /* synthetic */ Object access$onTickUpdate(StrikeFinder $this, IMarketDataFlow.TickData tickData, Continuation $completion) {
        return $this.onTickUpdate(tickData, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ void access$addSubscriptions(StrikeFinder $this) {
        $this.addSubscriptions();
    }

    public static final /* synthetic */ List access$getOptionAbos(StrikeFinder $this) {
        return $this.getOptionAbos();
    }

    static {
        Logger logger = LoggerFactory.getLogger(StrikeFinder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        StrikeFinder.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/xorrus/trading/ib/tws/price/StrikeFinder$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "MIN_REQUIRED_ABOS", "", "tws-api"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/xorrus/trading/ib/tws/price/StrikeFinder$HighestCallStrike;", "Lcom/xorrus/trading/ib/tws/price/StrikeFinder$IConfiguration;", "priceLimit", "Lcom/xorrus/trading/common/bignum/XBigNum;", "<init>", "(Lcom/xorrus/trading/common/bignum/XBigNum;)V", "getPriceLimit", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "evaluate", "Lcom/xorrus/trading/ib/tws/price/StrikeFinder$StrikeComparison;", "tickData", "Lcom/xorrus/trading/ib/tws/price/IMarketDataFlow$TickData;", "selectSolution", "Lcom/xorrus/trading/ib/tws/price/PricedOption;", "strikeBelow", "strikeAbove", "tws-api"})
    public static final class HighestCallStrike
    implements IConfiguration {
        @NotNull
        private final XBigNum priceLimit;

        public HighestCallStrike(@NotNull XBigNum priceLimit) {
            Intrinsics.checkNotNullParameter((Object)priceLimit, (String)"priceLimit");
            this.priceLimit = priceLimit;
        }

        @NotNull
        public final XBigNum getPriceLimit() {
            return this.priceLimit;
        }

        @Override
        @NotNull
        public StrikeComparison evaluate(@NotNull IMarketDataFlow.TickData tickData) {
            Intrinsics.checkNotNullParameter((Object)tickData, (String)"tickData");
            return tickData.getPrice() == null ? StrikeComparison.NO_ANSWER : (tickData.getTickType() == TickType.BID && tickData.getPrice().compareTo(this.priceLimit) >= 0 ? StrikeComparison.STRIKE_TOO_LOW : (tickData.getTickType() == TickType.ASK && tickData.getPrice().compareTo(this.priceLimit) <= 0 ? StrikeComparison.STRIKE_TOO_HIGH : StrikeComparison.NO_ANSWER));
        }

        @Override
        @NotNull
        public PricedOption selectSolution(@NotNull PricedOption strikeBelow, @NotNull PricedOption strikeAbove) {
            Intrinsics.checkNotNullParameter((Object)strikeBelow, (String)"strikeBelow");
            Intrinsics.checkNotNullParameter((Object)strikeAbove, (String)"strikeAbove");
            return strikeBelow;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H&\u00a8\u0006\n\u00c0\u0006\u0003"}, d2={"Lcom/xorrus/trading/ib/tws/price/StrikeFinder$IConfiguration;", "", "evaluate", "Lcom/xorrus/trading/ib/tws/price/StrikeFinder$StrikeComparison;", "tickData", "Lcom/xorrus/trading/ib/tws/price/IMarketDataFlow$TickData;", "selectSolution", "Lcom/xorrus/trading/ib/tws/price/PricedOption;", "strikeBelow", "strikeAbove", "tws-api"})
    public static interface IConfiguration {
        @NotNull
        public StrikeComparison evaluate(@NotNull IMarketDataFlow.TickData var1);

        @NotNull
        public PricedOption selectSolution(@NotNull PricedOption var1, @NotNull PricedOption var2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/xorrus/trading/ib/tws/price/StrikeFinder$LowestPutStrike;", "Lcom/xorrus/trading/ib/tws/price/StrikeFinder$IConfiguration;", "priceLimit", "Lcom/xorrus/trading/common/bignum/XBigNum;", "<init>", "(Lcom/xorrus/trading/common/bignum/XBigNum;)V", "getPriceLimit", "()Lcom/xorrus/trading/common/bignum/XBigNum;", "evaluate", "Lcom/xorrus/trading/ib/tws/price/StrikeFinder$StrikeComparison;", "tickData", "Lcom/xorrus/trading/ib/tws/price/IMarketDataFlow$TickData;", "selectSolution", "Lcom/xorrus/trading/ib/tws/price/PricedOption;", "strikeBelow", "strikeAbove", "tws-api"})
    public static final class LowestPutStrike
    implements IConfiguration {
        @NotNull
        private final XBigNum priceLimit;

        public LowestPutStrike(@NotNull XBigNum priceLimit) {
            Intrinsics.checkNotNullParameter((Object)priceLimit, (String)"priceLimit");
            this.priceLimit = priceLimit;
        }

        @NotNull
        public final XBigNum getPriceLimit() {
            return this.priceLimit;
        }

        @Override
        @NotNull
        public StrikeComparison evaluate(@NotNull IMarketDataFlow.TickData tickData) {
            Intrinsics.checkNotNullParameter((Object)tickData, (String)"tickData");
            return tickData.getPrice() == null ? StrikeComparison.NO_ANSWER : (tickData.getTickType() == TickType.BID && tickData.getPrice().compareTo(this.priceLimit) >= 0 ? StrikeComparison.STRIKE_TOO_HIGH : (tickData.getTickType() == TickType.ASK && tickData.getPrice().compareTo(this.priceLimit) <= 0 ? StrikeComparison.STRIKE_TOO_LOW : StrikeComparison.NO_ANSWER));
        }

        @Override
        @NotNull
        public PricedOption selectSolution(@NotNull PricedOption strikeBelow, @NotNull PricedOption strikeAbove) {
            Intrinsics.checkNotNullParameter((Object)strikeBelow, (String)"strikeBelow");
            Intrinsics.checkNotNullParameter((Object)strikeAbove, (String)"strikeAbove");
            return strikeAbove;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/xorrus/trading/ib/tws/price/StrikeFinder$StrikeComparison;", "", "<init>", "(Ljava/lang/String;I)V", "STRIKE_TOO_LOW", "STRIKE_TOO_HIGH", "NO_ANSWER", "tws-api"})
    public static final class StrikeComparison
    extends Enum<StrikeComparison> {
        public static final /* enum */ StrikeComparison STRIKE_TOO_LOW = new StrikeComparison();
        public static final /* enum */ StrikeComparison STRIKE_TOO_HIGH = new StrikeComparison();
        public static final /* enum */ StrikeComparison NO_ANSWER = new StrikeComparison();
        private static final /* synthetic */ StrikeComparison[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static StrikeComparison[] values() {
            return (StrikeComparison[])$VALUES.clone();
        }

        public static StrikeComparison valueOf(String value) {
            return Enum.valueOf(StrikeComparison.class, value);
        }

        @NotNull
        public static EnumEntries<StrikeComparison> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = strikeComparisonArray = new StrikeComparison[]{StrikeComparison.STRIKE_TOO_LOW, StrikeComparison.STRIKE_TOO_HIGH, StrikeComparison.NO_ANSWER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[StrikeComparison.values().length];
            try {
                nArray[StrikeComparison.STRIKE_TOO_LOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StrikeComparison.STRIKE_TOO_HIGH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StrikeComparison.NO_ANSWER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

