/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.ib.tws.api.request;

import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Right;
import com.xorrus.trading.ib.tws.api.TwsApiVersion;
import com.xorrus.trading.ib.tws.api.TwsApiVersionKt;
import com.xorrus.trading.ib.tws.api.TwsCommunicationState;
import com.xorrus.trading.ib.tws.api.UtilsKt;
import com.xorrus.trading.ib.tws.api.request.ReqHeadTimestampRequest;
import com.xorrus.trading.ib.tws.api.request.TwsRequest;
import com.xorrus.trading.ib.tws.api.stream.TwsInputStream;
import com.xorrus.trading.ib.tws.api.stream.TwsOutputStream;
import com.xorrus.trading.ib.tws.api.type.Contract;
import com.xorrus.trading.ib.tws.api.type.IContract;
import com.xorrus.trading.ib.tws.api.type.Right_exKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001#B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0096@\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0014\u0010\u0018\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006$"}, d2={"Lcom/xorrus/trading/ib/tws/api/request/ReqHeadTimestampRequest;", "Lcom/xorrus/trading/ib/tws/api/request/TwsRequest;", "requestId", "", "contract", "Lcom/xorrus/trading/ib/tws/api/type/IContract;", "includeExpired", "", "useRTH", "whatToShow", "", "formatDate", "<init>", "(ILcom/xorrus/trading/ib/tws/api/type/IContract;ZZLjava/lang/String;I)V", "getRequestId", "()I", "getContract", "()Lcom/xorrus/trading/ib/tws/api/type/IContract;", "getIncludeExpired", "()Z", "getUseRTH", "getWhatToShow", "()Ljava/lang/String;", "getFormatDate", "messageId", "getMessageId", "()Ljava/lang/Integer;", "writeParameter", "", "ostream", "Lcom/xorrus/trading/ib/tws/api/stream/TwsOutputStream;", "state", "Lcom/xorrus/trading/ib/tws/api/TwsCommunicationState;", "(Lcom/xorrus/trading/ib/tws/api/stream/TwsOutputStream;Lcom/xorrus/trading/ib/tws/api/TwsCommunicationState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "Parser", "tws-api"})
public final class ReqHeadTimestampRequest
implements TwsRequest {
    private final int requestId;
    @NotNull
    private final IContract contract;
    private final boolean includeExpired;
    private final boolean useRTH;
    @Nullable
    private final String whatToShow;
    private final int formatDate;

    public ReqHeadTimestampRequest(int requestId, @NotNull IContract contract, boolean includeExpired, boolean useRTH, @Nullable String whatToShow, int formatDate) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        this.requestId = requestId;
        this.contract = contract;
        this.includeExpired = includeExpired;
        this.useRTH = useRTH;
        this.whatToShow = whatToShow;
        this.formatDate = formatDate;
    }

    public final int getRequestId() {
        return this.requestId;
    }

    @NotNull
    public final IContract getContract() {
        return this.contract;
    }

    public final boolean getIncludeExpired() {
        return this.includeExpired;
    }

    public final boolean getUseRTH() {
        return this.useRTH;
    }

    @Nullable
    public final String getWhatToShow() {
        return this.whatToShow;
    }

    public final int getFormatDate() {
        return this.formatDate;
    }

    @Override
    @NotNull
    public Integer getMessageId() {
        return Parser.INSTANCE.getMessageId();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object writeParameter(@NotNull TwsOutputStream ostream, @NotNull TwsCommunicationState state, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof writeParameter.1)) ** GOTO lbl-1000
        var6_4 = $completion;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ReqHeadTimestampRequest this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.writeParameter(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = state.getApiVersion();
                Intrinsics.checkNotNull((Object)v0);
                if (!(TwsApiVersionKt.compareTo(v0, TwsApiVersion.MIN_SERVER_VER_REQ_HEAD_TIMESTAMP) >= 0)) {
                    var4_7 = "Failed requirement.";
                    throw new IllegalArgumentException(var4_7.toString());
                }
                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 1;
                v1 = ostream.writeInt(Boxing.boxInt((int)this.requestId), (Continuation<? super Unit>)$continuation);
                if (v1 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl29
            }
            case 1: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl29:
                // 2 sources

                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 2;
                v2 = ostream.writeInt(this.contract.getConId(), (Continuation<? super Unit>)$continuation);
                if (v2 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl41
            }
            case 2: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl41:
                // 2 sources

                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 3;
                v3 = TwsOutputStream.writeString$default(ostream, this.contract.getSymbol(), null, (Continuation)$continuation, 2, null);
                if (v3 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl53
            }
            case 3: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl53:
                // 2 sources

                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 4;
                v4 = TwsOutputStream.writeString$default(ostream, this.contract.getSecType(), null, (Continuation)$continuation, 2, null);
                if (v4 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl65
            }
            case 4: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl65:
                // 2 sources

                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 5;
                v5 = TwsOutputStream.writeString$default(ostream, this.contract.getLastTradeDateOrContractMonth(), null, (Continuation)$continuation, 2, null);
                if (v5 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl77
            }
            case 5: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl77:
                // 2 sources

                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 6;
                v6 = ostream.writeDecimal(this.contract.getStrike(), (Continuation<? super Unit>)$continuation);
                if (v6 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl89
            }
            case 6: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl89:
                // 2 sources

                v7 = this.contract.getRight();
                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 7;
                v8 = TwsOutputStream.writeString$default(ostream, v7 != null ? Right_exKt.toTwsApi(v7) : null, null, (Continuation)$continuation, 2, null);
                if (v8 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl102
            }
            case 7: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v8 = $result;
lbl102:
                // 2 sources

                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 8;
                v9 = TwsOutputStream.writeString$default(ostream, this.contract.getMultiplier(), null, (Continuation)$continuation, 2, null);
                if (v9 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl114
            }
            case 8: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v9 = $result;
lbl114:
                // 2 sources

                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 9;
                v10 = TwsOutputStream.writeString$default(ostream, this.contract.getExchange(), null, (Continuation)$continuation, 2, null);
                if (v10 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl126
            }
            case 9: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v10 = $result;
lbl126:
                // 2 sources

                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 10;
                v11 = TwsOutputStream.writeString$default(ostream, this.contract.getPrimaryExchange(), null, (Continuation)$continuation, 2, null);
                if (v11 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl138
            }
            case 10: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v11 = $result;
lbl138:
                // 2 sources

                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 11;
                v12 = TwsOutputStream.writeString$default(ostream, this.contract.getCurrency(), null, (Continuation)$continuation, 2, null);
                if (v12 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl150
            }
            case 11: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v12 = $result;
lbl150:
                // 2 sources

                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 12;
                v13 = TwsOutputStream.writeString$default(ostream, this.contract.getLocalSymbol(), null, (Continuation)$continuation, 2, null);
                if (v13 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl162
            }
            case 12: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v13 = $result;
lbl162:
                // 2 sources

                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 13;
                v14 = TwsOutputStream.writeString$default(ostream, this.contract.getTradingClass(), null, (Continuation)$continuation, 2, null);
                if (v14 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl174
            }
            case 13: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v14 = $result;
lbl174:
                // 2 sources

                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 14;
                v15 = ostream.writeBoolean(Boxing.boxBoolean((boolean)this.includeExpired), (Continuation<? super Unit>)$continuation);
                if (v15 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl186
            }
            case 14: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v15 = $result;
lbl186:
                // 2 sources

                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 15;
                v16 = ostream.writeBoolean(Boxing.boxBoolean((boolean)this.useRTH), (Continuation<? super Unit>)$continuation);
                if (v16 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl198
            }
            case 15: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v16 = $result;
lbl198:
                // 2 sources

                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 16;
                v17 = TwsOutputStream.writeString$default(ostream, this.whatToShow, null, (Continuation)$continuation, 2, null);
                if (v17 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl210
            }
            case 16: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v17 = $result;
lbl210:
                // 2 sources

                $continuation.L$0 = ostream;
                $continuation.L$1 = state;
                $continuation.label = 17;
                v18 = ostream.writeInt(Boxing.boxInt((int)this.formatDate), (Continuation<? super Unit>)$continuation);
                if (v18 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl222
            }
            case 17: {
                state = (TwsCommunicationState)$continuation.L$1;
                ostream = (TwsOutputStream)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v18 = $result;
lbl222:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$toString_u24lambda_u240.append("reqHeadTimestamp(");
        $this$toString_u24lambda_u240.append("requestId = " + this.requestId + ", ");
        $this$toString_u24lambda_u240.append("conId = " + this.contract.getConId() + ", ");
        $this$toString_u24lambda_u240.append("symbol = " + UtilsKt.toSourceCode(this.contract.getSymbol()) + ", ");
        $this$toString_u24lambda_u240.append("secType = " + UtilsKt.toSourceCode(this.contract.getSecType()) + ", ");
        $this$toString_u24lambda_u240.append("lastTradeDateOrContractMonth = " + UtilsKt.toSourceCode(this.contract.getLastTradeDateOrContractMonth()) + ", ");
        $this$toString_u24lambda_u240.append("strike = " + this.contract.getStrike() + ", ");
        $this$toString_u24lambda_u240.append("right = " + this.contract.getRight() + ", ");
        $this$toString_u24lambda_u240.append("multiplier = " + UtilsKt.toSourceCode(this.contract.getMultiplier()) + ", ");
        $this$toString_u24lambda_u240.append("exchange = " + UtilsKt.toSourceCode(this.contract.getExchange()) + ", ");
        $this$toString_u24lambda_u240.append("primaryExchange = " + UtilsKt.toSourceCode(this.contract.getPrimaryExchange()) + ", ");
        $this$toString_u24lambda_u240.append("currency = " + UtilsKt.toSourceCode(this.contract.getCurrency()) + ", ");
        $this$toString_u24lambda_u240.append("localSymbol = " + UtilsKt.toSourceCode(this.contract.getLocalSymbol()) + ", ");
        $this$toString_u24lambda_u240.append("tradingClass = " + UtilsKt.toSourceCode(this.contract.getTradingClass()) + ", ");
        $this$toString_u24lambda_u240.append("includeExpired = " + this.includeExpired + ", ");
        $this$toString_u24lambda_u240.append("useRTH = " + this.useRTH + ", ");
        $this$toString_u24lambda_u240.append("whatToShow = " + UtilsKt.toSourceCode(this.whatToShow) + ", ");
        $this$toString_u24lambda_u240.append("formatDate = " + this.formatDate + ")");
        return stringBuilder.toString();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lcom/xorrus/trading/ib/tws/api/request/ReqHeadTimestampRequest$Parser;", "Lcom/xorrus/trading/ib/tws/api/request/TwsRequest$Parser;", "<init>", "()V", "messageId", "", "getMessageId", "()I", "parseParameter", "Lcom/xorrus/trading/ib/tws/api/request/ReqHeadTimestampRequest;", "istream", "Lcom/xorrus/trading/ib/tws/api/stream/TwsInputStream;", "state", "Lcom/xorrus/trading/ib/tws/api/TwsCommunicationState;", "(Lcom/xorrus/trading/ib/tws/api/stream/TwsInputStream;Lcom/xorrus/trading/ib/tws/api/TwsCommunicationState;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "tws-api"})
    public static final class Parser
    implements TwsRequest.Parser {
        @NotNull
        public static final Parser INSTANCE = new Parser();

        private Parser() {
        }

        @Override
        public int getMessageId() {
            return 87;
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public Object parseParameter(@NotNull TwsInputStream istream, @NotNull TwsCommunicationState state, @NotNull Continuation<? super ReqHeadTimestampRequest> $completion) {
            if (!($completion instanceof parseParameter.1)) ** GOTO lbl-1000
            var23_4 = $completion;
            if ((var23_4.label & -2147483648) != 0) {
                var23_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    Object L$4;
                    Object L$5;
                    Object L$6;
                    Object L$7;
                    Object L$8;
                    Object L$9;
                    Object L$10;
                    Object L$11;
                    Object L$12;
                    Object L$13;
                    int I$0;
                    int I$1;
                    boolean Z$0;
                    boolean Z$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ Parser this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.parseParameter((TwsInputStream)null, (TwsCommunicationState)null, (Continuation<? super ReqHeadTimestampRequest>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var24_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = state.getApiVersion();
                    Intrinsics.checkNotNull((Object)v0);
                    if (!(TwsApiVersionKt.compareTo(v0, TwsApiVersion.MIN_SERVER_VER_REQ_HEAD_TIMESTAMP) >= 0)) {
                        var5_7 = "Failed requirement.";
                        throw new IllegalArgumentException(var5_7.toString());
                    }
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.label = 1;
                    v1 = istream.readIntNotNull((Continuation<? super Integer>)$continuation);
                    if (v1 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl29
                }
                case 1: {
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl29:
                    // 2 sources

                    tickerId = ((Number)v1).intValue();
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.I$0 = tickerId;
                    $continuation.label = 2;
                    v2 = istream.readIntNotNull((Continuation<? super Integer>)$continuation);
                    if (v2 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl44
                }
                case 2: {
                    tickerId = $continuation.I$0;
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl44:
                    // 2 sources

                    conid = ((Number)v2).intValue();
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.I$0 = tickerId;
                    $continuation.I$1 = conid;
                    $continuation.label = 3;
                    v3 = TwsInputStream.readString$default(istream, null, (Continuation)$continuation, 1, null);
                    if (v3 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl61
                }
                case 3: {
                    conid = $continuation.I$1;
                    tickerId = $continuation.I$0;
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl61:
                    // 2 sources

                    symbol = (String)v3;
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.L$2 = symbol;
                    $continuation.I$0 = tickerId;
                    $continuation.I$1 = conid;
                    $continuation.label = 4;
                    v4 = TwsInputStream.readString$default(istream, null, (Continuation)$continuation, 1, null);
                    if (v4 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl80
                }
                case 4: {
                    conid = $continuation.I$1;
                    tickerId = $continuation.I$0;
                    symbol = (String)$continuation.L$2;
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v4 = $result;
lbl80:
                    // 2 sources

                    secType = (String)v4;
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.L$2 = symbol;
                    $continuation.L$3 = secType;
                    $continuation.I$0 = tickerId;
                    $continuation.I$1 = conid;
                    $continuation.label = 5;
                    v5 = TwsInputStream.readString$default(istream, null, (Continuation)$continuation, 1, null);
                    if (v5 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl101
                }
                case 5: {
                    conid = $continuation.I$1;
                    tickerId = $continuation.I$0;
                    secType = (String)$continuation.L$3;
                    symbol = (String)$continuation.L$2;
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v5 = $result;
lbl101:
                    // 2 sources

                    lastTradeDateOrContractMonth = (String)v5;
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.L$2 = symbol;
                    $continuation.L$3 = secType;
                    $continuation.L$4 = lastTradeDateOrContractMonth;
                    $continuation.I$0 = tickerId;
                    $continuation.I$1 = conid;
                    $continuation.label = 6;
                    v6 = istream.readDecimal((Continuation<? super XBigNum>)$continuation);
                    if (v6 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl124
                }
                case 6: {
                    conid = $continuation.I$1;
                    tickerId = $continuation.I$0;
                    lastTradeDateOrContractMonth = (String)$continuation.L$4;
                    secType = (String)$continuation.L$3;
                    symbol = (String)$continuation.L$2;
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v6 = $result;
lbl124:
                    // 2 sources

                    strike = (XBigNum)v6;
                    var21_14 = Right.Companion;
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.L$2 = symbol;
                    $continuation.L$3 = secType;
                    $continuation.L$4 = lastTradeDateOrContractMonth;
                    $continuation.L$5 = strike;
                    $continuation.L$6 = var21_14;
                    $continuation.I$0 = tickerId;
                    $continuation.I$1 = conid;
                    $continuation.label = 7;
                    v7 = TwsInputStream.readString$default(istream, null, (Continuation)$continuation, 1, null);
                    if (v7 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl152
                }
                case 7: {
                    conid = $continuation.I$1;
                    tickerId = $continuation.I$0;
                    var21_14 = (Right.Companion)$continuation.L$6;
                    strike = (XBigNum)$continuation.L$5;
                    lastTradeDateOrContractMonth = (String)$continuation.L$4;
                    secType = (String)$continuation.L$3;
                    symbol = (String)$continuation.L$2;
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v7 = $result;
lbl152:
                    // 2 sources

                    right = Right_exKt.fromTwsApi(var21_14, (String)v7);
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.L$2 = symbol;
                    $continuation.L$3 = secType;
                    $continuation.L$4 = lastTradeDateOrContractMonth;
                    $continuation.L$5 = strike;
                    $continuation.L$6 = right;
                    $continuation.I$0 = tickerId;
                    $continuation.I$1 = conid;
                    $continuation.label = 8;
                    v8 = TwsInputStream.readString$default(istream, null, (Continuation)$continuation, 1, null);
                    if (v8 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl179
                }
                case 8: {
                    conid = $continuation.I$1;
                    tickerId = $continuation.I$0;
                    right = (Right)$continuation.L$6;
                    strike = (XBigNum)$continuation.L$5;
                    lastTradeDateOrContractMonth = (String)$continuation.L$4;
                    secType = (String)$continuation.L$3;
                    symbol = (String)$continuation.L$2;
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v8 = $result;
lbl179:
                    // 2 sources

                    multiplier = (String)v8;
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.L$2 = symbol;
                    $continuation.L$3 = secType;
                    $continuation.L$4 = lastTradeDateOrContractMonth;
                    $continuation.L$5 = strike;
                    $continuation.L$6 = right;
                    $continuation.L$7 = multiplier;
                    $continuation.I$0 = tickerId;
                    $continuation.I$1 = conid;
                    $continuation.label = 9;
                    v9 = TwsInputStream.readString$default(istream, null, (Continuation)$continuation, 1, null);
                    if (v9 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl208
                }
                case 9: {
                    conid = $continuation.I$1;
                    tickerId = $continuation.I$0;
                    multiplier = (String)$continuation.L$7;
                    right = (Right)$continuation.L$6;
                    strike = (XBigNum)$continuation.L$5;
                    lastTradeDateOrContractMonth = (String)$continuation.L$4;
                    secType = (String)$continuation.L$3;
                    symbol = (String)$continuation.L$2;
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v9 = $result;
lbl208:
                    // 2 sources

                    exchange = (String)v9;
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.L$2 = symbol;
                    $continuation.L$3 = secType;
                    $continuation.L$4 = lastTradeDateOrContractMonth;
                    $continuation.L$5 = strike;
                    $continuation.L$6 = right;
                    $continuation.L$7 = multiplier;
                    $continuation.L$8 = exchange;
                    $continuation.I$0 = tickerId;
                    $continuation.I$1 = conid;
                    $continuation.label = 10;
                    v10 = TwsInputStream.readString$default(istream, null, (Continuation)$continuation, 1, null);
                    if (v10 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl239
                }
                case 10: {
                    conid = $continuation.I$1;
                    tickerId = $continuation.I$0;
                    exchange = (String)$continuation.L$8;
                    multiplier = (String)$continuation.L$7;
                    right = (Right)$continuation.L$6;
                    strike = (XBigNum)$continuation.L$5;
                    lastTradeDateOrContractMonth = (String)$continuation.L$4;
                    secType = (String)$continuation.L$3;
                    symbol = (String)$continuation.L$2;
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v10 = $result;
lbl239:
                    // 2 sources

                    primaryExch = (String)v10;
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.L$2 = symbol;
                    $continuation.L$3 = secType;
                    $continuation.L$4 = lastTradeDateOrContractMonth;
                    $continuation.L$5 = strike;
                    $continuation.L$6 = right;
                    $continuation.L$7 = multiplier;
                    $continuation.L$8 = exchange;
                    $continuation.L$9 = primaryExch;
                    $continuation.I$0 = tickerId;
                    $continuation.I$1 = conid;
                    $continuation.label = 11;
                    v11 = TwsInputStream.readString$default(istream, null, (Continuation)$continuation, 1, null);
                    if (v11 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl272
                }
                case 11: {
                    conid = $continuation.I$1;
                    tickerId = $continuation.I$0;
                    primaryExch = (String)$continuation.L$9;
                    exchange = (String)$continuation.L$8;
                    multiplier = (String)$continuation.L$7;
                    right = (Right)$continuation.L$6;
                    strike = (XBigNum)$continuation.L$5;
                    lastTradeDateOrContractMonth = (String)$continuation.L$4;
                    secType = (String)$continuation.L$3;
                    symbol = (String)$continuation.L$2;
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v11 = $result;
lbl272:
                    // 2 sources

                    currency = (String)v11;
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.L$2 = symbol;
                    $continuation.L$3 = secType;
                    $continuation.L$4 = lastTradeDateOrContractMonth;
                    $continuation.L$5 = strike;
                    $continuation.L$6 = right;
                    $continuation.L$7 = multiplier;
                    $continuation.L$8 = exchange;
                    $continuation.L$9 = primaryExch;
                    $continuation.L$10 = currency;
                    $continuation.I$0 = tickerId;
                    $continuation.I$1 = conid;
                    $continuation.label = 12;
                    v12 = TwsInputStream.readString$default(istream, null, (Continuation)$continuation, 1, null);
                    if (v12 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl307
                }
                case 12: {
                    conid = $continuation.I$1;
                    tickerId = $continuation.I$0;
                    currency = (String)$continuation.L$10;
                    primaryExch = (String)$continuation.L$9;
                    exchange = (String)$continuation.L$8;
                    multiplier = (String)$continuation.L$7;
                    right = (Right)$continuation.L$6;
                    strike = (XBigNum)$continuation.L$5;
                    lastTradeDateOrContractMonth = (String)$continuation.L$4;
                    secType = (String)$continuation.L$3;
                    symbol = (String)$continuation.L$2;
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v12 = $result;
lbl307:
                    // 2 sources

                    localSymbol = (String)v12;
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.L$2 = symbol;
                    $continuation.L$3 = secType;
                    $continuation.L$4 = lastTradeDateOrContractMonth;
                    $continuation.L$5 = strike;
                    $continuation.L$6 = right;
                    $continuation.L$7 = multiplier;
                    $continuation.L$8 = exchange;
                    $continuation.L$9 = primaryExch;
                    $continuation.L$10 = currency;
                    $continuation.L$11 = localSymbol;
                    $continuation.I$0 = tickerId;
                    $continuation.I$1 = conid;
                    $continuation.label = 13;
                    v13 = TwsInputStream.readString$default(istream, null, (Continuation)$continuation, 1, null);
                    if (v13 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl344
                }
                case 13: {
                    conid = $continuation.I$1;
                    tickerId = $continuation.I$0;
                    localSymbol = (String)$continuation.L$11;
                    currency = (String)$continuation.L$10;
                    primaryExch = (String)$continuation.L$9;
                    exchange = (String)$continuation.L$8;
                    multiplier = (String)$continuation.L$7;
                    right = (Right)$continuation.L$6;
                    strike = (XBigNum)$continuation.L$5;
                    lastTradeDateOrContractMonth = (String)$continuation.L$4;
                    secType = (String)$continuation.L$3;
                    symbol = (String)$continuation.L$2;
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v13 = $result;
lbl344:
                    // 2 sources

                    tradingClass = (String)v13;
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.L$2 = symbol;
                    $continuation.L$3 = secType;
                    $continuation.L$4 = lastTradeDateOrContractMonth;
                    $continuation.L$5 = strike;
                    $continuation.L$6 = right;
                    $continuation.L$7 = multiplier;
                    $continuation.L$8 = exchange;
                    $continuation.L$9 = primaryExch;
                    $continuation.L$10 = currency;
                    $continuation.L$11 = localSymbol;
                    $continuation.L$12 = tradingClass;
                    $continuation.I$0 = tickerId;
                    $continuation.I$1 = conid;
                    $continuation.label = 14;
                    v14 = istream.readBooleanNotNull((Continuation<? super Boolean>)$continuation);
                    if (v14 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl383
                }
                case 14: {
                    conid = $continuation.I$1;
                    tickerId = $continuation.I$0;
                    tradingClass = (String)$continuation.L$12;
                    localSymbol = (String)$continuation.L$11;
                    currency = (String)$continuation.L$10;
                    primaryExch = (String)$continuation.L$9;
                    exchange = (String)$continuation.L$8;
                    multiplier = (String)$continuation.L$7;
                    right = (Right)$continuation.L$6;
                    strike = (XBigNum)$continuation.L$5;
                    lastTradeDateOrContractMonth = (String)$continuation.L$4;
                    secType = (String)$continuation.L$3;
                    symbol = (String)$continuation.L$2;
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v14 = $result;
lbl383:
                    // 2 sources

                    includeExpired = (Boolean)v14;
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.L$2 = symbol;
                    $continuation.L$3 = secType;
                    $continuation.L$4 = lastTradeDateOrContractMonth;
                    $continuation.L$5 = strike;
                    $continuation.L$6 = right;
                    $continuation.L$7 = multiplier;
                    $continuation.L$8 = exchange;
                    $continuation.L$9 = primaryExch;
                    $continuation.L$10 = currency;
                    $continuation.L$11 = localSymbol;
                    $continuation.L$12 = tradingClass;
                    $continuation.I$0 = tickerId;
                    $continuation.I$1 = conid;
                    $continuation.Z$0 = includeExpired;
                    $continuation.label = 15;
                    v15 = istream.readBooleanNotNull((Continuation<? super Boolean>)$continuation);
                    if (v15 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl424
                }
                case 15: {
                    includeExpired = $continuation.Z$0;
                    conid = $continuation.I$1;
                    tickerId = $continuation.I$0;
                    tradingClass = (String)$continuation.L$12;
                    localSymbol = (String)$continuation.L$11;
                    currency = (String)$continuation.L$10;
                    primaryExch = (String)$continuation.L$9;
                    exchange = (String)$continuation.L$8;
                    multiplier = (String)$continuation.L$7;
                    right = (Right)$continuation.L$6;
                    strike = (XBigNum)$continuation.L$5;
                    lastTradeDateOrContractMonth = (String)$continuation.L$4;
                    secType = (String)$continuation.L$3;
                    symbol = (String)$continuation.L$2;
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v15 = $result;
lbl424:
                    // 2 sources

                    useRTH = (Boolean)v15;
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.L$2 = symbol;
                    $continuation.L$3 = secType;
                    $continuation.L$4 = lastTradeDateOrContractMonth;
                    $continuation.L$5 = strike;
                    $continuation.L$6 = right;
                    $continuation.L$7 = multiplier;
                    $continuation.L$8 = exchange;
                    $continuation.L$9 = primaryExch;
                    $continuation.L$10 = currency;
                    $continuation.L$11 = localSymbol;
                    $continuation.L$12 = tradingClass;
                    $continuation.I$0 = tickerId;
                    $continuation.I$1 = conid;
                    $continuation.Z$0 = includeExpired;
                    $continuation.Z$1 = useRTH;
                    $continuation.label = 16;
                    v16 = TwsInputStream.readString$default(istream, null, (Continuation)$continuation, 1, null);
                    if (v16 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl467
                }
                case 16: {
                    useRTH = $continuation.Z$1;
                    includeExpired = $continuation.Z$0;
                    conid = $continuation.I$1;
                    tickerId = $continuation.I$0;
                    tradingClass = (String)$continuation.L$12;
                    localSymbol = (String)$continuation.L$11;
                    currency = (String)$continuation.L$10;
                    primaryExch = (String)$continuation.L$9;
                    exchange = (String)$continuation.L$8;
                    multiplier = (String)$continuation.L$7;
                    right = (Right)$continuation.L$6;
                    strike = (XBigNum)$continuation.L$5;
                    lastTradeDateOrContractMonth = (String)$continuation.L$4;
                    secType = (String)$continuation.L$3;
                    symbol = (String)$continuation.L$2;
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v16 = $result;
lbl467:
                    // 2 sources

                    whatToShow = (String)v16;
                    $continuation.L$0 = istream;
                    $continuation.L$1 = state;
                    $continuation.L$2 = symbol;
                    $continuation.L$3 = secType;
                    $continuation.L$4 = lastTradeDateOrContractMonth;
                    $continuation.L$5 = strike;
                    $continuation.L$6 = right;
                    $continuation.L$7 = multiplier;
                    $continuation.L$8 = exchange;
                    $continuation.L$9 = primaryExch;
                    $continuation.L$10 = currency;
                    $continuation.L$11 = localSymbol;
                    $continuation.L$12 = tradingClass;
                    $continuation.L$13 = whatToShow;
                    $continuation.I$0 = tickerId;
                    $continuation.I$1 = conid;
                    $continuation.Z$0 = includeExpired;
                    $continuation.Z$1 = useRTH;
                    $continuation.label = 17;
                    v17 = istream.readIntNotNull((Continuation<? super Integer>)$continuation);
                    if (v17 == var24_6) {
                        return var24_6;
                    }
                    ** GOTO lbl512
                }
                case 17: {
                    useRTH = $continuation.Z$1;
                    includeExpired = $continuation.Z$0;
                    conid = $continuation.I$1;
                    tickerId = $continuation.I$0;
                    whatToShow = (String)$continuation.L$13;
                    tradingClass = (String)$continuation.L$12;
                    localSymbol = (String)$continuation.L$11;
                    currency = (String)$continuation.L$10;
                    primaryExch = (String)$continuation.L$9;
                    exchange = (String)$continuation.L$8;
                    multiplier = (String)$continuation.L$7;
                    right = (Right)$continuation.L$6;
                    strike = (XBigNum)$continuation.L$5;
                    lastTradeDateOrContractMonth = (String)$continuation.L$4;
                    secType = (String)$continuation.L$3;
                    symbol = (String)$continuation.L$2;
                    state = (TwsCommunicationState)$continuation.L$1;
                    istream = (TwsInputStream)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v17 = $result;
lbl512:
                    // 2 sources

                    formatDate = ((Number)v17).intValue();
                    return new ReqHeadTimestampRequest(tickerId, new Contract(Boxing.boxInt((int)conid), symbol, secType, lastTradeDateOrContractMonth, strike, right, multiplier, exchange, primaryExch, currency, localSymbol, tradingClass, null, null, 12288, null), includeExpired != false, useRTH != false, whatToShow, formatDate);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }
}

