/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.reflection2;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.Column;
import org.sql2o.Settings;
import org.sql2o.reflection2.PojoProperty;
import org.sql2o.reflection2.PojoPropertyBuilder;

public class PojoMetadata<T> {
    private final Constructor<T> constructor;
    private final Map<String, PojoProperty> pojoProperties;
    private final Settings settings;
    private static Boolean javaxPersistenceColumnPresence = null;

    public PojoMetadata(Class<T> clazz, Settings settings) throws ReflectiveOperationException {
        this.constructor = clazz.getDeclaredConstructor(new Class[0]);
        this.constructor.setAccessible(true);
        this.settings = settings;
        List<PojoPropertyBuilder> pojoPropertyBuilders = this.getPojoPropertyBuilders(clazz);
        Stream<PojoProperty> pojoPropertiesStream = pojoPropertyBuilders.stream().map(PojoPropertyBuilder::build);
        this.pojoProperties = pojoPropertiesStream.collect(Collectors.toMap(PojoProperty::getName, p -> p));
        List<PojoProperty> pojoPropertiesWithAnnotatedName = this.pojoProperties.values().stream().filter(p -> p.getAnnotatedName() != null).toList();
        pojoPropertiesWithAnnotatedName.forEach(p -> this.pojoProperties.put(p.getAnnotatedName(), (PojoProperty)p));
    }

    public Constructor<T> getConstructor() {
        return this.constructor;
    }

    public PojoProperty getPojoProperty(String name, Map<String, String> columnMappings) {
        String columnName;
        if (columnMappings.containsKey(name) && this.pojoProperties.containsKey(columnName = columnMappings.get(name))) {
            return this.pojoProperties.get(columnName);
        }
        return this.pojoProperties.getOrDefault(name, null);
    }

    private List<PojoPropertyBuilder> getPojoPropertyBuilders(Class<?> clazz) {
        HashMap<String, PojoPropertyBuilder> pojoPropertyBuilders = new HashMap<String, PojoPropertyBuilder>();
        this.initializeForClassRecursive(clazz, pojoPropertyBuilders);
        return new ArrayList<PojoPropertyBuilder>(pojoPropertyBuilders.values());
    }

    private void initializeForClassRecursive(Class<?> clazz, HashMap<String, PojoPropertyBuilder> pojoPropertyBuilders) {
        for (Method method : clazz.getDeclaredMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            method.setAccessible(true);
            String methodName = method.getName();
            if (methodName.startsWith("get") && method.getParameterCount() == 0) {
                propertyName = this.settings.getNamingConvention().deriveName(methodName.substring(3));
                pojoPropertyBuilders.computeIfAbsent(propertyName, name -> new PojoPropertyBuilder((String)name, this.settings)).withGetter(method);
            } else if (methodName.startsWith("is") && method.getParameterCount() == 0) {
                propertyName = this.settings.getNamingConvention().deriveName(methodName.substring(2));
                pojoPropertyBuilders.computeIfAbsent(propertyName, name -> new PojoPropertyBuilder((String)name, this.settings)).withGetter(method);
            } else if (methodName.startsWith("set") && method.getParameterCount() == 1) {
                propertyName = this.settings.getNamingConvention().deriveName(methodName.substring(3));
                pojoPropertyBuilders.computeIfAbsent(propertyName, name -> new PojoPropertyBuilder((String)name, this.settings)).withSetter(method);
            }
            if (!pojoPropertyBuilders.containsKey(methodName)) continue;
            pojoPropertyBuilders.get(methodName).withAnnotatedName(PojoMetadata.deriveAnnotatedName(method));
        }
        for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(((Field)accessibleObject).getModifiers())) continue;
            String fieldName = this.settings.getNamingConvention().deriveName(((Field)accessibleObject).getName());
            pojoPropertyBuilders.computeIfAbsent(fieldName, name -> new PojoPropertyBuilder((String)name, this.settings)).withField((Field)accessibleObject);
            if (!pojoPropertyBuilders.containsKey(fieldName)) continue;
            pojoPropertyBuilders.get(fieldName).withAnnotatedName(PojoMetadata.deriveAnnotatedName((Field)accessibleObject));
        }
        Class<?> superClass = clazz.getSuperclass();
        if (!superClass.equals(Object.class)) {
            this.initializeForClassRecursive(superClass, pojoPropertyBuilders);
        }
    }

    private static String deriveAnnotatedName(Executable method) {
        if (!PojoMetadata.isJavaxPersistenceColumnPresent()) {
            return null;
        }
        Column columnAnnotation = method.getAnnotation(Column.class);
        if (columnAnnotation == null) {
            return null;
        }
        return columnAnnotation.name();
    }

    private static String deriveAnnotatedName(Field field) {
        if (!PojoMetadata.isJavaxPersistenceColumnPresent()) {
            return null;
        }
        Column columnAnnotation = field.getAnnotation(Column.class);
        if (columnAnnotation == null) {
            return null;
        }
        return columnAnnotation.name();
    }

    private static boolean isJavaxPersistenceColumnPresent() {
        if (javaxPersistenceColumnPresence != null) {
            return javaxPersistenceColumnPresence;
        }
        try {
            Class.forName("javax.persistence.Column");
            javaxPersistenceColumnPresence = true;
        }
        catch (ClassNotFoundException e) {
            javaxPersistenceColumnPresence = false;
        }
        return javaxPersistenceColumnPresence;
    }
}

