/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.reflection2;

import java.util.Map;
import org.sql2o.Settings;
import org.sql2o.Sql2oException;
import org.sql2o.reflection2.ObjectBuildable;
import org.sql2o.reflection2.PojoMetadata;
import org.sql2o.reflection2.PojoProperty;

public class PojoBuilder<T>
implements ObjectBuildable<T> {
    private final Settings settings;
    private final PojoMetadata<T> pojoMetadata;
    private final T pojo;
    private final Map<String, String> columnMappings;

    public PojoBuilder(Settings settings, PojoMetadata<T> pojoMetadata, Map<String, String> columnMappings) throws ReflectiveOperationException {
        this(settings, pojoMetadata, columnMappings, pojoMetadata.getConstructor().newInstance(new Object[0]));
    }

    public PojoBuilder(Settings settings, PojoMetadata<T> pojoMetadata, Map<String, String> columnMappings, T pojo) {
        this.settings = settings;
        this.pojoMetadata = pojoMetadata;
        this.columnMappings = columnMappings;
        this.pojo = pojo;
    }

    @Override
    public void withValue(String columnName, Object obj) throws ReflectiveOperationException {
        PojoProperty pojoProperty;
        int dotIdx = columnName.indexOf(46);
        String derivedName = null;
        if (dotIdx > 0) {
            String subName = columnName.substring(0, dotIdx);
            derivedName = this.settings.getNamingConvention().deriveName(subName);
            PojoProperty subProperty = this.pojoMetadata.getPojoProperty(derivedName, this.columnMappings);
            String newPath = columnName.substring(dotIdx + 1);
            Object subObj = subProperty.getValue(this.pojo);
            if (subObj == null) {
                subObj = subProperty.initializeWithNewInstance(this.pojo);
                subProperty.SetProperty(this.pojo, subObj);
            }
            PojoMetadata subPojoMetadata = new PojoMetadata(subObj.getClass(), this.settings);
            PojoBuilder<Object> subObjectBuilder = new PojoBuilder<Object>(this.settings, subPojoMetadata, this.columnMappings, subObj);
            subObjectBuilder.withValue(newPath, obj);
            obj = subObjectBuilder.build();
        }
        if (derivedName == null) {
            derivedName = this.settings.getNamingConvention().deriveName(columnName);
        }
        if ((pojoProperty = this.pojoMetadata.getPojoProperty(derivedName, this.columnMappings)) == null) {
            if (this.settings.isThrowOnMappingError()) {
                throw new Sql2oException("Could not map " + columnName + " to any property.");
            }
            return;
        }
        pojoProperty.SetProperty(this.pojo, obj);
    }

    @Override
    public T build() throws ReflectiveOperationException {
        return this.pojo;
    }
}

