/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters.joda;

import java.sql.Timestamp;
import java.time.OffsetTime;
import org.joda.time.LocalTime;
import org.sql2o.converters.Converter;
import org.sql2o.converters.ConverterException;

public class JodaLocalTimeConverter
implements Converter<LocalTime> {
    @Override
    public LocalTime convert(Object val) throws ConverterException {
        if (val == null) {
            return null;
        }
        if (val instanceof OffsetTime) {
            return LocalTime.fromMillisOfDay((long)(((OffsetTime)val).toLocalTime().toNanoOfDay() / 1000000L));
        }
        try {
            return new LocalTime(val);
        }
        catch (IllegalArgumentException ex) {
            throw new ConverterException("Don't know how to convert from type '" + val.getClass().getName() + "' to type '" + LocalTime.class.getName() + "'", ex);
        }
    }

    @Override
    public Object toDatabaseParam(LocalTime val) {
        return new Timestamp(val.toDateTimeToday().getMillis());
    }
}

