/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters;

import org.sql2o.converters.ConverterBase;

public abstract class NumberConverter<V extends Number>
extends ConverterBase<V> {
    private final boolean isPrimitive;

    public NumberConverter(boolean primitive) {
        this.isPrimitive = primitive;
    }

    @Override
    public V convert(Object val) {
        if (val == null) {
            return this.isPrimitive ? (V)this.convertNumberValue(0) : null;
        }
        if (val instanceof Number) {
            Number num = (Number)val;
            return this.convertNumberValue(num);
        }
        if (val instanceof String) {
            String strVal = (String)val;
            if ((strVal = strVal.trim()).isEmpty()) {
                return this.isPrimitive ? (V)this.convertNumberValue(0) : null;
            }
            return this.convertStringValue(strVal);
        }
        throw new IllegalArgumentException("Cannot convert type " + val.getClass().toString() + " to " + this.getTypeDescription());
    }

    protected abstract V convertNumberValue(Number var1);

    protected abstract V convertStringValue(String var1);

    protected abstract String getTypeDescription();
}

