/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalTime;
import org.sql2o.converters.ConverterBase;
import org.sql2o.converters.ConverterException;

public class LocalTimeConverter
extends ConverterBase<LocalTime> {
    @Override
    public LocalTime convert(Object val) throws ConverterException {
        if (val == null) {
            return null;
        }
        if (val instanceof Time) {
            return ((Time)val).toLocalTime();
        }
        if (val instanceof Timestamp) {
            return ((Timestamp)val).toLocalDateTime().toLocalTime();
        }
        if (val instanceof String) {
            try {
                return LocalTime.parse((String)val);
            }
            catch (Exception e) {
                throw new ConverterException("Can't convert String with value '" + String.valueOf(val) + "' to LocalTime", e);
            }
        }
        throw new ConverterException("Can't convert type " + val.getClass().getName() + " to LocalTime");
    }
}

