/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o.converters;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.sql2o.converters.ConverterBase;
import org.sql2o.converters.ConverterException;

public class LocalDateTimeConverter
extends ConverterBase<LocalDateTime> {
    @Override
    public LocalDateTime convert(Object val) throws ConverterException {
        if (val == null) {
            return null;
        }
        if (val instanceof Timestamp) {
            return ((Timestamp)val).toLocalDateTime();
        }
        if (val instanceof Long) {
            return Instant.ofEpochMilli((Long)val).atZone(ZoneOffset.UTC).toLocalDateTime();
        }
        if (val instanceof String) {
            try {
                return LocalDateTime.parse((String)val);
            }
            catch (Exception e) {
                throw new ConverterException("Can't convert String with value '" + String.valueOf(val) + "' to LocalDateTime", e);
            }
        }
        throw new ConverterException("Can't convert type " + val.getClass().getName() + " to LocalDateTime");
    }
}

