/*
 * Decompiled with CFR 0.152.
 */
package org.sql2o;

import java.sql.ResultSetMetaData;
import org.sql2o.ResultSetHandler;
import org.sql2o.ResultSetHandlerFactory;
import org.sql2o.Sql2oException;
import org.sql2o.quirks.Quirks;
import org.sql2o.reflection2.ObjectBuildable;
import org.sql2o.reflection2.ObjectBuildableFactoryDelegate;

public class DefaultResultSetHandlerFactory<T>
implements ResultSetHandlerFactory<T> {
    private final Quirks quirks;
    private final ObjectBuildableFactoryDelegate<T> objectBuilderDelegate;

    public DefaultResultSetHandlerFactory(ObjectBuildableFactoryDelegate<T> objectBuilderDelegate, Quirks quirks) {
        this.objectBuilderDelegate = objectBuilderDelegate;
        this.quirks = quirks;
    }

    @Override
    public ResultSetHandler<T> newResultSetHandler(ResultSetMetaData meta) {
        return resultSet -> {
            ObjectBuildable<T> objectBuilder = this.objectBuilderDelegate.newObjectBuilder();
            for (int i = 1; i <= meta.getColumnCount(); ++i) {
                String colName = this.quirks.getColumnName(meta, i);
                try {
                    objectBuilder.withValue(colName, resultSet.getObject(i));
                    continue;
                }
                catch (ReflectiveOperationException e) {
                    throw new Sql2oException("Error when trying to set value for column [" + colName + "]", e);
                }
            }
            try {
                return objectBuilder.build();
            }
            catch (ReflectiveOperationException e) {
                throw new Sql2oException("Error occurred while creating object from ResultSet", e);
            }
        };
    }
}

