/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.redrawer;

import java.util.concurrent.CancellationException;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skiko.AWTKt;
import org.jetbrains.skiko.AngleApi;
import org.jetbrains.skiko.AngleSupport_jvmKt;
import org.jetbrains.skiko.FPSCounter;
import org.jetbrains.skiko.FrameDispatcher;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.GraphicsApi_jvmKt;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.MainUIDispatcher_awtKt;
import org.jetbrains.skiko.OsArch_jvmKt;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkiaLayerProperties;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.SkikoProperties;
import org.jetbrains.skiko.context.AngleContextHandler;
import org.jetbrains.skiko.redrawer.AWTRedrawer;
import org.jetbrains.skiko.redrawer.AngleRedrawerKt;
import org.jetbrains.skiko.redrawer.Redrawer;
import org.jetbrains.skiko.redrawer.RedrawerManager;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u001bH\u0016J\b\u0010 \u001a\u00020\u001bH\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001eH\u0002J\u0006\u0010#\u001a\u00020$J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\u00020\u00138BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000f\u00a8\u0006*"}, d2={"Lorg/jetbrains/skiko/redrawer/AngleRedrawer;", "Lorg/jetbrains/skiko/redrawer/AWTRedrawer;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "properties", "Lorg/jetbrains/skiko/SkiaLayerProperties;", "<init>", "(Lorg/jetbrains/skiko/SkiaLayer;Lorg/jetbrains/skiko/SkiaLayerAnalytics;Lorg/jetbrains/skiko/SkiaLayerProperties;)V", "contextHandler", "Lorg/jetbrains/skiko/context/AngleContextHandler;", "renderInfo", "", "getRenderInfo", "()Ljava/lang/String;", "drawLock", "", "device", "", "getDevice", "()J", "frameDispatcher", "Lorg/jetbrains/skiko/FrameDispatcher;", "adapterName", "getAdapterName", "dispose", "", "needRender", "throttledToVsync", "", "renderImmediately", "draw", "drawAndSwap", "withVsync", "makeContext", "Lorg/jetbrains/skia/DirectContext;", "makeRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "width", "", "height", "skiko"})
@SourceDebugExtension(value={"SMAP\nAngleRedrawer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AngleRedrawer.kt\norg/jetbrains/skiko/redrawer/AngleRedrawer\n+ 2 AWTRedrawer.kt\norg/jetbrains/skiko/redrawer/AWTRedrawer\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SkiaLayer.awt.kt\norg/jetbrains/skiko/SkiaLayer\n+ 5 Logging.kt\norg/jetbrains/skiko/Logger\n*L\n1#1,113:1\n58#2:114\n59#2,8:116\n67#2,6:143\n58#2:149\n59#2,8:151\n67#2,6:178\n1#3:115\n1#3:150\n1#3:184\n611#4,10:124\n621#4,5:138\n611#4,10:159\n621#4,5:173\n168#5,4:134\n168#5,4:169\n*S KotlinDebug\n*F\n+ 1 AngleRedrawer.kt\norg/jetbrains/skiko/redrawer/AngleRedrawer\n*L\n74#1:114\n74#1:116,8\n74#1:143,6\n82#1:149\n82#1:151,8\n82#1:178,6\n74#1:115\n82#1:150\n74#1:124,10\n74#1:138,5\n82#1:159,10\n82#1:173,5\n74#1:134,4\n82#1:169,4\n*E\n"})
public final class AngleRedrawer
extends AWTRedrawer {
    @NotNull
    private final SkiaLayer layer;
    @NotNull
    private final SkiaLayerProperties properties;
    @NotNull
    private final AngleContextHandler contextHandler;
    @NotNull
    private Object drawLock;
    private long device;
    @NotNull
    private final FrameDispatcher frameDispatcher;

    public AngleRedrawer(@NotNull SkiaLayer layer, @NotNull SkiaLayerAnalytics analytics, @NotNull SkiaLayerProperties properties) {
        Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(layer, analytics, GraphicsApi.ANGLE);
        this.layer = layer;
        this.properties = properties;
        try {
            AngleSupport_jvmKt.loadAngleLibrary();
        }
        catch (Exception e) {
            throw new RenderException("Failed to load ANGLE library", e);
        }
        this.contextHandler = new AngleContextHandler(this.layer);
        this.drawLock = new Object();
        this.frameDispatcher = new FrameDispatcher((CoroutineContext)MainUIDispatcher_awtKt.getMainUIDispatcher(), (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AngleRedrawer this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        if (AngleRedrawer.access$getLayer$p(this.this$0).isShowing()) {
                            this.this$0.update(System.nanoTime());
                            AngleRedrawer.access$draw(this.this$0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        this.device = ((Number)AWTKt.useDrawingSurfacePlatformInfo(this.layer.getBackedLayer$skiko(), arg_0 -> AngleRedrawer._init_$lambda$1(this, arg_0))).longValue();
        String adapterName = this.getAdapterName();
        boolean bl = false;
        if (adapterName != null && !GraphicsApi_jvmKt.isVideoCardSupported(GraphicsApi.ANGLE, OsArch_jvmKt.getHostOs(), adapterName)) {
            throw new RenderException("Cannot create ANGLE redrawer.", null, 2, null);
        }
        this.onDeviceChosen(adapterName);
        this.onContextInit();
    }

    @Override
    @NotNull
    public String getRenderInfo() {
        return this.contextHandler.rendererInfo();
    }

    private final long getDevice() {
        if (this.device == 0L) {
            throw new RenderException("ANGLE device is not initialized or already disposed", null, 2, null);
        }
        return this.device;
    }

    private final String getAdapterName() {
        return AngleApi.INSTANCE.glGetString(AngleApi.INSTANCE.getGL_RENDERER());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Object object = this.drawLock;
        synchronized (object) {
            boolean bl = false;
            this.frameDispatcher.cancel();
            AngleRedrawerKt.access$makeCurrent(this.getDevice());
            this.contextHandler.dispose();
            AngleRedrawerKt.access$disposeDevice(this.getDevice());
            this.device = 0L;
            super.dispose();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public void needRender(boolean throttledToVsync) {
        this.checkDisposed();
        this.frameDispatcher.scheduleFrame();
    }

    @Override
    public void renderImmediately() {
        block16: {
            boolean isFirstFrame$iv;
            AWTRedrawer this_$iv;
            block15: {
                this.checkDisposed();
                Redrawer.DefaultImpls.update$default(this, 0L, 1, null);
                this_$iv = this;
                boolean $i$f$inDrawScope = false;
                if (AWTRedrawer.access$getDeviceAnalytics$p(this_$iv) == null) {
                    boolean $i$a$-requireNotNull-AWTRedrawer$inDrawScope$1$iv22 = false;
                    String $i$a$-requireNotNull-AWTRedrawer$inDrawScope$1$iv22 = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                    throw new IllegalArgumentException($i$a$-requireNotNull-AWTRedrawer$inDrawScope$1$iv22.toString());
                }
                if (AWTRedrawer.access$isDisposed(this_$iv)) break block16;
                isFirstFrame$iv = !AWTRedrawer.access$isFirstFrameRendered$p(this_$iv);
                AWTRedrawer.access$setFirstFrameRendered$p(this_$iv, true);
                if (isFirstFrame$iv) {
                    SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p(this_$iv);
                    if (deviceAnalytics != null) {
                        deviceAnalytics.beforeFirstFrameRender();
                    }
                }
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p(this_$iv);
                if (deviceAnalytics != null) {
                    deviceAnalytics.beforeFrameRender();
                }
                SkiaLayer this_$iv$iv = AWTRedrawer.access$getLayer$p(this_$iv);
                boolean $i$f$inDrawScope$skiko = false;
                if (!SwingUtilities.isEventDispatchThread()) {
                    boolean $i$a$-check-SkiaLayer$inDrawScope$1$iv$iv22 = false;
                    String $i$a$-check-SkiaLayer$inDrawScope$1$iv$iv22 = "Method should be called from AWT event dispatch thread";
                    throw new IllegalStateException($i$a$-check-SkiaLayer$inDrawScope$1$iv$iv22.toString());
                }
                if (!(!SkiaLayer.access$isDisposed$p(this_$iv$iv))) {
                    boolean $i$a$-check-SkiaLayer$inDrawScope$2$iv$iv22 = false;
                    String $i$a$-check-SkiaLayer$inDrawScope$2$iv$iv22 = "SkiaLayer is disposed";
                    throw new IllegalStateException($i$a$-check-SkiaLayer$inDrawScope$2$iv$iv22.toString());
                }
                try {
                    FPSCounter fPSCounter = SkiaLayer.access$getFpsCounter$p(this_$iv$iv);
                    if (fPSCounter != null) {
                        fPSCounter.tick();
                    }
                    boolean bl = false;
                    if (this.isDisposed()) break block15;
                    this.drawAndSwap(SkikoProperties.INSTANCE.getWindowsWaitForVsyncOnRedrawImmediately());
                }
                catch (CancellationException cancellationException) {
                }
                catch (RenderException e$iv$iv) {
                    if (SkiaLayer.access$isDisposed$p(this_$iv$iv)) break block15;
                    Logger this_$iv$iv$iv = Logger.INSTANCE;
                    boolean $i$f$warn = false;
                    if (this_$iv$iv$iv.getLoggerImpl().isWarnEnabled()) {
                        Throwable throwable = e$iv$iv;
                        SkikoLoggerInterface skikoLoggerInterface = this_$iv$iv$iv.getLoggerImpl();
                        boolean bl = false;
                        String string = "Exception in draw scope";
                        skikoLoggerInterface.warn(throwable, string);
                    }
                    RedrawerManager.findNextWorkingRenderApi$default(SkiaLayer.access$getRedrawerManager$p(this_$iv$iv), false, 1, null);
                    Redrawer redrawer = this_$iv$iv.getRedrawer$skiko();
                    if (redrawer != null) {
                        redrawer.renderImmediately();
                    }
                }
            }
            if (isFirstFrame$iv && !AWTRedrawer.access$isDisposed(this_$iv)) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p(this_$iv);
                if (deviceAnalytics != null) {
                    deviceAnalytics.afterFirstFrameRender();
                }
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p(this_$iv);
            if (deviceAnalytics != null) {
                deviceAnalytics.afterFrameRender();
            }
        }
    }

    private final void draw() {
        block16: {
            boolean isFirstFrame$iv;
            AWTRedrawer this_$iv;
            block15: {
                this_$iv = this;
                boolean $i$f$inDrawScope = false;
                if (AWTRedrawer.access$getDeviceAnalytics$p(this_$iv) == null) {
                    boolean $i$a$-requireNotNull-AWTRedrawer$inDrawScope$1$iv22 = false;
                    String $i$a$-requireNotNull-AWTRedrawer$inDrawScope$1$iv22 = "deviceAnalytics is not null. Call onDeviceChosen after choosing the drawing device";
                    throw new IllegalArgumentException($i$a$-requireNotNull-AWTRedrawer$inDrawScope$1$iv22.toString());
                }
                if (AWTRedrawer.access$isDisposed(this_$iv)) break block16;
                isFirstFrame$iv = !AWTRedrawer.access$isFirstFrameRendered$p(this_$iv);
                AWTRedrawer.access$setFirstFrameRendered$p(this_$iv, true);
                if (isFirstFrame$iv) {
                    SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p(this_$iv);
                    if (deviceAnalytics != null) {
                        deviceAnalytics.beforeFirstFrameRender();
                    }
                }
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p(this_$iv);
                if (deviceAnalytics != null) {
                    deviceAnalytics.beforeFrameRender();
                }
                SkiaLayer this_$iv$iv = AWTRedrawer.access$getLayer$p(this_$iv);
                boolean $i$f$inDrawScope$skiko = false;
                if (!SwingUtilities.isEventDispatchThread()) {
                    boolean $i$a$-check-SkiaLayer$inDrawScope$1$iv$iv22 = false;
                    String $i$a$-check-SkiaLayer$inDrawScope$1$iv$iv22 = "Method should be called from AWT event dispatch thread";
                    throw new IllegalStateException($i$a$-check-SkiaLayer$inDrawScope$1$iv$iv22.toString());
                }
                if (!(!SkiaLayer.access$isDisposed$p(this_$iv$iv))) {
                    boolean $i$a$-check-SkiaLayer$inDrawScope$2$iv$iv22 = false;
                    String $i$a$-check-SkiaLayer$inDrawScope$2$iv$iv22 = "SkiaLayer is disposed";
                    throw new IllegalStateException($i$a$-check-SkiaLayer$inDrawScope$2$iv$iv22.toString());
                }
                try {
                    FPSCounter fPSCounter = SkiaLayer.access$getFpsCounter$p(this_$iv$iv);
                    if (fPSCounter != null) {
                        fPSCounter.tick();
                    }
                    boolean bl = false;
                    this.drawAndSwap(this.properties.isVsyncEnabled());
                }
                catch (CancellationException cancellationException) {
                }
                catch (RenderException e$iv$iv) {
                    if (SkiaLayer.access$isDisposed$p(this_$iv$iv)) break block15;
                    Logger this_$iv$iv$iv = Logger.INSTANCE;
                    boolean $i$f$warn = false;
                    if (this_$iv$iv$iv.getLoggerImpl().isWarnEnabled()) {
                        Throwable throwable = e$iv$iv;
                        SkikoLoggerInterface skikoLoggerInterface = this_$iv$iv$iv.getLoggerImpl();
                        boolean bl = false;
                        String string = "Exception in draw scope";
                        skikoLoggerInterface.warn(throwable, string);
                    }
                    RedrawerManager.findNextWorkingRenderApi$default(SkiaLayer.access$getRedrawerManager$p(this_$iv$iv), false, 1, null);
                    Redrawer redrawer = this_$iv$iv.getRedrawer$skiko();
                    if (redrawer != null) {
                        redrawer.renderImmediately();
                    }
                }
            }
            if (isFirstFrame$iv && !AWTRedrawer.access$isDisposed(this_$iv)) {
                SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p(this_$iv);
                if (deviceAnalytics != null) {
                    deviceAnalytics.afterFirstFrameRender();
                }
            }
            SkiaLayerAnalytics.DeviceAnalytics deviceAnalytics = AWTRedrawer.access$getDeviceAnalytics$p(this_$iv);
            if (deviceAnalytics != null) {
                deviceAnalytics.afterFrameRender();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void drawAndSwap(boolean withVsync) {
        Object object = this.drawLock;
        synchronized (object) {
            boolean bl = false;
            if (this.isDisposed()) {
                return;
            }
            AngleRedrawerKt.access$makeCurrent(this.getDevice());
            this.contextHandler.draw();
            AngleRedrawerKt.access$swapBuffers(this.getDevice(), withVsync);
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final DirectContext makeContext() {
        Long l = AngleRedrawerKt.access$makeAngleContext(this.getDevice());
        long it = ((Number)l).longValue();
        boolean bl = false;
        Long l2 = it != 0L ? l : null;
        if (l2 == null) {
            throw new RenderException("Failed to make GL context.", null, 2, null);
        }
        long l3 = l2;
        return new DirectContext(l3);
    }

    @NotNull
    public final BackendRenderTarget makeRenderTarget(int width, int height) {
        Long l = AngleRedrawerKt.access$makeAngleRenderTarget(this.getDevice(), width, height);
        long it = ((Number)l).longValue();
        boolean bl = false;
        Long l2 = it != 0L ? l : null;
        if (l2 == null) {
            throw new RenderException("Failed to make ANGLE render target.", null, 2, null);
        }
        long l3 = l2;
        return new BackendRenderTarget(l3);
    }

    private static final long _init_$lambda$1(AngleRedrawer this$0, long platformInfo) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Long l = AngleRedrawerKt.access$createAngleDevice(platformInfo, this$0.layer.getTransparency());
        long it = ((Number)l).longValue();
        boolean bl = false;
        Long l2 = it != 0L ? l : null;
        if (l2 == null) {
            throw new RenderException("Failed to create ANGLE device.", null, 2, null);
        }
        return l2;
    }

    public static final /* synthetic */ SkiaLayer access$getLayer$p(AngleRedrawer $this) {
        return $this.layer;
    }

    public static final /* synthetic */ void access$draw(AngleRedrawer $this) {
        $this.draw();
    }
}

