/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.util.network;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public interface NetworkBody {
    @NotNull
    public static NetworkBody fromJsonObject(@NotNull Map<String, Object> value) {
        return new JsonObjectImpl(value);
    }

    @NotNull
    public static NetworkBody fromJsonArray(@NotNull List<Object> value) {
        return new JsonArrayImpl(value);
    }

    @NotNull
    public static NetworkBody fromString(@NotNull String value) {
        return new StringBodyImpl(value);
    }

    @NotNull
    public Object getValue();

    public static final class JsonObjectImpl
    implements NetworkBody {
        @NotNull
        private final Map<String, Object> value;

        JsonObjectImpl(@NotNull Map<String, Object> value) {
            this.value = value;
        }

        @Override
        @NotNull
        public Map<String, Object> getValue() {
            return this.value;
        }

        public String toString() {
            return "NetworkBody.JsonObject{" + this.value + '}';
        }
    }

    public static final class JsonArrayImpl
    implements NetworkBody {
        @NotNull
        private final List<Object> value;

        JsonArrayImpl(@NotNull List<Object> value) {
            this.value = value;
        }

        @Override
        @NotNull
        public List<Object> getValue() {
            return this.value;
        }

        public String toString() {
            return "NetworkBody.JsonArray{" + this.value + '}';
        }
    }

    public static final class StringBodyImpl
    implements NetworkBody {
        @NotNull
        private final String value;

        StringBodyImpl(@NotNull String value) {
            this.value = value;
        }

        @Override
        @NotNull
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "NetworkBody.StringBody{" + this.value + '}';
        }
    }
}

