/*
 * Decompiled with CFR 0.152.
 */
package org.tbee.javafx.scene.layout;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.NodeOrientation;
import javafx.geometry.Orientation;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.stage.Screen;
import javafx.stage.Window;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.Grid;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.LayoutCallback;
import net.miginfocom.layout.LayoutUtil;
import net.miginfocom.layout.PlatformDefaults;
import net.miginfocom.layout.UnitValue;
import org.tbee.javafx.scene.layout.LayoutAnimator;

public class MigPane
extends Pane {
    protected static final String FXML_CC_KEY = "MigPane.cc";
    private final ChangeListener<Boolean> gridInvalidator = (observable, oldValue, newValue) -> {
        this.invalidateGrid();
        this.requestLayout();
    };
    private Orientation bias = null;
    private boolean biasDirty = true;
    private boolean debug = false;
    private LC layoutConstraints = null;
    public static final String LAYOUTCONSTRAINTS_PROPERTY_ID = "layoutConstraints";
    private AC columnConstraints = null;
    public static final String COLUMNCONSTRAINTS_PROPERTY_ID = "columnConstraints";
    private AC rowConstraints = null;
    public static final String ROWCONSTRAINTS_PROPERTY_ID = "rowConstraints";
    private LayoutAnimator anim = null;
    private int animPrio = 0;
    private ArrayList<LayoutCallback> callbackList = null;
    private final LinkedHashMap<FXComponentWrapper, CC> wrapperToCCMap = new LinkedHashMap();
    private long lastSize = 0L;
    private Grid _grid;
    private int layoutInhibits = 0;
    private final List<Node> debugRectangles = new ArrayList<Node>();
    private Color debugCellColor = Color.RED;
    private Color debugExternalColor = Color.BLUE;
    private Color debugOutlineColor = Color.GREEN;
    private Color debugContainerOutlineColor = Color.PURPLE;

    public MigPane() {
        this.construct();
    }

    public MigPane(LC layoutConstraints) {
        this.setLayoutConstraints(layoutConstraints);
        this.construct();
    }

    public MigPane(LC layoutConstraints, AC colConstraints) {
        this.setLayoutConstraints(layoutConstraints);
        this.setColumnConstraints(colConstraints);
        this.construct();
    }

    public MigPane(LC layoutConstraints, AC colConstraints, AC rowConstraints) {
        this.setLayoutConstraints(layoutConstraints);
        this.setColumnConstraints(colConstraints);
        this.setRowConstraints(rowConstraints);
        this.construct();
    }

    public MigPane(String layoutConstraints) {
        this.setLayoutConstraints(ConstraintParser.parseLayoutConstraint((String)ConstraintParser.prepare((String)layoutConstraints)));
        this.construct();
    }

    public MigPane(String layoutConstraints, String colConstraints) {
        this.setLayoutConstraints(ConstraintParser.parseLayoutConstraint((String)ConstraintParser.prepare((String)layoutConstraints)));
        this.setColumnConstraints(ConstraintParser.parseColumnConstraints((String)ConstraintParser.prepare((String)colConstraints)));
        this.construct();
    }

    public MigPane(String layoutConstraints, String colConstraints, String rowConstraints) {
        this.setLayoutConstraints(ConstraintParser.parseLayoutConstraint((String)ConstraintParser.prepare((String)layoutConstraints)));
        this.setColumnConstraints(ConstraintParser.parseColumnConstraints((String)ConstraintParser.prepare((String)colConstraints)));
        this.setRowConstraints(ConstraintParser.parseRowConstraints((String)ConstraintParser.prepare((String)rowConstraints)));
        this.construct();
    }

    private void construct() {
        this.sceneProperty().addListener(e -> this.invalidateGrid());
        this.nodeOrientationProperty().addListener(observable -> {
            this.invalidateGrid();
            this.requestLayout();
        });
        if (this.layoutConstraints == null) {
            this.setLayoutConstraints(new LC());
        }
        if (this.rowConstraints == null) {
            this.setRowConstraints(new AC());
        }
        if (this.columnConstraints == null) {
            this.setColumnConstraints(new AC());
        }
        this.getChildren().addListener(c -> {
            while (c.next()) {
                for (Node node : c.getRemoved()) {
                    node.visibleProperty().removeListener(this.gridInvalidator);
                    this.animateRemoved(node);
                    int sizeBef = this.wrapperToCCMap.size();
                    this.wrapperToCCMap.remove(new FXComponentWrapper(node));
                    if (this.wrapperToCCMap.size() == sizeBef) continue;
                    this.invalidateGrid();
                }
                for (Node node : c.getAddedSubList()) {
                    if (!node.isManaged()) continue;
                    CC cc = (CC)node.getProperties().remove((Object)FXML_CC_KEY);
                    FXComponentWrapper wrapper = new FXComponentWrapper(node);
                    if (cc != null || !this.wrapperToCCMap.containsKey(wrapper)) {
                        this.wrapperToCCMap.put(wrapper, cc);
                    }
                    this.animateAdded(node);
                    node.visibleProperty().addListener(this.gridInvalidator);
                    this.invalidateGrid();
                }
            }
        });
    }

    protected double computeMinWidth(double height) {
        return this.computeWidth(height, 0);
    }

    protected double computeMinHeight(double width) {
        return this.computeHeight(width, 0);
    }

    protected double computePrefWidth(double height) {
        return this.computeWidth(height, 1);
    }

    protected double computePrefHeight(double width) {
        return this.computeHeight(width, 1);
    }

    protected double computeMaxWidth(double height) {
        return this.computeWidth(height, 2);
    }

    protected double computeMaxHeight(double width) {
        return this.computeHeight(width, 2);
    }

    protected double computeWidth(double refHeight, int type) {
        int ins = this.getHorIns();
        int refSize = (int)Math.ceil(refHeight != -1.0 ? refHeight : this.getHeight()) - ins;
        return ins + LayoutUtil.getSizeSafe((int[])this.getGrid().getWidth(refSize), (int)type);
    }

    protected double computeHeight(double refWidth, int type) {
        int ins = this.getVerIns();
        int refSize = (int)Math.ceil(refWidth != -1.0 ? refWidth : this.getWidth()) - ins;
        return ins + LayoutUtil.getSizeSafe((int[])this.getGrid().getHeight(refSize), (int)type);
    }

    private int getHorIns() {
        Insets insets = this.getInsets();
        return (int)Math.ceil(this.snapSpaceX(insets.getLeft()) + this.snapSpaceX(insets.getRight()));
    }

    private int getVerIns() {
        Insets insets = this.getInsets();
        return (int)Math.ceil(this.snapSpaceY(insets.getTop()) + this.snapSpaceY(insets.getBottom()));
    }

    public Orientation getContentBias() {
        if (this.biasDirty) {
            this.bias = null;
            for (Node child : this.getManagedChildren()) {
                Orientation ori = child.getContentBias();
                if (ori == Orientation.HORIZONTAL) {
                    this.bias = Orientation.HORIZONTAL;
                    break;
                }
                if (ori == null) continue;
                this.bias = ori;
            }
            this.biasDirty = false;
        }
        return this.bias;
    }

    public LC getLayoutConstraints() {
        return this.layoutConstraints;
    }

    public void setLayoutConstraints(LC lc) {
        this.layoutConstraints = lc;
        this.debug = lc != null && lc.getDebugMillis() > 0;
        this.invalidateGrid();
        this.requestLayout();
    }

    public MigPane withLayoutConstraints(LC value) {
        this.setLayoutConstraints(value);
        return this;
    }

    public AC getColumnConstraints() {
        return this.columnConstraints;
    }

    public void setColumnConstraints(AC value) {
        this.columnConstraints = value;
        this.invalidateGrid();
        this.requestLayout();
    }

    public MigPane withColumnConstraints(AC value) {
        this.setColumnConstraints(value);
        return this;
    }

    public AC getRowConstraints() {
        return this.rowConstraints;
    }

    public void setRowConstraints(AC value) {
        this.rowConstraints = value;
        this.invalidateGrid();
        this.requestLayout();
    }

    public MigPane withRowConstraints(AC value) {
        this.setRowConstraints(value);
        return this;
    }

    public CC getComponentConstraints(Node node) {
        return this.wrapperToCCMap.get(new FXComponentWrapper(node));
    }

    public void setComponentConstraints(Node node, String ccs) {
        CC cc = ConstraintParser.parseComponentConstraint((String)ConstraintParser.prepare((String)ccs));
        this.setComponentConstraints(node, cc);
    }

    public void setComponentConstraints(Node node, CC cc) {
        FXComponentWrapper wrapper = new FXComponentWrapper(node);
        if (!this.wrapperToCCMap.containsKey(wrapper)) {
            throw new IllegalArgumentException("Node not in pane: " + node);
        }
        this.wrapperToCCMap.put(wrapper, cc);
        this.invalidateGrid();
        this.requestLayout();
    }

    private LayoutAnimator getAnimator() {
        if (this.anim == null) {
            this.anim = new LayoutAnimator(this);
        }
        return this.anim;
    }

    private void startQueuedAnimations() {
        if (this.anim != null) {
            this.anim.start();
        }
    }

    public void animateAdded(Node node) {
        if (this.isNodeAnimated(node)) {
            this.getAnimator().nodeAdded(node);
        }
    }

    public void animateRemoved(Node node) {
        if (this.isNodeAnimated(node)) {
            this.getAnimator().nodeRemoved(node);
        }
    }

    public boolean animateBoundsChange(Node node, int x, int y, int width, int height) {
        if (!this.isNodeAnimated(node)) {
            return false;
        }
        this.getAnimator().animate(node, new Rectangle2D((double)x, (double)y, (double)width, (double)height));
        return true;
    }

    private boolean isNodeAnimated(Node node) {
        if (!this.isVisible()) {
            return false;
        }
        CC cc = this.wrapperToCCMap.get(new FXComponentWrapper(node));
        int compPrio = cc != null ? cc.getAnimSpec().getPriority() : 0;
        return (long)compPrio + (long)this.animPrio > 0L;
    }

    public void addLayoutCallback(LayoutCallback callback) {
        if (callback == null) {
            throw new NullPointerException();
        }
        if (this.callbackList == null) {
            this.callbackList = new ArrayList(1);
        }
        this.callbackList.add(callback);
        this.invalidateGrid();
    }

    public void removeLayoutCallback(LayoutCallback callback) {
        if (this.callbackList != null) {
            this.callbackList.remove(callback);
        }
    }

    public MigPane add(Node node, CC cc) {
        if (node.isManaged()) {
            this.wrapperToCCMap.put(new FXComponentWrapper(node), cc);
        }
        this.getChildren().add((Object)node);
        return this;
    }

    public MigPane add(Node node) {
        this.add(node, (CC)null);
        return this;
    }

    public MigPane add(Node node, String sCc) {
        CC cc = ConstraintParser.parseComponentConstraint((String)ConstraintParser.prepare((String)sCc));
        this.add(node, cc);
        return this;
    }

    public MigPane add(int index, Node node) {
        this.add(index, node, (CC)null);
        return this;
    }

    public MigPane add(int index, Node node, String sCc) {
        CC cc = ConstraintParser.parseComponentConstraint((String)ConstraintParser.prepare((String)sCc));
        this.add(index, node, cc);
        return this;
    }

    public MigPane add(int index, Node node, CC cc) {
        if (node.isManaged()) {
            this.wrapperToCCMap.put(new FXComponentWrapper(node), cc);
        }
        this.getChildren().add(index, (Object)node);
        return this;
    }

    public boolean remove(Node node) {
        return this.getChildren().remove((Object)node);
    }

    public Node remove(int ix) {
        return (Node)this.getChildren().remove(ix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void layoutChildren() {
        this.incLayoutInhibit();
        try {
            long newSize;
            if (this.layoutConstraints.isNoCache()) {
                this._grid = null;
            }
            Grid grid = this.getGrid();
            Insets ins = this.getInsets();
            int[] bounds = new int[]{(int)ins.getLeft(), (int)ins.getTop(), (int)Math.ceil(this.getWidth() - (double)this.getHorIns()), (int)Math.ceil(this.getHeight() - (double)this.getVerIns())};
            grid.layout(bounds, this.getLayoutConstraints().getAlignX(), this.getLayoutConstraints().getAlignY(), this.debug);
            if (this.debug) {
                this.clearDebug();
                grid.paintDebug();
            }
            if (this.lastSize != (newSize = (long)grid.getHeight()[1] + ((long)grid.getWidth()[1] << 32))) {
                this.lastSize = newSize;
                Platform.runLater(this::adjustWindowSize);
            }
            this.startQueuedAnimations();
        }
        finally {
            this.decLayoutInhibit();
        }
    }

    protected void setWidth(double newWidth) {
        if (newWidth != this.getWidth()) {
            super.setWidth(newWidth);
            if (this._grid != null) {
                this.invalidateGrid();
            }
        }
    }

    protected void setHeight(double newHeight) {
        if (newHeight != this.getHeight()) {
            super.setHeight(newHeight);
            if (this._grid != null) {
                this.invalidateGrid();
            }
        }
    }

    public void requestLayout() {
        if (this.layoutInhibits > 0) {
            return;
        }
        this.biasDirty = true;
        if (this._grid != null) {
            this.invalidateGrid();
        }
        super.requestLayout();
    }

    void incLayoutInhibit() {
        ++this.layoutInhibits;
    }

    void decLayoutInhibit() {
        --this.layoutInhibits;
    }

    private Grid getGrid() {
        if (this._grid == null) {
            this._grid = new Grid((ContainerWrapper)new FXContainerWrapper((Parent)this), this.getLayoutConstraints(), this.getRowConstraints(), this.getColumnConstraints(), this.wrapperToCCMap, this.callbackList);
        }
        return this._grid;
    }

    public void invalidateGrid() {
        this._grid = null;
        this.biasDirty = true;
    }

    private void adjustWindowSize() {
        Window window;
        BoundSize wBounds = this.layoutConstraints.getPackWidth();
        BoundSize hBounds = this.layoutConstraints.getPackHeight();
        Scene scene = this.getScene();
        Window window2 = window = scene != null ? scene.getWindow() : null;
        if (window == null || wBounds == BoundSize.NULL_SIZE && hBounds == BoundSize.NULL_SIZE) {
            return;
        }
        Parent root = scene.getRoot();
        double winWidth = window.getWidth();
        double winHeight = window.getHeight();
        double prefWidth = root.prefWidth(-1.0);
        double prefHeight = root.prefHeight(-1.0);
        FXContainerWrapper container = new FXContainerWrapper(root);
        double horIns = winWidth - scene.getWidth();
        double verIns = winHeight - scene.getHeight();
        double targetW = this.constrain(container, winWidth, prefWidth, wBounds) + horIns;
        double targetH = this.constrain(container, winHeight, prefHeight, hBounds) + verIns;
        double x = window.getX() - (targetW - winWidth) * (double)(1.0f - this.layoutConstraints.getPackWidthAlign());
        double y = window.getY() - (targetH - winHeight) * (double)(1.0f - this.layoutConstraints.getPackHeightAlign());
        window.setX(x);
        window.setY(y);
        window.setWidth(targetW);
        window.setHeight(targetH);
    }

    private double constrain(ContainerWrapper parent, double winSize, double prefSize, BoundSize constrain) {
        if (constrain == null) {
            return winSize;
        }
        double retSize = winSize;
        UnitValue wUV = constrain.getPreferred();
        if (wUV != null) {
            retSize = wUV.getPixels((float)prefSize, parent, (ComponentWrapper)parent);
        }
        retSize = constrain.constrain((int)Math.ceil(retSize), (float)prefSize, parent);
        return constrain.getGapPush() ? Math.max(winSize, retSize) : retSize;
    }

    public boolean usesMirroring() {
        return false;
    }

    public void clearDebug() {
        this.getChildren().removeAll(this.debugRectangles);
        this.debugRectangles.clear();
    }

    private void addDebugRectangle(double x, double y, double w, double h, DebugRectangleType type) {
        DebugRectangle debugRectangle = new DebugRectangle(this.snap(x), this.snap(y), this.snap(x + w - 1.0) - this.snap(x), this.snap(y + h - 1.0) - this.snap(y));
        if (type == DebugRectangleType.CELL) {
            debugRectangle.setStroke((Paint)this.getDebugCellColor());
            debugRectangle.getStrokeDashArray().addAll((Object[])new Double[]{3.0, 3.0});
        } else if (type == DebugRectangleType.EXTERNAL) {
            debugRectangle.setStroke((Paint)this.getDebugExternalColor());
            debugRectangle.getStrokeDashArray().addAll((Object[])new Double[]{5.0, 5.0});
        } else if (type == DebugRectangleType.OUTLINE) {
            debugRectangle.setStroke((Paint)this.getDebugOutlineColor());
            debugRectangle.getStrokeDashArray().addAll((Object[])new Double[]{4.0, 4.0});
        } else if (type == DebugRectangleType.CONTAINER_OUTLINE) {
            debugRectangle.setStroke((Paint)this.getDebugContainerOutlineColor());
            debugRectangle.getStrokeDashArray().addAll((Object[])new Double[]{7.0, 7.0});
        } else {
            throw new IllegalStateException("Unknown debug rectangle type");
        }
        debugRectangle.setFill(null);
        debugRectangle.mouseTransparentProperty().set(true);
        this.getChildren().add((Object)debugRectangle);
        this.debugRectangles.add((Node)debugRectangle);
    }

    private double snap(double v) {
        return (double)((int)v) + 0.5;
    }

    public Color getDebugCellColor() {
        return this.debugCellColor;
    }

    public void setDebugCellColor(Color value) {
        this.debugCellColor = value;
    }

    public Color getDebugExternalColor() {
        return this.debugExternalColor;
    }

    public void setDebugExternalColor(Color value) {
        this.debugExternalColor = value;
    }

    public Color getDebugOutlineColor() {
        return this.debugOutlineColor;
    }

    public void setDebugOutlineColor(Color value) {
        this.debugOutlineColor = value;
    }

    public Color getDebugContainerOutlineColor() {
        return this.debugContainerOutlineColor;
    }

    public void setDebugContainerOutlineColor(Color value) {
        this.debugContainerOutlineColor = value;
    }

    class FXComponentWrapper
    implements ComponentWrapper {
        protected final Node node;
        private int screenCacheKey = 0;
        private Screen screen = null;

        public FXComponentWrapper(Node node) {
            this.node = node;
        }

        public Object getComponent() {
            return this.node;
        }

        public ContainerWrapper getParent() {
            Parent parent = this.node.getParent();
            return parent != null ? new FXContainerWrapper(this.node.getParent()) : null;
        }

        public int getComponentType(boolean arg0) {
            if (this.node instanceof TextField || this.node instanceof TextArea) {
                return 3;
            }
            if (this.node instanceof Group) {
                return 1;
            }
            return 0;
        }

        public int getX() {
            int v = (int)this.node.getLayoutX();
            return v;
        }

        public int getY() {
            int v = (int)this.node.getLayoutY();
            return v;
        }

        public int getWidth() {
            int v = (int)Math.ceil(this.node.getLayoutBounds().getWidth());
            return v;
        }

        public int getMinimumWidth(int height) {
            int v = (int)Math.ceil(this.node.minWidth((double)height));
            return v;
        }

        public int getPreferredWidth(int height) {
            int v = (int)Math.ceil(this.node.prefWidth((double)height));
            return v;
        }

        public int getMaximumWidth(int height) {
            if (this.node instanceof Region || this.node instanceof Control) {
                double prefWidth;
                double d = prefWidth = this.node instanceof Region ? ((Region)this.node).getMaxWidth() : ((Control)this.node).getMaxWidth();
                if (prefWidth == -1.0 || prefWidth == Double.NEGATIVE_INFINITY) {
                    return 2097051;
                }
            }
            return (int)Math.ceil(this.node.maxWidth((double)height));
        }

        public int getHeight() {
            int v = (int)Math.ceil(this.node.getLayoutBounds().getHeight());
            return v;
        }

        public int getMinimumHeight(int width) {
            int v = (int)Math.ceil(this.node.minHeight((double)width));
            return v;
        }

        public int getPreferredHeight(int width) {
            int v = (int)Math.ceil(this.node.prefHeight((double)width));
            return v;
        }

        public int getMaximumHeight(int width) {
            if (this.node instanceof Region || this.node instanceof Control) {
                double prefWidth;
                double d = prefWidth = this.node instanceof Region ? ((Region)this.node).getMaxHeight() : ((Control)this.node).getMaxHeight();
                if (prefWidth == -1.0 || prefWidth == Double.NEGATIVE_INFINITY) {
                    return 2097051;
                }
            }
            return (int)Math.ceil(this.node.maxHeight((double)width));
        }

        public int getBaseline(int width, int height) {
            return (int)Math.round(this.node.getBaselineOffset());
        }

        public boolean hasBaseline() {
            return this.node.isResizable() && this.node.getBaselineOffset() != Double.NEGATIVE_INFINITY;
        }

        public int getScreenLocationX() {
            Bounds boundsInSceneNode = this.node.localToScene(this.node.getBoundsInLocal());
            int v = (int)(this.node.getScene().getX() + this.node.getScene().getX() + boundsInSceneNode.getMinX());
            return v;
        }

        public int getScreenLocationY() {
            Bounds boundsInSceneNode = this.node.localToScene(this.node.getBoundsInLocal());
            int v = (int)(this.node.getScene().getY() + this.node.getScene().getY() + boundsInSceneNode.getMinY());
            return v;
        }

        public int getScreenHeight() {
            int v = (int)Math.ceil(Screen.getPrimary().getBounds().getHeight());
            return v;
        }

        public int getScreenWidth() {
            int v = (int)Math.ceil(Screen.getPrimary().getBounds().getWidth());
            return v;
        }

        public int[] getVisualPadding() {
            return null;
        }

        public int getHorizontalScreenDPI() {
            double dpi = this.getScreen().getDpi();
            if (dpi < 1.0) {
                dpi = 96.0;
            }
            return (int)Math.ceil(dpi);
        }

        public int getVerticalScreenDPI() {
            return this.getHorizontalScreenDPI();
        }

        private Screen getScreen() {
            Window window = this.node.getScene().getWindow();
            int screenCacheKey = (window.getX() + "/" + window.getY()).hashCode();
            if (screenCacheKey != this.screenCacheKey) {
                ObservableList screens = Screen.getScreensForRectangle((double)window.getX(), (double)window.getY(), (double)1.0, (double)1.0);
                this.screen = screens.isEmpty() ? Screen.getPrimary() : (Screen)screens.get(0);
                this.screenCacheKey = screenCacheKey;
            }
            return this.screen;
        }

        public float getPixelUnitFactor(boolean isHor) {
            switch (PlatformDefaults.getLogicalPixelBase()) {
                case 100: {
                    return 1.0f;
                }
                case 101: {
                    Float s;
                    Float f = s = isHor ? PlatformDefaults.getHorizontalScaleFactor() : PlatformDefaults.getVerticalScaleFactor();
                    if (s == null) {
                        s = Float.valueOf(1.0f);
                    }
                    return s.floatValue() * (float)(isHor ? this.getHorizontalScreenDPI() : this.getVerticalScreenDPI()) / (float)PlatformDefaults.getDefaultDPI();
                }
            }
            return 1.0f;
        }

        public int getLayoutHashCode() {
            return 0;
        }

        public String getLinkId() {
            return this.node.getId();
        }

        public boolean isVisible() {
            return this.node.isVisible();
        }

        public int getContentBias() {
            Orientation bias = this.node.getContentBias();
            return bias == null ? -1 : bias.ordinal();
        }

        public void paintDebugOutline(boolean useVisualPadding) {
            CC cc = MigPane.this.wrapperToCCMap.get(this);
            DebugRectangleType type = cc != null && cc.isExternal() ? DebugRectangleType.EXTERNAL : DebugRectangleType.OUTLINE;
            MigPane.this.addDebugRectangle(this.node.getLayoutX() + this.node.getLayoutBounds().getMinX(), this.node.getLayoutY() + this.node.getLayoutBounds().getMinY(), this.getWidth(), this.getHeight(), type);
        }

        public int hashCode() {
            return this.node.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof FXComponentWrapper)) {
                return false;
            }
            return this.getComponent().equals(((FXComponentWrapper)o).getComponent());
        }

        public void setBounds(int x, int y, int width, int height) {
            if (!MigPane.this.animateBoundsChange(this.node, x, y, width, height)) {
                this.node.resizeRelocate((double)x, (double)y, (double)width, (double)height);
            }
        }
    }

    class FXContainerWrapper
    extends FXComponentWrapper
    implements ContainerWrapper {
        public FXContainerWrapper(Parent node) {
            super((Node)node);
        }

        public FXComponentWrapper[] getComponents() {
            ArrayList<FXComponentWrapper> fxComponentWrappers = new ArrayList<FXComponentWrapper>();
            for (Node node : MigPane.this.getManagedChildren()) {
                fxComponentWrappers.add(new FXComponentWrapper(node));
            }
            return fxComponentWrappers.toArray(new FXComponentWrapper[0]);
        }

        public int getComponentCount() {
            return MigPane.this.wrapperToCCMap.size();
        }

        public Object getLayout() {
            return MigPane.this;
        }

        public boolean isLeftToRight() {
            return MigPane.this.getEffectiveNodeOrientation() != NodeOrientation.RIGHT_TO_LEFT;
        }

        public void paintDebugCell(int x, int y, int w, int h) {
            MigPane.this.addDebugRectangle(x, y, w, h, DebugRectangleType.CELL);
        }

        @Override
        public void paintDebugOutline(boolean useVisualPadding) {
            MigPane.this.addDebugRectangle(0.0, 0.0, this.getWidth(), this.getHeight(), DebugRectangleType.CONTAINER_OUTLINE);
        }
    }

    class DebugRectangle
    extends Rectangle {
        public DebugRectangle(double x, double y, double w, double h) {
            super(x, y, w, h);
            this.setManaged(false);
        }
    }

    private static enum DebugRectangleType {
        CELL,
        OUTLINE,
        CONTAINER_OUTLINE,
        EXTERNAL;

    }
}

