/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.ib.symbol;

import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Contract;
import com.xorrus.trading.common.contract.Exchange;
import com.xorrus.trading.common.contract.Future;
import com.xorrus.trading.common.contract.FutureFamily;
import com.xorrus.trading.common.contract.Index;
import com.xorrus.trading.common.contract.Option;
import com.xorrus.trading.common.contract.Right;
import com.xorrus.trading.common.contract.Stock;
import com.xorrus.trading.common.contract.Underlying;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.Month;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u00db\u0001\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\u0010\u0005\u001a\u0004\u0018\u00010\u00032\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00032\b\u0010\n\u001a\u0004\u0018\u00010\u00032\b\u0010\u000b\u001a\u0004\u0018\u00010\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u00032\b\u0010\u000e\u001a\u0004\u0018\u00010\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\b\u0010\u0011\u001a\u0004\u0018\u00010\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\u0002\u0010\u001c\u001a2\u0010 \u001a\u001c\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\b\u0018\u00010\u001ej\u0004\u0018\u0001`!2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0019H\u0002\u001a \u0010$\u001a\u00020\b2\u0006\u0010#\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u001fH\u0002*0\b\u0002\u0010\u001d\"\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\b0\u001e2\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\b0\u001e\u00a8\u0006'"}, d2={"buildContractIdentForIBFlex", "Lcom/xorrus/trading/common/contract/Contract;", "assetCategory", "", "subCategory", "symbol", "description", "conid", "", "securityID", "securityIDType", "cusip", "isin", "figi", "listingExchange", "underlyingConid", "underlyingSymbol", "underlyingSecurityID", "underlyingListingExchange", "issuer", "issuerCountryCode", "multiplier", "Lcom/xorrus/trading/common/bignum/XBigNum;", "strike", "expiry", "Lkotlinx/datetime/LocalDate;", "putCall", "Lcom/xorrus/trading/common/contract/Right;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/xorrus/trading/common/bignum/XBigNum;Lcom/xorrus/trading/common/bignum/XBigNum;Lkotlinx/datetime/LocalDate;Lcom/xorrus/trading/common/contract/Right;)Lcom/xorrus/trading/common/contract/Contract;", "FutureInfo", "Lkotlin/Triple;", "Lkotlinx/datetime/Month;", "resolveFutureSymbol", "Lcom/xorrus/trading/lot/ib/symbol/FutureInfo;", "ibSymbol", "afterDate", "getFullYear", "yearDigits", "month", "laboftrades-ib"})
public final class BuildSymbolKt {
    @NotNull
    public static final Contract buildContractIdentForIBFlex(@NotNull String assetCategory, @Nullable String subCategory, @Nullable String symbol, @Nullable String description, @Nullable Integer conid, @Nullable String securityID, @Nullable String securityIDType, @Nullable String cusip, @Nullable String isin, @Nullable String figi, @Nullable String listingExchange, @Nullable Integer underlyingConid, @Nullable String underlyingSymbol, @Nullable String underlyingSecurityID, @Nullable String underlyingListingExchange, @Nullable String issuer, @Nullable String issuerCountryCode, @Nullable XBigNum multiplier, @Nullable XBigNum strike, @Nullable LocalDate expiry, @Nullable Right putCall) {
        Intrinsics.checkNotNullParameter((Object)assetCategory, (String)"assetCategory");
        return switch (assetCategory) {
            case "FUT" -> {
                String v0 = underlyingSymbol;
                Intrinsics.checkNotNull((Object)v0);
                String v1 = symbol;
                Intrinsics.checkNotNull((Object)v1);
                String v2 = underlyingListingExchange;
                Intrinsics.checkNotNull((Object)v2);
                FutureFamily v3 = new FutureFamily(v0, v1, new Exchange(v2), null, 8, null);
                LocalDate v4 = expiry;
                Intrinsics.checkNotNull((Object)v4);
                yield (Contract)new Future(v3, v4.getMonth(), expiry.getDay());
            }
            case "STK" -> {
                String v6 = symbol;
                Intrinsics.checkNotNull((Object)v6);
                String var22_22 = v6;
                Locale v7 = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"US");
                String v8 = var22_22.toUpperCase(v7);
                Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"toUpperCase(...)");
                yield (Contract)new Stock(v8, null, 2, null);
            }
            case "OPT" -> {
                String v9 = symbol;
                Intrinsics.checkNotNull((Object)v9);
                String v10 = v9.substring(0, 6);
                Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"substring(...)");
                String tradingClass = ((Object)StringsKt.trim((CharSequence)v10)).toString();
                String v11 = underlyingSymbol;
                Intrinsics.checkNotNull((Object)v11);
                Underlying v12 = (Underlying)new Index(v11, null, 2, null);
                LocalDate v13 = expiry;
                Intrinsics.checkNotNull((Object)v13);
                XBigNum v14 = strike;
                Intrinsics.checkNotNull((Object)v14);
                Right v15 = putCall;
                Intrinsics.checkNotNull((Object)v15);
                yield (Contract)new Option(v12, tradingClass, v13, v14, v15);
            }
            case "FOP" -> {
                String v16 = underlyingSymbol;
                Intrinsics.checkNotNull((Object)v16);
                LocalDate v17 = expiry;
                Intrinsics.checkNotNull((Object)v17);
                Triple<String, Month, Integer> v18 = BuildSymbolKt.resolveFutureSymbol(v16, v17);
                if (v18 == null) {
                    throw new IllegalStateException(("Could not resolve future symbol for '" + underlyingSymbol + "' and " + expiry).toString());
                }
                Triple<String, Month, Integer> info = v18;
                String baseSymbol = (String)info.getFirst();
                Month month = (Month)info.getSecond();
                int year = ((Number)info.getThird()).intValue();
                String tradingClass = "";
                String v19 = underlyingListingExchange;
                Intrinsics.checkNotNull((Object)v19);
                FutureFamily baseFuture = new FutureFamily(baseSymbol, tradingClass, new Exchange(v19), null, 8, null);
                Future future = new Future(baseFuture, month, year);
                Underlying v20 = (Underlying)future;
                XBigNum v21 = strike;
                Intrinsics.checkNotNull((Object)v21);
                Right v22 = putCall;
                Intrinsics.checkNotNull((Object)v22);
                yield (Contract)new Option(v20, expiry, v21, v22);
            }
            default -> throw new IllegalStateException(("Unsupported flex execution type: " + assetCategory).toString());
        };
    }

    private static final Triple<String, Month, Integer> resolveFutureSymbol(String ibSymbol, LocalDate afterDate) {
        Regex classicRegex = new Regex("([A-Z0-9]+)([FGHJKMNQUVXZ])(\\d)");
        Regex longFormRegex = new Regex("^([A-Z0-9]+)\\s+([A-Z]{3})\\s+(\\d{2})$");
        MatchResult matchResult = classicRegex.matchEntire((CharSequence)ibSymbol);
        if (matchResult != null) {
            MatchResult match = matchResult;
            boolean bl = false;
            String base = (String)match.getGroupValues().get(1);
            char monthCode = StringsKt.first((CharSequence)((CharSequence)match.getGroupValues().get(2)));
            int yearDigit = Integer.parseInt((String)match.getGroupValues().get(3));
            Month month = Future.Companion.getMonth(monthCode);
            int fullYear = BuildSymbolKt.getFullYear(afterDate, yearDigit, month);
            return new Triple((Object)base, (Object)month, (Object)fullYear);
        }
        MatchResult matchResult2 = longFormRegex.matchEntire((CharSequence)ibSymbol);
        if (matchResult2 != null) {
            MatchResult match = matchResult2;
            boolean bl = false;
            String base = ((Object)StringsKt.trim((CharSequence)((String)match.getGroupValues().get(1)))).toString();
            String monthAbbrev = (String)match.getGroupValues().get(2);
            int yearDigits = Integer.parseInt((String)match.getGroupValues().get(3));
            Month month = Future.Companion.getMonthFromThreeLetter(monthAbbrev);
            int fullYear = BuildSymbolKt.getFullYear(afterDate, yearDigits, month);
            return new Triple((Object)base, (Object)month, (Object)fullYear);
        }
        return null;
    }

    private static final int getFullYear(LocalDate afterDate, int yearDigits, Month month) {
        int currentYear = afterDate.getYear();
        int decadeStart = currentYear / 10 * 10;
        int fullYear = decadeStart + yearDigits;
        LocalDate expiryDate = LocalDateKt.plus((LocalDate)new LocalDate(fullYear, month, 1), (int)1, (DateTimeUnit.DateBased)((DateTimeUnit.DateBased)DateTimeUnit.Companion.getMONTH()));
        if (expiryDate.compareTo(afterDate) <= 0) {
            fullYear += 10;
        }
        return fullYear;
    }
}

