/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.business.strategy;

import com.xorrus.trading.common.DateKt;
import com.xorrus.trading.common.TimezoneKt;
import com.xorrus.trading.common.XbignumKt;
import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Contract;
import com.xorrus.trading.common.contract.ContractManager;
import com.xorrus.trading.common.contract.OHLCV;
import com.xorrus.trading.common.contract.Price;
import com.xorrus.trading.common.contract.Stock;
import com.xorrus.trading.common.contract.Underlying;
import com.xorrus.trading.ib.tws.api.TwsMissingLiveDataSubscriptionError;
import com.xorrus.trading.lot.business.strategy.ZeroDTEOpeningPut20Strategy;
import com.xorrus.trading.lot.business.strategy.state.ChecklistStrategyState;
import com.xorrus.trading.lot.business.strategy.state.StrategyStatus;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import kotlinx.datetime.DayOfWeek;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B_\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u000e\b\u0002\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u00109\u001a\u00020:J\u000e\u0010;\u001a\u00020:H\u0086@\u00a2\u0006\u0002\u0010<J(\u0010=\u001a\u00020:2\u0006\u0010>\u001a\u0002022\b\u0010?\u001a\u0004\u0018\u00010\u00052\u0006\u0010@\u001a\u00020AH\u0086@\u00a2\u0006\u0002\u0010BR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001f\"\u0004\b#\u0010!R\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010\u000f\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010%\"\u0004\b)\u0010'R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010-\u001a\b\u0012\u0004\u0012\u00020,0.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u000202X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0017\u00105\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u001fR\u0017\u00107\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u001f\u00a8\u0006C"}, d2={"Lcom/xorrus/trading/lot/business/strategy/ZeroDTEOpeningPut20Strategy;", "", "underlying", "Lcom/xorrus/trading/common/contract/Underlying;", "tradingClass", "", "validDays", "", "Lkotlinx/datetime/DayOfWeek;", "validTimeNY", "Lkotlin/ranges/ClosedRange;", "Lkotlinx/datetime/LocalTime;", "ibTimeNY", "maxGapDown", "", "maxGapUp", "<init>", "(Lcom/xorrus/trading/common/contract/Underlying;Ljava/lang/String;Ljava/util/List;Lkotlin/ranges/ClosedRange;Lkotlin/ranges/ClosedRange;DD)V", "getUnderlying", "()Lcom/xorrus/trading/common/contract/Underlying;", "setUnderlying", "(Lcom/xorrus/trading/common/contract/Underlying;)V", "getTradingClass", "()Ljava/lang/String;", "setTradingClass", "(Ljava/lang/String;)V", "getValidDays", "()Ljava/util/List;", "setValidDays", "(Ljava/util/List;)V", "getValidTimeNY", "()Lkotlin/ranges/ClosedRange;", "setValidTimeNY", "(Lkotlin/ranges/ClosedRange;)V", "getIbTimeNY", "setIbTimeNY", "getMaxGapDown", "()D", "setMaxGapDown", "(D)V", "getMaxGapUp", "setMaxGapUp", "_state", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/xorrus/trading/lot/business/strategy/state/ChecklistStrategyState;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "steps", "", "getSteps", "()I", "validTimeLocal", "getValidTimeLocal", "ibTimeLocal", "getIbTimeLocal", "skipPreConditions", "", "checkPreConditions", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "placeOrder", "size", "accountId", "transmit", "", "(ILjava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "laboftrades-business"})
@SourceDebugExtension(value={"SMAP\nZeroDTEOpeningPut20Strategy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZeroDTEOpeningPut20Strategy.kt\ncom/xorrus/trading/lot/business/strategy/ZeroDTEOpeningPut20Strategy\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,292:1\n230#2,5:293\n*S KotlinDebug\n*F\n+ 1 ZeroDTEOpeningPut20Strategy.kt\ncom/xorrus/trading/lot/business/strategy/ZeroDTEOpeningPut20Strategy\n*L\n64#1:293,5\n*E\n"})
public final class ZeroDTEOpeningPut20Strategy {
    @NotNull
    private Underlying underlying;
    @NotNull
    private String tradingClass;
    @NotNull
    private List<? extends DayOfWeek> validDays;
    @NotNull
    private ClosedRange<LocalTime> validTimeNY;
    @NotNull
    private ClosedRange<LocalTime> ibTimeNY;
    private double maxGapDown;
    private double maxGapUp;
    @NotNull
    private final MutableStateFlow<ChecklistStrategyState> _state;
    @NotNull
    private final StateFlow<ChecklistStrategyState> state;
    private final int steps;

    public ZeroDTEOpeningPut20Strategy(@NotNull Underlying underlying, @NotNull String tradingClass, @NotNull List<? extends DayOfWeek> validDays, @NotNull ClosedRange<LocalTime> validTimeNY, @NotNull ClosedRange<LocalTime> ibTimeNY, double maxGapDown, double maxGapUp) {
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"underlying");
        Intrinsics.checkNotNullParameter((Object)tradingClass, (String)"tradingClass");
        Intrinsics.checkNotNullParameter(validDays, (String)"validDays");
        Intrinsics.checkNotNullParameter(validTimeNY, (String)"validTimeNY");
        Intrinsics.checkNotNullParameter(ibTimeNY, (String)"ibTimeNY");
        this.underlying = underlying;
        this.tradingClass = tradingClass;
        this.validDays = validDays;
        this.validTimeNY = validTimeNY;
        this.ibTimeNY = ibTimeNY;
        this.maxGapDown = maxGapDown;
        this.maxGapUp = maxGapUp;
        this._state = StateFlowKt.MutableStateFlow((Object)new ChecklistStrategyState(null, null, 0, 7, null));
        this.state = FlowKt.asStateFlow(this._state);
        this.steps = 3;
    }

    public /* synthetic */ ZeroDTEOpeningPut20Strategy(Underlying underlying, String string, List list, ClosedRange closedRange, ClosedRange closedRange2, double d, double d2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            underlying = (Underlying)Stock.Companion.getSPY();
        }
        if ((n & 2) != 0) {
            string = "SPY";
        }
        if ((n & 4) != 0) {
            Object[] objectArray = new DayOfWeek[]{DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.FRIDAY};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        if ((n & 8) != 0) {
            closedRange = RangesKt.rangeTo((Comparable)((Comparable)new LocalTime(10, 0, 0, 0, 12, null)), (Comparable)((Comparable)new LocalTime(10, 15, 0, 0, 12, null)));
        }
        if ((n & 0x10) != 0) {
            closedRange2 = RangesKt.rangeTo((Comparable)((Comparable)new LocalTime(9, 30, 0, 0, 12, null)), (Comparable)((Comparable)new LocalTime(10, 0, 0, 0, 12, null)));
        }
        if ((n & 0x20) != 0) {
            d = 0.02;
        }
        if ((n & 0x40) != 0) {
            d2 = 0.015;
        }
        this(underlying, string, list, (ClosedRange<LocalTime>)closedRange, (ClosedRange<LocalTime>)closedRange2, d, d2);
    }

    @NotNull
    public final Underlying getUnderlying() {
        return this.underlying;
    }

    public final void setUnderlying(@NotNull Underlying underlying) {
        Intrinsics.checkNotNullParameter((Object)underlying, (String)"<set-?>");
        this.underlying = underlying;
    }

    @NotNull
    public final String getTradingClass() {
        return this.tradingClass;
    }

    public final void setTradingClass(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.tradingClass = string;
    }

    @NotNull
    public final List<DayOfWeek> getValidDays() {
        return this.validDays;
    }

    public final void setValidDays(@NotNull List<? extends DayOfWeek> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.validDays = list;
    }

    @NotNull
    public final ClosedRange<LocalTime> getValidTimeNY() {
        return this.validTimeNY;
    }

    public final void setValidTimeNY(@NotNull ClosedRange<LocalTime> closedRange) {
        Intrinsics.checkNotNullParameter(closedRange, (String)"<set-?>");
        this.validTimeNY = closedRange;
    }

    @NotNull
    public final ClosedRange<LocalTime> getIbTimeNY() {
        return this.ibTimeNY;
    }

    public final void setIbTimeNY(@NotNull ClosedRange<LocalTime> closedRange) {
        Intrinsics.checkNotNullParameter(closedRange, (String)"<set-?>");
        this.ibTimeNY = closedRange;
    }

    public final double getMaxGapDown() {
        return this.maxGapDown;
    }

    public final void setMaxGapDown(double d) {
        this.maxGapDown = d;
    }

    public final double getMaxGapUp() {
        return this.maxGapUp;
    }

    public final void setMaxGapUp(double d) {
        this.maxGapUp = d;
    }

    @NotNull
    public final StateFlow<ChecklistStrategyState> getState() {
        return this.state;
    }

    public final int getSteps() {
        return this.steps;
    }

    @NotNull
    public final ClosedRange<LocalTime> getValidTimeLocal() {
        return DateKt.switchTimeZone$default(this.validTimeNY, (TimeZone)TimezoneKt.getNewYorkTimezone(), null, (int)2, null);
    }

    @NotNull
    public final ClosedRange<LocalTime> getIbTimeLocal() {
        return DateKt.switchTimeZone$default(this.ibTimeNY, (TimeZone)TimezoneKt.getNewYorkTimezone(), null, (int)2, null);
    }

    public final void skipPreConditions() {
        ChecklistStrategyState nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<ChecklistStrategyState> $this$update$iv = this._state;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            ChecklistStrategyState it = (ChecklistStrategyState)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = new ChecklistStrategyState(StrategyStatus.Idle.INSTANCE, "", this.steps))));
    }

    @Nullable
    public final Object checkPreConditions(@NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ ZeroDTEOpeningPut20Strategy this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final Object invokeSuspend(Object $result) {
                var14_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $this$update$iv = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                        $i$f$update = false;
                        do {
                            prevValue$iv = $this$update$iv.getValue();
                            it = (ChecklistStrategyState)prevValue$iv;
                            $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$1 = false;
                        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv /* !! */  = new ChecklistStrategyState(StrategyStatus.Running.INSTANCE, null, 0, 6, null))));
                        this.label = 1;
                        v0 = Contract.getPrice$default((Contract)((Contract)this.this$0.getUnderlying()), null, (Continuation)((Continuation)this), (int)1, null);
                        ** if (v0 != var14_2) goto lbl22
lbl21:
                        // 1 sources

                        return var14_2;
lbl22:
                        // 1 sources

                        ** GOTO lbl29
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl29:
                        // 2 sources

                        $i$f$update = (Price)v0;
                        {
                            catch (TwsMissingLiveDataSubscriptionError <unused var>) {
                                nextValue$iv /* !! */  = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                                $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$1 = this.this$0;
                                $i$f$update = false;
                                do {
                                    prevValue$iv = $this$update$iv.getValue();
                                    it = (ChecklistStrategyState)prevValue$iv;
                                    $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$underlyingPrice$2 = false;
                                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ChecklistStrategyState.copy$default(it, new StrategyStatus.Error(0), "Keine Marktdaten f\u00fcr " + $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$1.getUnderlying().getSymbol(), 0, 4, null))));
                                $this$update$iv = Unit.INSTANCE;
                                currentState = (ChecklistStrategyState)ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0).getValue();
                                if (Intrinsics.areEqual((Object)currentState.getStatus(), (Object)StrategyStatus.Running.INSTANCE)) {
                                    $this$update$iv = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                                    $i$f$update = false;
                                    do {
                                        prevValue$iv = $this$update$iv.getValue();
                                        it = (ChecklistStrategyState)prevValue$iv;
                                        $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$13 = false;
                                    } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ChecklistStrategyState.copy$default(it, StrategyStatus.Idle.INSTANCE, null, 0, 6, null))));
                                }
                                return $this$update$iv;
                            }
                        }
                        v1 = underlyingPrice = $i$f$update;
                        if ((v1 != null ? v1.getPrice() : null) != null) ** GOTO lbl82
                        $i$f$update = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                        <unused var> = this.this$0;
                        $i$f$update = false;
                        do {
                            prevValue$iv = $this$update$iv.getValue();
                            it = (ChecklistStrategyState)prevValue$iv;
                            $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$2 = false;
                        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ChecklistStrategyState.copy$default(it, new StrategyStatus.Error(0), "Kein Spotpreis f\u00fcr " + <unused var>.getUnderlying().getSymbol() + " gefunden", 0, 4, null))));
                        $this$update$iv = Unit.INSTANCE;
                        currentState = (ChecklistStrategyState)ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0).getValue();
                        if (Intrinsics.areEqual((Object)currentState.getStatus(), (Object)StrategyStatus.Running.INSTANCE)) {
                            $this$update$iv = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                            $i$f$update = false;
                            do {
                                prevValue$iv = $this$update$iv.getValue();
                                it = (ChecklistStrategyState)prevValue$iv;
                                $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$13 = false;
                            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ChecklistStrategyState.copy$default(it, StrategyStatus.Idle.INSTANCE, null, 0, 6, null))));
                        }
                        return $this$update$iv;
lbl82:
                        // 2 sources

                        if (this.this$0.getValidDays().contains(DateKt.today((TimeZone)TimezoneKt.getNewYorkTimezone()).getDayOfWeek())) ** GOTO lbl106
                        $this$update$iv = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                        $i$f$update = false;
                        do {
                            prevValue$iv = $this$update$iv.getValue();
                            it = (ChecklistStrategyState)prevValue$iv;
                            $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$3 = false;
                        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ChecklistStrategyState.copy$default(it, new StrategyStatus.Error(1), "Kein g\u00fcltiger Wochentag", 0, 4, null))));
                        $this$update$iv = Unit.INSTANCE;
                        currentState = (ChecklistStrategyState)ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0).getValue();
                        if (Intrinsics.areEqual((Object)currentState.getStatus(), (Object)StrategyStatus.Running.INSTANCE)) {
                            $this$update$iv = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                            $i$f$update = false;
                            do {
                                prevValue$iv = $this$update$iv.getValue();
                                it = (ChecklistStrategyState)prevValue$iv;
                                $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$13 = false;
                            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ChecklistStrategyState.copy$default(it, StrategyStatus.Idle.INSTANCE, null, 0, 6, null))));
                        }
                        return $this$update$iv;
lbl106:
                        // 2 sources

                        if (this.this$0.getValidTimeNY().contains((Comparable)DateKt.now((TimeZone)TimezoneKt.getNewYorkTimezone()).getTime())) ** GOTO lbl131
                        $this$update$iv = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                        currentState = this.this$0;
                        $i$f$update = false;
                        do {
                            prevValue$iv = $this$update$iv.getValue();
                            it = (ChecklistStrategyState)prevValue$iv;
                            $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$4 = false;
                        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ChecklistStrategyState.copy$default(it, new StrategyStatus.Error(1), "Kein g\u00fcltiges Zeitfenster " + TimezoneKt.getNewYorkTimezone() + " " + currentState.getValidTimeNY() + " (" + TimeZone.Companion.currentSystemDefault() + ": " + currentState.getValidTimeLocal() + ")", 0, 4, null))));
                        $this$update$iv = Unit.INSTANCE;
                        currentState = (ChecklistStrategyState)ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0).getValue();
                        if (Intrinsics.areEqual((Object)currentState.getStatus(), (Object)StrategyStatus.Running.INSTANCE)) {
                            $this$update$iv = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                            $i$f$update = false;
                            do {
                                prevValue$iv = $this$update$iv.getValue();
                                it = (ChecklistStrategyState)prevValue$iv;
                                $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$13 = false;
                            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ChecklistStrategyState.copy$default(it, StrategyStatus.Idle.INSTANCE, null, 0, 6, null))));
                        }
                        return $this$update$iv;
lbl131:
                        // 2 sources

                        $this$update$iv = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                        $i$f$update = false;
                        do {
                            prevValue$iv = $this$update$iv.getValue();
                            it = (ChecklistStrategyState)prevValue$iv;
                            $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$5 = false;
                        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ChecklistStrategyState.copy$default(it, null, null, 1, 3, null))));
                        this.L$0 = underlyingPrice;
                        this.label = 2;
                        v2 = ContractManager.INSTANCE.getOHLCCandles-gwCluXo((Contract)this.this$0.getUnderlying(), DateKt.now().minus-LRDsOJo(DurationKt.toDuration((int)4, (DurationUnit)DurationUnit.DAYS)), DateKt.now(), DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.MINUTES), true, (Continuation)this);
                        ** if (v2 != var14_2) goto lbl147
lbl146:
                        // 1 sources

                        return var14_2;
lbl147:
                        // 1 sources

                        ** GOTO lbl154
                    }
                    case 2: {
                        underlyingPrice = (Price)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl154:
                        // 2 sources

                        this.L$0 = underlyingPrice;
                        this.label = 3;
                        v3 = FlowKt.toList$default((Flow)((Flow)v2), null, (Continuation)((Continuation)this), (int)1, null);
                        ** if (v3 != var14_2) goto lbl159
lbl158:
                        // 1 sources

                        return var14_2;
lbl159:
                        // 1 sources

                        ** GOTO lbl166
                    }
                    case 3: {
                        underlyingPrice = (Price)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v3 = $result;
lbl166:
                        // 2 sources

                        candles30min4days = (List)v3;
                        $this$firstOrNull$iv = candles30min4days;
                        $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            it = (OHLCV)element$iv;
                            $i$a$-firstOrNull-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$candle9_30_10_00$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getStart(), (Object)TimeZoneKt.toInstant$default((LocalDateTime)LocalDateKt.atTime$default((LocalDate)DateKt.today((TimeZone)TimezoneKt.getNewYorkTimezone()), (int)9, (int)30, (int)0, (int)0, (int)12, null), (TimeZone)TimezoneKt.getNewYorkTimezone(), null, (int)2, null))) continue;
                            v4 = element$iv;
                            ** GOTO lbl176
                        }
                        v4 = null;
lbl176:
                        // 2 sources

                        v5 = candle9_30_10_00 = (OHLCV)v4;
                        if (v5 != null) {
                            it = v5;
                            $i$a$-let-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$lastCandleBefore$1 = false;
                            v6 = (OHLCV)checkPreConditions.2.invokeSuspend$previousOf(candles30min4days, it);
                        } else {
                            v6 = lastCandleBefore = null;
                        }
                        if (candle9_30_10_00 == null || lastCandleBefore == null) {
                            $this$update$iv = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                            $i$f$update = false;
                            do {
                                prevValue$iv = $this$update$iv.getValue();
                                it = (ChecklistStrategyState)prevValue$iv;
                                $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$6 = false;
                            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ChecklistStrategyState.copy$default((ChecklistStrategyState)it, new StrategyStatus.Error(2), "Keine historischen Daten verf\u00fcgbar", 0, 4, null))));
                            $this$update$iv = Unit.INSTANCE;
                            return $this$update$iv;
                        }
                        if (lastCandleBefore.getClose() == null || candle9_30_10_00.getOpen() == null) ** GOTO lbl-1000
                        v7 = lastCandleBefore.getClose();
                        Intrinsics.checkNotNull((Object)v7);
                        v8 = XbignumKt.toDouble((XBigNum)v7);
                        v9 = candle9_30_10_00.getOpen();
                        Intrinsics.checkNotNull((Object)v9);
                        v10 = v8 - XbignumKt.toDouble((XBigNum)v9);
                        v11 = lastCandleBefore.getClose();
                        Intrinsics.checkNotNull((Object)v11);
                        if (v10 / XbignumKt.toDouble((XBigNum)v11) <= this.this$0.getMaxGapDown()) {
                            v12 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v12 = false;
                        }
                        if (!v12) {
                            $this$update$iv = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                            currentState = this.this$0;
                            $i$f$update = false;
                            do {
                                prevValue$iv = $this$update$iv.getValue();
                                it = (ChecklistStrategyState)prevValue$iv;
                                $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$7 = false;
                                v13 = new StrategyStatus.Error(2);
                                $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$13 = "%.1f";
                                var13_96 = new Object[]{Boxing.boxDouble((double)(currentState.getMaxGapDown() * (double)100))};
                                v14 = String.format($i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$13, Arrays.copyOf(var13_96, var13_96.length));
                                Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"format(...)");
                            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ChecklistStrategyState.copy$default(it, v13, "Vortages Gap down > " + v14 + "%", 0, 4, null))));
                            $this$update$iv = Unit.INSTANCE;
                            return $this$update$iv;
                        }
                        if (lastCandleBefore.getClose() == null || candle9_30_10_00.getOpen() == null) ** GOTO lbl-1000
                        v15 = candle9_30_10_00.getOpen();
                        Intrinsics.checkNotNull((Object)v15);
                        v16 = XbignumKt.toDouble((XBigNum)v15);
                        v17 = lastCandleBefore.getClose();
                        Intrinsics.checkNotNull((Object)v17);
                        v18 = v16 - XbignumKt.toDouble((XBigNum)v17);
                        v19 = lastCandleBefore.getClose();
                        Intrinsics.checkNotNull((Object)v19);
                        if (v18 / XbignumKt.toDouble((XBigNum)v19) <= this.this$0.getMaxGapUp()) {
                            v20 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v20 = false;
                        }
                        if (!v20) {
                            $this$update$iv = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                            currentState = this.this$0;
                            $i$f$update = false;
                            do {
                                prevValue$iv = $this$update$iv.getValue();
                                it = (ChecklistStrategyState)prevValue$iv;
                                $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$8 = false;
                                v21 = new StrategyStatus.Error(2);
                                $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$13 = "%.1f";
                                var13_97 = new Object[]{Boxing.boxDouble((double)(currentState.getMaxGapUp() * (double)100))};
                                v22 = String.format($i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$13, Arrays.copyOf(var13_97, var13_97.length));
                                Intrinsics.checkNotNullExpressionValue((Object)v22, (String)"format(...)");
                            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ChecklistStrategyState.copy$default(it, v21, "Vortages Gap up > " + v22 + "%", 0, 4, null))));
                            $this$update$iv = Unit.INSTANCE;
                            return $this$update$iv;
                        }
                        $this$update$iv = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                        $i$f$update = false;
                        do {
                            prevValue$iv = $this$update$iv.getValue();
                            it = (ChecklistStrategyState)prevValue$iv;
                            $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$9 = false;
                        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ChecklistStrategyState.copy$default((ChecklistStrategyState)it, null, null, 2, 3, null))));
                        it = candle9_30_10_00;
                        $i$a$-let-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$10 = false;
                        if (it.getClose() == null || it.getOpen() == null) ** GOTO lbl-1000
                        v23 = it.getClose();
                        Intrinsics.checkNotNull((Object)v23);
                        v24 = it.getOpen();
                        Intrinsics.checkNotNull((Object)v24);
                        if (v23.compareTo(v24) > 0) {
                            v25 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v25 = false;
                        }
                        if (!v25) {
                            $this$update$iv = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                            it = this.this$0;
                            $i$f$update = false;
                            do {
                                prevValue$iv = $this$update$iv.getValue();
                                it = (ChecklistStrategyState)prevValue$iv;
                                $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$11 = false;
                            } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ChecklistStrategyState.copy$default(it, new StrategyStatus.Error(3), "Initial Balance " + TimezoneKt.getNewYorkTimezone() + " " + it.getIbTimeNY().getStart() + "-" + it.getIbTimeNY().getEndInclusive() + " (" + TimeZone.Companion.currentSystemDefault() + ": " + it.getIbTimeNY().getStart() + "-" + it.getIbTimeNY().getEndInclusive() + ") nicht positiv", 0, 4, null))));
                            $this$update$iv = Unit.INSTANCE;
                            return $this$update$iv;
                        }
                        $this$update$iv = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                        $i$f$update = false;
                        do {
                            prevValue$iv = $this$update$iv.getValue();
                            it = (ChecklistStrategyState)prevValue$iv;
                            $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$12 = false;
                        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = it.copy(StrategyStatus.Idle.INSTANCE, "PreCheck erfolgreich. Trade kann er\u00f6ffnet werden.", 3))));
                        ** GOTO lbl316
                    }
                    catch (Throwable var2_4) {
                        throw var2_4;
                    }
                    {
                        finally {
                            currentState = (ChecklistStrategyState)ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0).getValue();
                            if (Intrinsics.areEqual((Object)currentState.getStatus(), (Object)StrategyStatus.Running.INSTANCE)) {
                                $this$update$iv = ZeroDTEOpeningPut20Strategy.access$get_state$p(this.this$0);
                                $i$f$update = false;
                                do {
                                    prevValue$iv = $this$update$iv.getValue();
                                    it = (ChecklistStrategyState)prevValue$iv;
                                    $i$a$-update-ZeroDTEOpeningPut20Strategy$checkPreConditions$2$13 = false;
                                } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = ChecklistStrategyState.copy$default(it, StrategyStatus.Idle.INSTANCE, null, 0, 6, null))));
                            }
                        }
lbl316:
                        // 1 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final <T> T invokeSuspend$previousOf(List<? extends T> $this$invokeSuspend_u24previousOf, T element) {
                return (T)CollectionsKt.getOrNull($this$invokeSuspend_u24previousOf, (int)($this$invokeSuspend_u24previousOf.indexOf(element) - 1));
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object placeOrder(int size, @Nullable String accountId, boolean transmit, @NotNull Continuation<? super Unit> $completion) {
        Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, size, accountId, transmit, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            Object L$7;
            Object L$8;
            Object L$9;
            Object L$10;
            Object L$11;
            Object L$12;
            double D$0;
            double D$1;
            int I$0;
            int label;
            final /* synthetic */ ZeroDTEOpeningPut20Strategy this$0;
            final /* synthetic */ int $size;
            final /* synthetic */ String $accountId;
            final /* synthetic */ boolean $transmit;
            {
                this.this$0 = $receiver;
                this.$size = $size;
                this.$accountId = $accountId;
                this.$transmit = $transmit;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object $result) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public ZeroDTEOpeningPut20Strategy() {
        this(null, null, null, null, null, 0.0, 0.0, 127, null);
    }

    public static final /* synthetic */ MutableStateFlow access$get_state$p(ZeroDTEOpeningPut20Strategy $this) {
        return $this._state;
    }
}

