/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.business.backup;

import com.xorrus.trading.common.DateKt;
import com.xorrus.trading.lot.business.backup.BackupResult;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.time.Clock;
import kotlin.time.Instant;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\b\u0002\u0010\r\u001a\u00020\u0005J$\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0016\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/xorrus/trading/lot/business/backup/BackupManager;", "", "<init>", "()V", "DEFAULT_MAX_BACKUPS", "", "BACKUP_FILENAME_FORMAT", "", "createBackup", "Lcom/xorrus/trading/lot/business/backup/BackupResult;", "dbDir", "Ljava/nio/file/Path;", "backupDir", "maxBackups", "backupDirectory", "Lkotlin/Pair;", "", "sourceDir", "zipFile", "rotateBackups", "", "restoreDirectory", "targetDir", "logger", "Lorg/slf4j/Logger;", "laboftrades-business"})
@SourceDebugExtension(value={"SMAP\nBackupManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackupManager.kt\ncom/xorrus/trading/lot/business/backup/BackupManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1321#2:131\n1322#2:133\n1321#2,2:137\n1#3:132\n1068#4:134\n1869#4,2:135\n*S KotlinDebug\n*F\n+ 1 BackupManager.kt\ncom/xorrus/trading/lot/business/backup/BackupManager\n*L\n75#1:131\n75#1:133\n108#1:137,2\n88#1:134\n91#1:135,2\n*E\n"})
public final class BackupManager {
    @NotNull
    public static final BackupManager INSTANCE = new BackupManager();
    private static final int DEFAULT_MAX_BACKUPS = 10;
    @NotNull
    private static final String BACKUP_FILENAME_FORMAT = "yyyy-MM-dd_HH-mm-ss";
    @NotNull
    private static final Logger logger;

    private BackupManager() {
    }

    @NotNull
    public final BackupResult createBackup(@NotNull Path dbDir, @NotNull Path backupDir, int maxBackups) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dbDir, (String)"dbDir");
        Intrinsics.checkNotNullParameter((Object)backupDir, (String)"backupDir");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(dbDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            logger.warn("Backup konnte nicht durchgef\u00fchrt werden. Datenbankpfad " + dbDir + " existiert nicht.");
            return new BackupResult.SourceNotFound(dbDir);
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (!Files.exists(backupDir, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            Files.createDirectories(backupDir, new FileAttribute[0]);
        }
        String timestamp = DateKt.toString$default((LocalDateTime)TimeZoneKt.toLocalDateTime((Instant)Clock.System.INSTANCE.now(), (TimeZone)((TimeZone)TimeZone.Companion.getUTC())), (String)BACKUP_FILENAME_FORMAT, null, (int)2, null);
        Path backupFile = backupDir.resolve(timestamp + ".zip");
        Path tempFile = backupDir.resolve(timestamp + ".zip.tmp");
        try {
            Intrinsics.checkNotNull((Object)tempFile);
            object = this.backupDirectory(dbDir, tempFile);
            int fileCount = ((Number)object.component1()).intValue();
            long sizeBytes = ((Number)object.component2()).longValue();
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE};
            Files.move(tempFile, backupFile, copyOptionArray);
            this.rotateBackups(backupDir, maxBackups);
            logger.info("Backup erstellt: " + backupFile + " (" + fileCount + " Dateien, " + sizeBytes / (long)1024 + " KB)");
            Intrinsics.checkNotNull((Object)backupFile);
            object = new BackupResult.Success(backupFile, fileCount, sizeBytes);
        }
        catch (Exception e) {
            logger.error("Backup fehlgeschlagen f\u00fcr " + dbDir, (Throwable)e);
            Intrinsics.checkNotNull((Object)tempFile);
            Files.deleteIfExists(tempFile);
            object = new BackupResult.Failed(e);
        }
        return object;
    }

    public static /* synthetic */ BackupResult createBackup$default(BackupManager backupManager, Path path, Path path2, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 10;
        }
        return backupManager.createBackup(path, path2, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final Pair<Integer, Long> backupDirectory(Path sourceDir, Path zipFile) {
        int fileCount = 0;
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(zipFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        int n = 8192;
        closeable = new ZipOutputStream(closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n));
        Throwable throwable = null;
        try {
            void $this$forEach$iv;
            ZipOutputStream zos = (ZipOutputStream)closeable;
            boolean bl = false;
            File file = sourceDir.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            Sequence sequence = SequencesKt.filter((Sequence)((Sequence)FilesKt.walkTopDown((File)file)), BackupManager::backupDirectory$lambda$0$0);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File file2 = (File)element$iv;
                boolean bl2 = false;
                File file3 = sourceDir.toFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"toFile(...)");
                String entryName = FilesKt.relativeTo((File)file2, (File)file3).getPath();
                zos.putNextEntry(new ZipEntry(entryName));
                Closeable closeable2 = new FileInputStream(file2);
                Throwable throwable2 = null;
                try {
                    FileInputStream it = (FileInputStream)closeable2;
                    boolean bl3 = false;
                    long l = ByteStreamsKt.copyTo$default((InputStream)it, (OutputStream)zos, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                }
                zos.closeEntry();
                ++fileCount;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return TuplesKt.to((Object)fileCount, (Object)Files.size(zipFile));
    }

    /*
     * WARNING - void declaration
     */
    private final void rotateBackups(Path backupDir, int maxBackups) {
        void $this$sortedByDescending$iv;
        Iterable iterable = PathsKt.listDirectoryEntries((Path)backupDir, (String)"*.zip");
        boolean $i$f$sortedByDescending = false;
        List backups = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Path it = (Path)b;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                FileTime fileTime = Files.getLastModifiedTime(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                it = (Path)a;
                Comparable comparable = fileTime;
                bl = false;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                FileTime fileTime2 = Files.getLastModifiedTime(it, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"getLastModifiedTime(...)");
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)fileTime2);
            }
        });
        if (backups.size() > maxBackups) {
            Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)backups, (int)maxBackups);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path oldBackup = (Path)element$iv;
                boolean bl = false;
                logger.info("L\u00f6sche altes Backup: " + oldBackup);
                Files.deleteIfExists(oldBackup);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final BackupResult restoreDirectory(@NotNull Path zipFile, @NotNull Path targetDir) {
        BackupResult backupResult;
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(zipFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return new BackupResult.SourceNotFound(zipFile);
        }
        try {
            int fileCount = 0;
            OpenOption[] openOptionArray = new OpenOption[]{};
            InputStream inputStream = Files.newInputStream(zipFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            Closeable closeable = inputStream;
            int n = 8192;
            closeable = new ZipInputStream(closeable instanceof BufferedInputStream ? (BufferedInputStream)closeable : new BufferedInputStream((InputStream)closeable, n));
            Throwable throwable = null;
            try {
                void $this$forEach$iv;
                ZipInputStream zis = (ZipInputStream)closeable;
                boolean bl = false;
                Sequence sequence = SequencesKt.filterNot((Sequence)SequencesKt.generateSequence(() -> BackupManager.restoreDirectory$lambda$0$0(zis)), BackupManager::restoreDirectory$lambda$0$1);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ZipEntry entry = (ZipEntry)element$iv;
                    boolean bl2 = false;
                    Path targetFile = targetDir.resolve(entry.getName()).normalize();
                    if (!targetFile.startsWith(targetDir)) {
                        boolean bl3 = false;
                        String string = "Ung\u00fcltiger Zip-Eintrag: " + entry.getName();
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (targetFile.getParent() != null) {
                        Path it;
                        boolean bl4 = false;
                        Files.createDirectories(it, new FileAttribute[0]);
                    }
                    Intrinsics.checkNotNull((Object)targetFile);
                    OpenOption[] openOptionArray2 = new OpenOption[]{};
                    OutputStream outputStream = Files.newOutputStream(targetFile, Arrays.copyOf(openOptionArray2, openOptionArray2.length));
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                    Closeable closeable2 = outputStream;
                    Throwable throwable2 = null;
                    try {
                        OutputStream out = (OutputStream)closeable2;
                        boolean bl5 = false;
                        long l = ByteStreamsKt.copyTo$default((InputStream)zis, (OutputStream)out, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
                    }
                    ++fileCount;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            logger.info("Restore abgeschlossen: " + fileCount + " Dateien nach " + targetDir);
            backupResult = new BackupResult.Success(targetDir, fileCount, 0L);
        }
        catch (Exception e) {
            logger.error("Restore fehlgeschlagen f\u00fcr " + zipFile, (Throwable)e);
            backupResult = new BackupResult.Failed(e);
        }
        return backupResult;
    }

    private static final boolean backupDirectory$lambda$0$0(File it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isFile();
    }

    private static final ZipEntry restoreDirectory$lambda$0$0(ZipInputStream $zis) {
        return $zis.getNextEntry();
    }

    private static final boolean restoreDirectory$lambda$0$1(ZipEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isDirectory();
    }

    static {
        Logger logger = LoggerFactory.getLogger(BackupManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        BackupManager.logger = logger;
    }
}

