/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.common.dbmigration.migration;

import com.xorrus.common.dbmigration.dialect.HyperSqlDbDialect;
import com.xorrus.common.dbmigration.dialect.PostgresqlDialect;
import com.xorrus.common.dbmigration.dialect.SqlDatabaseDialect;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.sql2o.Connection;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0016\u0010\n\u001a\u00020\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0001\u001a\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0010"}, d2={"fetchCurrentDatabaseVersion", "", "con", "Lorg/sql2o/Connection;", "checkIfTableExists", "", "tableName", "", "createNewDbVersionTable", "", "updateDbVersionTable", "version", "findDatabaseDialect", "Lcom/xorrus/common/dbmigration/dialect/SqlDatabaseDialect;", "dataSource", "Ljavax/sql/DataSource;", "laboftrades-business"})
public final class Db_versionKt {
    public static final int fetchCurrentDatabaseVersion(@NotNull Connection con) {
        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        if (!Db_versionKt.checkIfTableExists(con, "dbversion")) {
            Db_versionKt.createNewDbVersionTable(con);
        }
        String sql = "SELECT \"version\" FROM \"dbversion\"";
        boolean bl = false;
        Integer currentVersion = (Integer)con.createQuery(sql).executeScalar(Integer.TYPE);
        Intrinsics.checkNotNull((Object)currentVersion);
        return currentVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean checkIfTableExists(@NotNull Connection con, @NotNull String tableName) {
        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        Intrinsics.checkNotNullParameter((Object)tableName, (String)"tableName");
        DatabaseMetaData metaData = con.getJdbcConnection().getMetaData();
        Object object = new String[]{"TABLE"};
        object = metaData.getTables(null, null, tableName, (String[])object);
        Throwable throwable = null;
        try {
            ResultSet tables = (ResultSet)object;
            boolean bl = false;
            boolean bl2 = tables.next();
            return bl2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)object, (Throwable)throwable);
        }
    }

    public static final void createNewDbVersionTable(@NotNull Connection con) {
        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        String sql = "CREATE TABLE \"dbversion\" (\"version\" INTEGER NOT NULL PRIMARY KEY)";
        boolean bl = false;
        con.createQuery(sql).executeUpdate();
        sql = "INSERT INTO \"dbversion\" (\"version\") VALUES (0)";
        boolean bl2 = false;
        con.createQuery(sql).executeUpdate();
    }

    public static final void updateDbVersionTable(@NotNull Connection con, int version) {
        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        con.createQuery("UPDATE \"dbversion\" set \"version\" = :version").addParameter("version", version).executeUpdate();
    }

    @NotNull
    public static final SqlDatabaseDialect findDatabaseDialect(@NotNull DataSource dataSource) {
        SqlDatabaseDialect sqlDatabaseDialect;
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        String string = dataSource.getConnection().getMetaData().getDatabaseProductName();
        if (Intrinsics.areEqual((Object)string, (Object)"PostgreSQL")) {
            sqlDatabaseDialect = new PostgresqlDialect();
        } else if (Intrinsics.areEqual((Object)string, (Object)"HSQL Database Engine")) {
            sqlDatabaseDialect = new HyperSqlDbDialect();
        } else {
            throw new NotImplementedError("Unknown database: " + dataSource.getConnection().getMetaData().getDatabaseProductName());
        }
        return sqlDatabaseDialect;
    }
}

