/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.common.dbmigration.dialect;

import com.xorrus.common.dbmigration.dialect.SqlDatabaseDialect;
import com.xorrus.common.dbmigration.meta.Column;
import com.xorrus.common.dbmigration.meta.Database;
import com.xorrus.common.dbmigration.meta.Datatype;
import com.xorrus.common.dbmigration.meta.ForeignKey;
import com.xorrus.common.dbmigration.meta.Index;
import com.xorrus.common.dbmigration.meta.PrimaryKey;
import com.xorrus.trading.common.bignum.XBigNum;
import java.sql.Blob;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.sql2o.Connection;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J(\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005H\u0016J(\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006$"}, d2={"Lcom/xorrus/common/dbmigration/dialect/PostgresqlDialect;", "Lcom/xorrus/common/dbmigration/dialect/SqlDatabaseDialect;", "<init>", "()V", "defaultSchemaName", "", "getDefaultSchemaName", "()Ljava/lang/String;", "mapToSqlType", "datatype", "Lcom/xorrus/common/dbmigration/meta/Datatype;", "nameColumn", "column", "Lcom/xorrus/common/dbmigration/meta/Column;", "nameUniqueKey", "uniqueKeyName", "shortenString", "s", "runRemoveNotNullConstraint", "", "con", "Lorg/sql2o/Connection;", "database", "Lcom/xorrus/common/dbmigration/meta/Database;", "runRenamePrimaryKey", "primaryKey", "Lcom/xorrus/common/dbmigration/meta/PrimaryKey;", "primaryKeyName", "runRenameForeignKey", "foreignKey", "Lcom/xorrus/common/dbmigration/meta/ForeignKey;", "foreignKeyName", "renameIndex", "index", "Lcom/xorrus/common/dbmigration/meta/Index;", "indexName", "laboftrades-business"})
public final class PostgresqlDialect
extends SqlDatabaseDialect {
    @NotNull
    private final String defaultSchemaName;

    public PostgresqlDialect() {
        this.defaultSchemaName = "public";
    }

    @Override
    @NotNull
    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    @Override
    @NotNull
    public String mapToSqlType(@NotNull Datatype datatype) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)datatype, (String)"datatype");
        KClass<?> kClass = datatype.getClazz();
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Blob.class))) {
            object = "OID";
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            object = "BOOL";
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(byte[].class))) {
            object = "BYTEA";
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Instant.class))) {
            object = "TIMESTAMPTZ";
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(XBigNum.class))) {
            object = "NUMERIC";
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            object = "INT";
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(LocalDate.class))) {
            object = "DATE";
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(kotlinx.datetime.LocalDate.class))) {
            object = "DATE";
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            object = "BIGINT";
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
            object = "VARCHAR" + (String)(datatype.getLength() != null ? "(" + datatype.getLength() + ")" : "");
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(UUID.class))) {
            object = "UUID";
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(ZonedDateTime.class))) {
            object = "TIMESTAMPTZ";
        } else {
            throw new IllegalStateException(("Nicht unterst\u00fctzter Datentyp f\u00fcr PostgresqlDialect: " + datatype).toString());
        }
        return object;
    }

    @Override
    @NotNull
    public String nameColumn(@NotNull Column column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        return this.shortenString(super.nameColumn(column));
    }

    @Override
    @NotNull
    public String nameUniqueKey(@NotNull String uniqueKeyName) {
        Intrinsics.checkNotNullParameter((Object)uniqueKeyName, (String)"uniqueKeyName");
        return this.shortenString(super.nameUniqueKey(uniqueKeyName));
    }

    private final String shortenString(String s) {
        return StringsKt.take((String)s, (int)62);
    }

    @Override
    public void runRemoveNotNullConstraint(@NotNull Connection con, @NotNull Database database, @NotNull Column column) {
        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        String sql = StringsKt.trimIndent((String)("\n            ALTER TABLE " + this.quoteTable(column.getTable().getTableName()) + "\n            ALTER COLUMN " + this.quoteColumn(column) + "\n            DROP NOT NULL;\n        "));
        this.getExecuteSql().invoke((Object)con, (Object)sql);
    }

    @Override
    public void runRenamePrimaryKey(@NotNull Connection con, @NotNull Database database, @NotNull PrimaryKey primaryKey, @NotNull String primaryKeyName) {
        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)primaryKey, (String)"primaryKey");
        Intrinsics.checkNotNullParameter((Object)primaryKeyName, (String)"primaryKeyName");
        String sql = StringsKt.trimIndent((String)("\n            ALTER TABLE " + this.quoteTable(primaryKey.getTable().getTableName()) + "\n            RENAME CONSTRAINT " + this.quotePrimaryKey(primaryKey.getPrimaryKeyName()) + " to " + this.quotePrimaryKey(primaryKeyName) + ";\n        "));
        this.getExecuteSql().invoke((Object)con, (Object)sql);
    }

    @Override
    public void runRenameForeignKey(@NotNull Connection con, @NotNull Database database, @NotNull ForeignKey foreignKey, @NotNull String foreignKeyName) {
        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)foreignKey, (String)"foreignKey");
        Intrinsics.checkNotNullParameter((Object)foreignKeyName, (String)"foreignKeyName");
        String sql = StringsKt.trimIndent((String)("\n            ALTER TABLE " + this.quoteTable(foreignKey.getTable().getTableName()) + "\n            RENAME CONSTRAINT " + this.quoteForeignKey(foreignKey.getForeignKeyName()) + " to " + this.quoteForeignKey(foreignKeyName) + ";\n        "));
        this.getExecuteSql().invoke((Object)con, (Object)sql);
    }

    @Override
    public void renameIndex(@NotNull Connection con, @NotNull Database database, @NotNull Index index, @NotNull String indexName) {
        Intrinsics.checkNotNullParameter((Object)con, (String)"con");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        Intrinsics.checkNotNullParameter((Object)indexName, (String)"indexName");
        String sql = StringsKt.trimIndent((String)("\n            ALTER INDEX " + this.quoteIndex(index.getIndexName()) + " RENAME TO " + this.quoteIndex(indexName) + ";\n        "));
        this.getExecuteSql().invoke((Object)con, (Object)sql);
    }
}

