/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.common.dbmigration;

import com.xorrus.common.dbmigration.command.Command;
import com.xorrus.common.dbmigration.dialect.MetaModelDialect;
import com.xorrus.common.dbmigration.dialect.SqlDatabaseDialect;
import com.xorrus.common.dbmigration.meta.Database;
import com.xorrus.common.dbmigration.migration.Db_versionKt;
import com.xorrus.common.dbmigration.upgrade.AbstractDatabaseUpgrade;
import java.io.Closeable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sql2o.Connection;
import org.sql2o.Sql2o;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0014\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rH\u0002J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/xorrus/common/dbmigration/DatabaseUpgradeManager;", "", "upgradeBasePackage", "", "<init>", "(Ljava/lang/String;)V", "getUpgradeBasePackage", "()Ljava/lang/String;", "updateDatabase", "", "dataSource", "Ljavax/sql/DataSource;", "collectAvailableUpgrades", "", "", "Lcom/xorrus/common/dbmigration/upgrade/AbstractDatabaseUpgrade;", "buildUpgradeClassName", "upgradeNumber", "logger", "Lorg/slf4j/Logger;", "Companion", "laboftrades-business"})
@SourceDebugExtension(value={"SMAP\nDatabaseUpgradeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseUpgradeManager.kt\ncom/xorrus/common/dbmigration/DatabaseUpgradeManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,115:1\n536#2:116\n521#2,6:117\n536#2:123\n521#2,6:124\n1285#3,2:130\n1299#3,4:132\n1869#3,2:137\n1869#3,2:141\n216#4:136\n217#4:139\n216#4:140\n217#4:143\n*S KotlinDebug\n*F\n+ 1 DatabaseUpgradeManager.kt\ncom/xorrus/common/dbmigration/DatabaseUpgradeManager\n*L\n39#1:116\n39#1:117,6\n42#1:123\n42#1:124,6\n47#1:130,2\n47#1:132,4\n62#1:137,2\n72#1:141,2\n58#1:136\n58#1:139\n68#1:140\n68#1:143\n*E\n"})
public final class DatabaseUpgradeManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String upgradeBasePackage;
    @NotNull
    private final Logger logger;
    private static final int DATABASE_VERSION = 1;

    public DatabaseUpgradeManager(@NotNull String upgradeBasePackage) {
        Intrinsics.checkNotNullParameter((Object)upgradeBasePackage, (String)"upgradeBasePackage");
        this.upgradeBasePackage = upgradeBasePackage;
        Logger logger = LoggerFactory.getLogger(DatabaseUpgradeManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public final String getUpgradeBasePackage() {
        return this.upgradeBasePackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void updateDatabase(@NotNull DataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        Closeable closeable = (Closeable)new Sql2o(dataSource).open();
        Throwable throwable = null;
        try {
            void $this$associateWithTo$iv$iv;
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Map<Integer, AbstractDatabaseUpgrade> availableUpgrades;
            Connection con = (Connection)closeable;
            boolean bl = false;
            con.getJdbcConnection().setAutoCommit(false);
            Intrinsics.checkNotNull((Object)con);
            int currentVersion = Db_versionKt.fetchCurrentDatabaseVersion(con);
            con.commit(false);
            if (!(currentVersion <= 1)) {
                boolean $i$a$-require-DatabaseUpgradeManager$updateDatabase$1$232 = false;
                String $i$a$-require-DatabaseUpgradeManager$updateDatabase$1$232 = "Aktuelle Datenbank (version = " + currentVersion + ") ist neuer als die Anwendung (APPLICATION_DB_VERSION = 1).";
                throw new IllegalArgumentException($i$a$-require-DatabaseUpgradeManager$updateDatabase$1$232.toString());
            }
            this.logger.info("Aktuelle Datenbankversion = " + currentVersion);
            this.logger.info("Ziel-Datenbankversion = 1");
            Map<Integer, AbstractDatabaseUpgrade> $this$filter$iv = availableUpgrades = this.collectAvailableUpgrades();
            boolean $i$f$filter = false;
            Map<Integer, AbstractDatabaseUpgrade> map = $this$filter$iv;
            Map<Integer, AbstractDatabaseUpgrade> destination$iv$iv = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl2 = false;
                int upgradeVersion = ((Number)entry2.getKey()).intValue();
                if (!(upgradeVersion > currentVersion)) continue;
                destination$iv$iv.put((Integer)entry.getKey(), (AbstractDatabaseUpgrade)entry.getValue());
            }
            Map<Integer, AbstractDatabaseUpgrade> missingUpgrades = destination$iv$iv;
            Map<Integer, AbstractDatabaseUpgrade> $this$filter$iv2 = availableUpgrades;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Map<Integer, AbstractDatabaseUpgrade> destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo232 = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv3;
                Map.Entry entry = element$iv$iv3 = iterator2.next();
                boolean bl3 = false;
                int upgradeVersion = ((Number)entry.getKey()).intValue();
                if (!(upgradeVersion <= currentVersion)) continue;
                destination$iv$iv2.put((Integer)element$iv$iv3.getKey(), (AbstractDatabaseUpgrade)element$iv$iv3.getValue());
            }
            Map<Integer, AbstractDatabaseUpgrade> executedUpgrades = destination$iv$iv2;
            Iterable $this$associateWith$iv = availableUpgrades.values();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable $i$f$filterTo232 = $this$associateWith$iv;
            Map map2 = result$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv4 : $this$associateWithTo$iv$iv) {
                void upgrade;
                AbstractDatabaseUpgrade upgradeVersion = (AbstractDatabaseUpgrade)element$iv$iv4;
                Object t = element$iv$iv4;
                Map map3 = map2;
                boolean bl4 = false;
                upgrade.buildCommands();
                List<Command> list = upgrade.getCommands();
                map3.put(t, list);
            }
            Map mapUpgradeToCommands = map2;
            SqlDatabaseDialect databaseDialect = Db_versionKt.findDatabaseDialect(dataSource);
            Database database = new Database(databaseDialect);
            MetaModelDialect metaModelDialect = new MetaModelDialect(databaseDialect);
            Map<Integer, AbstractDatabaseUpgrade> $this$forEach$iv = executedUpgrades;
            boolean bl3 = false;
            Iterator<Map.Entry<Object, Object>> iterator3 = $this$forEach$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry entry;
                Map.Entry entry3 = entry = iterator3.next();
                boolean bl5 = false;
                AbstractDatabaseUpgrade upgrade = (AbstractDatabaseUpgrade)entry3.getValue();
                this.logger.debug("Executing " + Reflection.getOrCreateKotlinClass(upgrade.getClass()).getSimpleName());
                List commands = (List)MapsKt.getValue((Map)mapUpgradeToCommands, (Object)upgrade);
                Iterable $this$forEach$iv2 = commands;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Command command = (Command)element$iv2;
                    boolean bl6 = false;
                    metaModelDialect.execute(con, database, command);
                }
            }
            $this$forEach$iv = missingUpgrades;
            boolean bl4 = false;
            iterator3 = $this$forEach$iv.entrySet().iterator();
            while (iterator3.hasNext()) {
                Map.Entry<Object, Object> entry;
                Map.Entry<Object, Object> entry4 = entry = iterator3.next();
                boolean bl7 = false;
                int version = ((Number)entry4.getKey()).intValue();
                AbstractDatabaseUpgrade upgrade = (AbstractDatabaseUpgrade)entry4.getValue();
                List commands = (List)MapsKt.getValue((Map)mapUpgradeToCommands, (Object)upgrade);
                this.logger.info("Executing " + Reflection.getOrCreateKotlinClass(upgrade.getClass()).getSimpleName());
                Iterable $this$forEach$iv3 = commands;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    Command command = (Command)element$iv3;
                    boolean bl8 = false;
                    databaseDialect.execute(con, database, command);
                    metaModelDialect.execute(con, database, command);
                }
                Db_versionKt.updateDbVersionTable(con, version);
                con.commit(false);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final Map<Integer, AbstractDatabaseUpgrade> collectAvailableUpgrades() {
        AbstractDatabaseUpgrade upgrade;
        Map upgrades = new LinkedHashMap();
        int upgradeNumber = 1;
        do {
            String upgradeClassName = this.buildUpgradeClassName(upgradeNumber);
            Class<?> clazz = Class.forName(upgradeClassName);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"forName(...)");
            KClass clazz2 = JvmClassMappingKt.getKotlinClass(clazz);
            Object object = KClasses.createInstance((KClass)clazz2);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.xorrus.common.dbmigration.upgrade.AbstractDatabaseUpgrade");
            upgrade = (AbstractDatabaseUpgrade)object;
            upgrades.put(upgradeNumber, upgrade);
        } while ((upgradeNumber += upgrade.getStep()) <= 1);
        return upgrades;
    }

    private final String buildUpgradeClassName(int upgradeNumber) {
        String versionPart = StringsKt.padStart((String)String.valueOf(upgradeNumber), (int)3, (char)'0');
        return this.upgradeBasePackage + "Upgrade" + versionPart;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/xorrus/common/dbmigration/DatabaseUpgradeManager$Companion;", "", "<init>", "()V", "DATABASE_VERSION", "", "laboftrades-business"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

