/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.common.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.Closeable;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rJ\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0013"}, d2={"Lcom/xorrus/common/db/DatasourceManager;", "", "databaseUrl", "", "databaseUsername", "databasePassword", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDatabaseUrl", "()Ljava/lang/String;", "getDatabaseUsername", "getDatabasePassword", "createDataSource", "Ljavax/sql/DataSource;", "closeDataSource", "", "dataSource", "createHikariConfig", "Lcom/zaxxer/hikari/HikariConfig;", "laboftrades-business"})
public final class DatasourceManager {
    @NotNull
    private final String databaseUrl;
    @Nullable
    private final String databaseUsername;
    @Nullable
    private final String databasePassword;

    public DatasourceManager(@NotNull String databaseUrl, @Nullable String databaseUsername, @Nullable String databasePassword) {
        Intrinsics.checkNotNullParameter((Object)databaseUrl, (String)"databaseUrl");
        this.databaseUrl = databaseUrl;
        this.databaseUsername = databaseUsername;
        this.databasePassword = databasePassword;
    }

    @NotNull
    public final String getDatabaseUrl() {
        return this.databaseUrl;
    }

    @Nullable
    public final String getDatabaseUsername() {
        return this.databaseUsername;
    }

    @Nullable
    public final String getDatabasePassword() {
        return this.databasePassword;
    }

    @NotNull
    public final DataSource createDataSource() {
        HikariConfig hikariConfig = this.createHikariConfig();
        return (DataSource)new HikariDataSource(hikariConfig);
    }

    public final void closeDataSource(@NotNull DataSource dataSource) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
            Closeable closeable = dataSource instanceof Closeable ? (Closeable)((Object)dataSource) : null;
            if (closeable == null) break block0;
            closeable.close();
        }
    }

    private final HikariConfig createHikariConfig() {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl(this.databaseUrl);
        hikariConfig.setUsername(this.databaseUsername);
        hikariConfig.setPassword(this.databasePassword);
        hikariConfig.setMaximumPoolSize(5);
        hikariConfig.setAutoCommit(false);
        hikariConfig.setTransactionIsolation("TRANSACTION_REPEATABLE_READ");
        hikariConfig.validate();
        return hikariConfig;
    }
}

