/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.common.db;

import com.xorrus.common.db.DatasourceManager;
import com.xorrus.common.dbmigration.DatabaseUpgradeManager;
import com.xorrus.common.entity.InstantScalarTypeConverter;
import com.xorrus.common.entity.LocalDateScalarTypeConverter;
import com.xorrus.common.entity.XBigNumScalarTypeConverter;
import io.ebean.Database;
import io.ebean.DatabaseBuilder;
import io.ebean.DatabaseFactory;
import io.ebean.config.DatabaseConfig;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.platform.hsqldb.HsqldbPlatform;
import io.ebean.platform.postgres.PostgresPlatform;
import java.io.Closeable;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JL\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00172:\b\u0002\u0010\u0018\u001a4\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001d\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b\u001b\u0012\b\b\u001c\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0019J\u0006\u0010\u001f\u001a\u00020\u0015J\u001e\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020\nJ\u0010\u0010&\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020\nH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006)"}, d2={"Lcom/xorrus/common/db/DatabaseManager;", "", "upgradeBasePackage", "", "<init>", "(Ljava/lang/String;)V", "getUpgradeBasePackage", "()Ljava/lang/String;", "dataSourceFactory", "Lkotlin/Function0;", "Ljavax/sql/DataSource;", "getDataSourceFactory", "()Lkotlin/jvm/functions/Function0;", "setDataSourceFactory", "(Lkotlin/jvm/functions/Function0;)V", "dataSource", "getDataSource", "()Ljavax/sql/DataSource;", "setDataSource", "(Ljavax/sql/DataSource;)V", "connect", "", "upgradeDatabase", "", "progressCallback", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "progress", "text", "disconnect", "createDataSource", "databaseUrl", "databaseUsername", "databasePassword", "initializeEbean", "Lio/ebean/Database;", "getDatabaseType", "Lcom/xorrus/common/db/DatabaseManager$DatabaseType;", "DatabaseType", "laboftrades-business"})
public final class DatabaseManager {
    @NotNull
    private final String upgradeBasePackage;
    public Function0<? extends DataSource> dataSourceFactory;
    @Nullable
    private DataSource dataSource;

    public DatabaseManager(@NotNull String upgradeBasePackage) {
        Intrinsics.checkNotNullParameter((Object)upgradeBasePackage, (String)"upgradeBasePackage");
        this.upgradeBasePackage = upgradeBasePackage;
    }

    @NotNull
    public final String getUpgradeBasePackage() {
        return this.upgradeBasePackage;
    }

    @NotNull
    public final Function0<DataSource> getDataSourceFactory() {
        Function0<? extends DataSource> function0 = this.dataSourceFactory;
        if (function0 != null) {
            return function0;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"dataSourceFactory");
        return null;
    }

    public final void setDataSourceFactory(@NotNull Function0<? extends DataSource> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        this.dataSourceFactory = function0;
    }

    @Nullable
    public final DataSource getDataSource() {
        return this.dataSource;
    }

    public final void setDataSource(@Nullable DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public final void connect(boolean upgradeDatabase, @Nullable Function2<? super Double, ? super String, Unit> progressCallback) {
        DataSource dataSource;
        Function2<? super Double, ? super String, Unit> function2 = progressCallback;
        if (function2 != null) {
            function2.invoke((Object)0.2, (Object)"Suche Datenbank\u2026");
        }
        this.dataSource = dataSource = (DataSource)this.getDataSourceFactory().invoke();
        Function2<? super Double, ? super String, Unit> function22 = progressCallback;
        if (function22 != null) {
            function22.invoke((Object)0.4, (Object)"Datenbank aktualisieren\u2026");
        }
        if (upgradeDatabase) {
            new DatabaseUpgradeManager(this.upgradeBasePackage).updateDatabase(dataSource);
        }
        Function2<? super Double, ? super String, Unit> function23 = progressCallback;
        if (function23 != null) {
            function23.invoke((Object)0.6, (Object)"Lade Anwendung\u2026");
        }
        this.initializeEbean(dataSource);
    }

    public static /* synthetic */ void connect$default(DatabaseManager databaseManager, boolean bl, Function2 function2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        if ((n & 2) != 0) {
            function2 = null;
        }
        databaseManager.connect(bl, (Function2<? super Double, ? super String, Unit>)function2);
    }

    public final void disconnect() {
        block0: {
            DataSource dataSource = this.dataSource;
            Closeable closeable = dataSource instanceof Closeable ? (Closeable)((Object)dataSource) : null;
            if (closeable == null) break block0;
            closeable.close();
        }
    }

    @NotNull
    public final DataSource createDataSource(@NotNull String databaseUrl, @NotNull String databaseUsername, @NotNull String databasePassword) {
        Intrinsics.checkNotNullParameter((Object)databaseUrl, (String)"databaseUrl");
        Intrinsics.checkNotNullParameter((Object)databaseUsername, (String)"databaseUsername");
        Intrinsics.checkNotNullParameter((Object)databasePassword, (String)"databasePassword");
        return new DatasourceManager(databaseUrl, databaseUsername, databasePassword).createDataSource();
    }

    @NotNull
    public final Database initializeEbean(@NotNull DataSource dataSource) {
        Intrinsics.checkNotNullParameter((Object)dataSource, (String)"dataSource");
        DatabaseConfig config = new DatabaseConfig();
        config.setName("om");
        config.setDefaultServer(true);
        config.setAllQuotedIdentifiers(true);
        config.setDataSource(dataSource);
        config.setDatabasePlatform(switch (WhenMappings.$EnumSwitchMapping$0[this.getDatabaseType(dataSource).ordinal()]) {
            case 1 -> (DatabasePlatform)new PostgresPlatform();
            case 2 -> (DatabasePlatform)new HsqldbPlatform();
            default -> throw new NoWhenBranchMatchedException();
        });
        config.loadFromProperties();
        config.addClass(XBigNumScalarTypeConverter.class);
        config.addClass(InstantScalarTypeConverter.class);
        config.addClass(LocalDateScalarTypeConverter.class);
        Database database = DatabaseFactory.create((DatabaseBuilder)((DatabaseBuilder)config));
        Intrinsics.checkNotNullExpressionValue((Object)database, (String)"create(...)");
        return database;
    }

    private final DatabaseType getDatabaseType(DataSource dataSource) {
        DatabaseType databaseType;
        String string = dataSource.getConnection().getMetaData().getDatabaseProductName();
        if (Intrinsics.areEqual((Object)string, (Object)"PostgreSQL")) {
            databaseType = DatabaseType.POSTGRES;
        } else if (Intrinsics.areEqual((Object)string, (Object)"HSQL Database Engine")) {
            databaseType = DatabaseType.HSQLDB;
        } else {
            String string2 = "Unknown database platform: " + dataSource.getConnection().getMetaData().getDatabaseProductName();
            throw new NotImplementedError("An operation is not implemented: " + string2);
        }
        return databaseType;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/xorrus/common/db/DatabaseManager$DatabaseType;", "", "<init>", "(Ljava/lang/String;I)V", "POSTGRES", "HSQLDB", "laboftrades-business"})
    public static final class DatabaseType
    extends Enum<DatabaseType> {
        public static final /* enum */ DatabaseType POSTGRES = new DatabaseType();
        public static final /* enum */ DatabaseType HSQLDB = new DatabaseType();
        private static final /* synthetic */ DatabaseType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static DatabaseType[] values() {
            return (DatabaseType[])$VALUES.clone();
        }

        public static DatabaseType valueOf(String value) {
            return Enum.valueOf(DatabaseType.class, value);
        }

        @NotNull
        public static EnumEntries<DatabaseType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = databaseTypeArray = new DatabaseType[]{DatabaseType.POSTGRES, DatabaseType.HSQLDB};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseType.values().length];
            try {
                nArray[DatabaseType.POSTGRES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.HSQLDB.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

