/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.license;

import com.xorrus.trading.common.DateKt;
import com.xorrus.trading.license.client.LicenseClient;
import com.xorrus.trading.license.common.data.Subscription;
import com.xorrus.trading.lot.app.license.LicenseConst;
import com.xorrus.trading.lot.app.license.LicenseManager;
import java.util.Collection;
import java.util.List;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlin.time.Instant;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u0006J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u0006J\n\u0010\u001d\u001a\u00020\u0018*\u00020\u000bJ\u000e\u0010\u001e\u001a\u00020\u001fH\u0082@\u00a2\u0006\u0002\u0010 R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u0011\u0010!\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0019R\u0011\u0010\"\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0019R\u0011\u0010#\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u0019R\u0011\u0010$\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u0019R\u0011\u0010%\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0019R\u0011\u0010&\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u0019R\u0011\u0010'\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0019R\u0011\u0010(\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u0019R\u0011\u0010)\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0019R\u0011\u0010*\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u0019R\u0011\u0010+\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0019R\u0011\u0010,\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\u0019R\u0011\u0010-\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0019R\u0011\u0010.\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u0019R\u0011\u0010/\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0019R\u0012\u00100\u001a\u000201X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u00064"}, d2={"Lcom/xorrus/trading/lot/app/license/LicenseManager;", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "()V", "licenseKeyProperty", "Ljavafx/beans/property/SimpleObjectProperty;", "", "getLicenseKeyProperty", "()Ljavafx/beans/property/SimpleObjectProperty;", "allLicenses", "Ljavafx/collections/ObservableList;", "Lcom/xorrus/trading/license/common/data/Subscription;", "getAllLicenses", "()Ljavafx/collections/ObservableList;", "validLicenses", "getValidLicenses", "lastUpdate", "Lkotlin/time/Instant;", "REFRESH_INTERVAL", "Lkotlin/time/Duration;", "J", "logger", "Lorg/slf4j/Logger;", "isOnline", "", "()Z", "hasValidLicense", "productNbr", "findLicense", "isValid", "refreshLicenses", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isArgon0DTEOpeningPut20Licensed", "isArgon4DTEWeeklyLicensed", "isArgon45DTEStrangleLicensed", "isArgonSmartEntryLicensed", "isArgonFibonacciLicensed", "isArgonIncomeTradeLicensed", "isArgonLicensed", "isCarbonToolingLicensed", "isCarbonPositionViewLicensed", "isCarbonLicensed", "isLOTEarningsVolaEdgeLicensed", "isSandboxLicensed", "isFeatureAi", "isFeatureIgnorePreCondition", "isFeatureDev", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "laboftrades-app-base"})
@SourceDebugExtension(value={"SMAP\nLicenseManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LicenseManager.kt\ncom/xorrus/trading/lot/app/license/LicenseManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class LicenseManager
implements CoroutineScope {
    @NotNull
    public static final LicenseManager INSTANCE = new LicenseManager();
    private final /* synthetic */ CoroutineScope $$delegate_0;
    @NotNull
    private static final SimpleObjectProperty<String> licenseKeyProperty = new SimpleObjectProperty();
    @NotNull
    private static final ObservableList<Subscription> allLicenses;
    @NotNull
    private static final ObservableList<Subscription> validLicenses;
    @Nullable
    private static Instant lastUpdate;
    private static final long REFRESH_INTERVAL;
    @NotNull
    private static final Logger logger;

    private LicenseManager() {
        this.$$delegate_0 = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
    }

    @NotNull
    public final SimpleObjectProperty<String> getLicenseKeyProperty() {
        return licenseKeyProperty;
    }

    @NotNull
    public final ObservableList<Subscription> getAllLicenses() {
        return allLicenses;
    }

    @NotNull
    public final ObservableList<Subscription> getValidLicenses() {
        return validLicenses;
    }

    public final boolean isOnline() {
        return lastUpdate != null;
    }

    public final boolean hasValidLicense(@NotNull String productNbr) {
        Intrinsics.checkNotNullParameter((Object)productNbr, (String)"productNbr");
        Subscription subscription = this.findLicense(productNbr);
        return subscription != null ? this.isValid(subscription) : false;
    }

    @Nullable
    public final Subscription findLicense(@NotNull String productNbr) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)productNbr, (String)"productNbr");
            Iterable iterable = (Iterable)validLicenses;
            for (Object t : iterable) {
                Subscription it = (Subscription)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getProductNbr(), (Object)productNbr)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isValid(@NotNull Subscription $this$isValid) {
        Intrinsics.checkNotNullParameter((Object)$this$isValid, (String)"<this>");
        if ($this$isValid.getValidFrom() != null) {
            LocalDate localDate = $this$isValid.getValidFrom();
            Intrinsics.checkNotNull((Object)localDate);
            if (localDate.compareTo(DateKt.today$default(null, (int)1, null)) > 0) return false;
        }
        if ($this$isValid.getValidTo() == null) return true;
        LocalDate localDate = $this$isValid.getValidTo();
        Intrinsics.checkNotNull((Object)localDate);
        if (localDate.compareTo(DateKt.today$default(null, (int)1, null)) < 0) return false;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private final Object refreshLicenses(Continuation<? super Unit> $completion) {
        if (!($completion instanceof refreshLicenses.1)) ** GOTO lbl-1000
        var5_2 = $completion;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ LicenseManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return LicenseManager.access$refreshLicenses(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                licenseKey = (String)LicenseManager.licenseKeyProperty.get();
                Intrinsics.checkNotNull((Object)licenseKey);
                $continuation.L$0 = licenseKey;
                $continuation.label = 1;
                v0 = LicenseClient.INSTANCE.listSubscriptions(licenseKey, (Continuation)$continuation);
                ** if (v0 != var6_4) goto lbl21
lbl20:
                // 1 sources

                return var6_4;
lbl21:
                // 1 sources

                ** GOTO lbl28
            }
            case 1: {
                licenseKey = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl28:
                    // 2 sources

                    result = (List)v0;
                    LicenseManager.allLicenses.setAll((Collection)result);
                    LicenseManager.lastUpdate = DateKt.now();
                    LicenseManager.logger.debug("Refreshing licenses... " + LicenseManager.allLicenses.size() + "}");
                }
                catch (Throwable t) {
                    LicenseManager.allLicenses.clear();
                    LicenseManager.logger.warn("Failed to refresh licenses", t);
                    LicenseManager.lastUpdate = null;
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean isArgon0DTEOpeningPut20Licensed() {
        return this.hasValidLicense(LicenseConst.PRODUCT_ARGON_0DTE_OPENING_PUT_20.getProductKey());
    }

    public final boolean isArgon4DTEWeeklyLicensed() {
        return this.hasValidLicense(LicenseConst.PRODUCT_ARGON_4DTE_WEEKLY.getProductKey());
    }

    public final boolean isArgon45DTEStrangleLicensed() {
        return this.hasValidLicense(LicenseConst.PRODUCT_ARGON_45DTE_STRANGLE.getProductKey());
    }

    public final boolean isArgonSmartEntryLicensed() {
        return this.hasValidLicense(LicenseConst.PRODUCT_ARGON_SMART_ENTRY.getProductKey());
    }

    public final boolean isArgonFibonacciLicensed() {
        return this.hasValidLicense(LicenseConst.PRODUCT_ARGON_FIBONACCI.getProductKey());
    }

    public final boolean isArgonIncomeTradeLicensed() {
        return this.hasValidLicense(LicenseConst.PRODUCT_ARGON_INCOME_TRADE.getProductKey());
    }

    public final boolean isArgonLicensed() {
        return this.isArgon0DTEOpeningPut20Licensed() || this.isArgon4DTEWeeklyLicensed() || this.isArgon45DTEStrangleLicensed() || this.isArgonSmartEntryLicensed() || this.isArgonFibonacciLicensed() || this.isArgonIncomeTradeLicensed();
    }

    public final boolean isCarbonToolingLicensed() {
        return this.hasValidLicense(LicenseConst.PRODUCT_CARBON_TOOLING.getProductKey());
    }

    public final boolean isCarbonPositionViewLicensed() {
        return this.hasValidLicense(LicenseConst.PRODUCT_CARBON_OPTION_VIEWER.getProductKey());
    }

    public final boolean isCarbonLicensed() {
        return this.isCarbonToolingLicensed() || this.isCarbonPositionViewLicensed();
    }

    public final boolean isLOTEarningsVolaEdgeLicensed() {
        return this.hasValidLicense(LicenseConst.PRODUCT_LOT_EARNING_VOLA_EDGE.getProductKey());
    }

    public final boolean isSandboxLicensed() {
        return this.isLOTEarningsVolaEdgeLicensed();
    }

    public final boolean isFeatureAi() {
        return this.hasValidLicense(LicenseConst.FEATURE_AI.getProductKey());
    }

    public final boolean isFeatureIgnorePreCondition() {
        return this.hasValidLicense(LicenseConst.FEATURE_IGNORE_PRECONDITION.getProductKey());
    }

    public final boolean isFeatureDev() {
        return this.hasValidLicense(LicenseConst.FEATURE_DEV.getProductKey());
    }

    @NotNull
    public CoroutineContext getCoroutineContext() {
        return this.$$delegate_0.getCoroutineContext();
    }

    private static final boolean validLicenses$lambda$0(Subscription it) {
        Intrinsics.checkNotNull((Object)it);
        return INSTANCE.isValid(it);
    }

    private static final boolean validLicenses$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit _init_$lambda$0(ObservableValue observableValue, String string, String newValue) {
        BuildersKt.launch$default((CoroutineScope)INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
            int label;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = LicenseManager.access$refreshLicenses(LicenseManager.INSTANCE, (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    public static final /* synthetic */ Object access$refreshLicenses(LicenseManager $this, Continuation $completion) {
        return $this.refreshLicenses((Continuation<? super Unit>)$completion);
    }

    static {
        ObservableList observableList = FXCollections.observableArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"observableArrayList(...)");
        allLicenses = observableList;
        validLicenses = (ObservableList)new FilteredList(allLicenses, arg_0 -> LicenseManager.validLicenses$lambda$1(LicenseManager::validLicenses$lambda$0, arg_0));
        REFRESH_INTERVAL = DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES);
        Logger logger = LoggerFactory.getLogger(LicenseManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LicenseManager.logger = logger;
        licenseKeyProperty.addListener((arg_0, arg_1, arg_2) -> LicenseManager._init_$lambda$1(LicenseManager::_init_$lambda$0, arg_0, arg_1, arg_2));
    }
}

