/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.javafx.svg;

import com.github.weisj.jsvg.SVGDocument;
import com.github.weisj.jsvg.parser.SVGLoader;
import com.github.weisj.jsvg.view.FloatSize;
import com.github.weisj.jsvg.view.ViewBox;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.net.URL;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u000e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002\u001a \u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"svgLoader", "Lcom/github/weisj/jsvg/parser/SVGLoader;", "svgImage", "Ljavafx/scene/image/Image;", "resourcePath", "", "url", "Ljava/net/URL;", "width", "", "renderToImage", "document", "Lcom/github/weisj/jsvg/SVGDocument;", "targetWidth", "", "height", "laboftrades-app-base"})
public final class SvgsupportKt {
    @NotNull
    private static final SVGLoader svgLoader = new SVGLoader();

    @NotNull
    public static final Image svgImage(@NotNull String resourcePath) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        URL uRL = new Object(){}.getClass().getResource(resourcePath);
        if (uRL == null) {
            throw new IllegalArgumentException("Resource not found: " + resourcePath);
        }
        URL url2 = uRL;
        return SvgsupportKt.svgImage(url2);
    }

    @NotNull
    public static final Image svgImage(@NotNull URL url2) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        SVGDocument sVGDocument = svgLoader.load(url2);
        if (sVGDocument == null) {
            throw new IllegalArgumentException("Failed to load SVG from: " + url2);
        }
        SVGDocument document = sVGDocument;
        return SvgsupportKt.renderToImage(document);
    }

    @NotNull
    public static final Image svgImage(@NotNull String resourcePath, double width) {
        Intrinsics.checkNotNullParameter((Object)resourcePath, (String)"resourcePath");
        URL uRL = new Object(){}.getClass().getResource(resourcePath);
        if (uRL == null) {
            throw new IllegalArgumentException("Resource not found: " + resourcePath);
        }
        URL url2 = uRL;
        return SvgsupportKt.svgImage(url2, width);
    }

    @NotNull
    public static final Image svgImage(@NotNull URL url2, double width) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        SVGDocument sVGDocument = svgLoader.load(url2);
        if (sVGDocument == null) {
            throw new IllegalArgumentException("Failed to load SVG from: " + url2);
        }
        SVGDocument document = sVGDocument;
        return SvgsupportKt.renderToImage(document, width);
    }

    private static final Image renderToImage(SVGDocument document) {
        FloatSize floatSize = document.size();
        Intrinsics.checkNotNullExpressionValue((Object)floatSize, (String)"size(...)");
        FloatSize size = floatSize;
        int width = RangesKt.coerceAtLeast((int)((int)size.width), (int)1);
        int height = RangesKt.coerceAtLeast((int)((int)size.height), (int)1);
        return SvgsupportKt.renderToImage(document, width, height);
    }

    private static final Image renderToImage(SVGDocument document, double targetWidth) {
        FloatSize floatSize = document.size();
        Intrinsics.checkNotNullExpressionValue((Object)floatSize, (String)"size(...)");
        FloatSize size = floatSize;
        float aspectRatio = size.height / size.width;
        int width = RangesKt.coerceAtLeast((int)((int)targetWidth), (int)1);
        int height = RangesKt.coerceAtLeast((int)((int)(targetWidth * (double)aspectRatio)), (int)1);
        return SvgsupportKt.renderToImage(document, width, height);
    }

    private static final Image renderToImage(SVGDocument document, int width, int height) {
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        document.render(null, g2d, new ViewBox(0.0f, 0.0f, (float)width, (float)height));
        g2d.dispose();
        WritableImage writableImage = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
        Intrinsics.checkNotNullExpressionValue((Object)writableImage, (String)"toFXImage(...)");
        return (Image)writableImage;
    }
}

