/*
 * Decompiled with CFR 0.152.
 */
import javafx.beans.value.ObservableValue;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Region;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0014J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0014J\b\u0010\u0012\u001a\u00020\fH\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u000eH\u0002R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"LResizableImageView;", "Ljavafx/scene/layout/Region;", "image", "Ljavafx/scene/image/Image;", "<init>", "(Ljavafx/scene/image/Image;)V", "getImage", "()Ljavafx/scene/image/Image;", "setImage", "canvas", "Ljavafx/scene/canvas/Canvas;", "layoutChildren", "", "computePrefWidth", "", "height", "computePrefHeight", "width", "redraw", "interpolateArgb", "", "a", "b", "t", "laboftrades-app-base"})
public final class ResizableImageView
extends Region {
    @Nullable
    private Image image;
    @NotNull
    private final Canvas canvas;

    public ResizableImageView(@Nullable Image image) {
        this.image = image;
        this.canvas = new Canvas();
        this.getChildren().add((Object)this.canvas);
        this.widthProperty().addListener((arg_0, arg_1, arg_2) -> ResizableImageView._init_$lambda$1((arg_0, arg_1, arg_2) -> ResizableImageView._init_$lambda$0(this, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        this.heightProperty().addListener((arg_0, arg_1, arg_2) -> ResizableImageView._init_$lambda$3((arg_0, arg_1, arg_2) -> ResizableImageView._init_$lambda$2(this, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
    }

    @Nullable
    public final Image getImage() {
        return this.image;
    }

    public final void setImage(@Nullable Image image) {
        this.image = image;
    }

    protected void layoutChildren() {
        super.layoutChildren();
        this.canvas.setWidth(this.getWidth());
        this.canvas.setHeight(this.getHeight());
        this.redraw();
    }

    protected double computePrefWidth(double height) {
        Image image = this.image;
        return image != null ? image.getWidth() : 0.0;
    }

    protected double computePrefHeight(double width) {
        double d;
        Image img = this.image;
        if (img != null && width > 0.0) {
            d = width * img.getHeight() / img.getWidth();
        } else {
            Image image = img;
            d = image != null ? image.getHeight() : 0.0;
        }
        return d;
    }

    private final void redraw() {
        Image image = this.image;
        if (image == null) {
            return;
        }
        Image img = image;
        double w = this.canvas.getWidth();
        double h = this.canvas.getHeight();
        if (w <= 0.0 || h <= 0.0) {
            return;
        }
        GraphicsContext gc = this.canvas.getGraphicsContext2D();
        gc.clearRect(0.0, 0.0, w, h);
        PixelReader pixelReader = img.getPixelReader();
        if (pixelReader == null) {
            return;
        }
        PixelReader pr = pixelReader;
        WritableImage out = new WritableImage((int)w, (int)h);
        PixelWriter pixelWriter = out.getPixelWriter();
        Intrinsics.checkNotNullExpressionValue((Object)pixelWriter, (String)"getPixelWriter(...)");
        PixelWriter pw = pixelWriter;
        double srcW = img.getWidth();
        double srcH = img.getHeight();
        int n = (int)h;
        for (int y = 0; y < n; ++y) {
            double v = (double)y * (srcH - 1.0) / (h - 1.0);
            int y0 = (int)v;
            int y1 = RangesKt.coerceAtMost((int)(y0 + 1), (int)((int)srcH - 1));
            double fy = v - (double)y0;
            int n2 = (int)w;
            for (int x = 0; x < n2; ++x) {
                double u = (double)x * (srcW - 1.0) / (w - 1.0);
                int x0 = (int)u;
                int x1 = RangesKt.coerceAtMost((int)(x0 + 1), (int)((int)srcW - 1));
                double fx2 = u - (double)x0;
                int c00 = pr.getArgb(x0, y0);
                int c10 = pr.getArgb(x1, y0);
                int c01 = pr.getArgb(x0, y1);
                int c11 = pr.getArgb(x1, y1);
                int c0 = this.interpolateArgb(c00, c10, fx2);
                int c1 = this.interpolateArgb(c01, c11, fx2);
                int c = this.interpolateArgb(c0, c1, fy);
                pw.setArgb(x, y, c);
            }
        }
        double imgRatio = srcW / srcH;
        double containerRatio = w / h;
        double drawW = 0.0;
        double drawH = 0.0;
        if (containerRatio > imgRatio) {
            drawH = h;
            drawW = h * imgRatio;
        } else {
            drawW = w;
            drawH = w / imgRatio;
        }
        double dx = (w - drawW) / 2.0;
        double dy = (h - drawH) / 2.0;
        gc.drawImage((Image)out, dx, dy, drawW, drawH);
    }

    private final int interpolateArgb(int a, int b, double t) {
        int aA = a >> 24 & 0xFF;
        int aR = a >> 16 & 0xFF;
        int aG = a >> 8 & 0xFF;
        int aB = a & 0xFF;
        int bA = b >> 24 & 0xFF;
        int bR = b >> 16 & 0xFF;
        int bG = b >> 8 & 0xFF;
        int bB = b & 0xFF;
        int A = RangesKt.coerceIn((int)((int)((double)aA + (double)(bA - aA) * t)), (int)0, (int)255);
        int R = RangesKt.coerceIn((int)((int)((double)aR + (double)(bR - aR) * t)), (int)0, (int)255);
        int G = RangesKt.coerceIn((int)((int)((double)aG + (double)(bG - aG) * t)), (int)0, (int)255);
        int B = RangesKt.coerceIn((int)((int)((double)aB + (double)(bB - aB) * t)), (int)0, (int)255);
        return A << 24 | R << 16 | G << 8 | B;
    }

    private static final Unit _init_$lambda$0(ResizableImageView this$0, ObservableValue observableValue, Number number, Number number2) {
        this$0.requestLayout();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final Unit _init_$lambda$2(ResizableImageView this$0, ObservableValue observableValue, Number number, Number number2) {
        this$0.requestLayout();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$3(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }
}

