/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.view.optionviewer;

import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Contract;
import com.xorrus.trading.common.contract.Option;
import com.xorrus.trading.common.contract.Position;
import com.xorrus.trading.lot.app.view.optionviewer.PositionPaneKt;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/xorrus/trading/lot/app/view/optionviewer/PositionTableRow;", "", "<init>", "()V", "GroupHeader", "DataRow", "Lcom/xorrus/trading/lot/app/view/optionviewer/PositionTableRow$DataRow;", "Lcom/xorrus/trading/lot/app/view/optionviewer/PositionTableRow$GroupHeader;", "laboftrades-app"})
public abstract sealed class PositionTableRow {
    private PositionTableRow() {
    }

    public /* synthetic */ PositionTableRow(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020\u0005H\u00d6\u0001J\t\u0010(\u001a\u00020)H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0011\u0010\u001a\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0011\u0010\u001c\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u0011\u0010\u001e\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013\u00a8\u0006*"}, d2={"Lcom/xorrus/trading/lot/app/view/optionviewer/PositionTableRow$DataRow;", "Lcom/xorrus/trading/lot/app/view/optionviewer/PositionTableRow;", "position", "Lcom/xorrus/trading/common/contract/Position;", "indexInGroup", "", "<init>", "(Lcom/xorrus/trading/common/contract/Position;I)V", "getPosition", "()Lcom/xorrus/trading/common/contract/Position;", "getIndexInGroup", "()I", "selectedProperty", "Ljavafx/beans/property/SimpleBooleanProperty;", "getSelectedProperty", "()Ljavafx/beans/property/SimpleBooleanProperty;", "assetType", "Ljavafx/beans/property/SimpleStringProperty;", "getAssetType", "()Ljavafx/beans/property/SimpleStringProperty;", "symbol", "getSymbol", "quantity", "getQuantity", "strike", "getStrike", "right", "getRight", "expiration", "getExpiration", "avgPrice", "getAvgPrice", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "laboftrades-app"})
    public static final class DataRow
    extends PositionTableRow {
        @NotNull
        private final Position position;
        private final int indexInGroup;
        @NotNull
        private final SimpleBooleanProperty selectedProperty;
        @NotNull
        private final SimpleStringProperty assetType;
        @NotNull
        private final SimpleStringProperty symbol;
        @NotNull
        private final SimpleStringProperty quantity;
        @NotNull
        private final SimpleStringProperty strike;
        @NotNull
        private final SimpleStringProperty right;
        @NotNull
        private final SimpleStringProperty expiration;
        @NotNull
        private final SimpleStringProperty avgPrice;

        public DataRow(@NotNull Position position, int indexInGroup) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            super(null);
            this.position = position;
            this.indexInGroup = indexInGroup;
            this.selectedProperty = new SimpleBooleanProperty(false);
            this.assetType = new SimpleStringProperty(PositionPaneKt.access$getAssetType(this.position.getContract()));
            this.symbol = new SimpleStringProperty(PositionPaneKt.access$getHumanSymbol(this.position.getContract()));
            this.quantity = new SimpleStringProperty((String)(this.position.getSize().compareTo(XBigNum.Companion.getZERO()) > 0 ? "+" + this.position.getSize() : this.position.getSize().toString()));
            Contract contract = this.position.getContract();
            Object object = contract instanceof Option ? (Option)contract : null;
            if (object == null || (object = object.getStrike()) == null || (object = object.toString()) == null) {
                object = "";
            }
            this.strike = new SimpleStringProperty((String)object);
            contract = this.position.getContract();
            Object object2 = contract instanceof Option ? (Option)contract : null;
            if (object2 == null || (object2 = object2.getRight()) == null || (object2 = object2.toString()) == null) {
                object2 = "";
            }
            this.right = new SimpleStringProperty((String)object2);
            contract = this.position.getContract();
            Object object3 = contract instanceof Option ? (Option)contract : null;
            if (object3 == null || (object3 = object3.getExpiration()) == null || (object3 = object3.toString()) == null) {
                object3 = "";
            }
            this.expiration = new SimpleStringProperty((String)object3);
            this.avgPrice = new SimpleStringProperty(this.position.getAveragePrice().toMinScale().toString());
        }

        @NotNull
        public final Position getPosition() {
            return this.position;
        }

        public final int getIndexInGroup() {
            return this.indexInGroup;
        }

        @NotNull
        public final SimpleBooleanProperty getSelectedProperty() {
            return this.selectedProperty;
        }

        @NotNull
        public final SimpleStringProperty getAssetType() {
            return this.assetType;
        }

        @NotNull
        public final SimpleStringProperty getSymbol() {
            return this.symbol;
        }

        @NotNull
        public final SimpleStringProperty getQuantity() {
            return this.quantity;
        }

        @NotNull
        public final SimpleStringProperty getStrike() {
            return this.strike;
        }

        @NotNull
        public final SimpleStringProperty getRight() {
            return this.right;
        }

        @NotNull
        public final SimpleStringProperty getExpiration() {
            return this.expiration;
        }

        @NotNull
        public final SimpleStringProperty getAvgPrice() {
            return this.avgPrice;
        }

        @NotNull
        public final Position component1() {
            return this.position;
        }

        public final int component2() {
            return this.indexInGroup;
        }

        @NotNull
        public final DataRow copy(@NotNull Position position, int indexInGroup) {
            Intrinsics.checkNotNullParameter((Object)position, (String)"position");
            return new DataRow(position, indexInGroup);
        }

        public static /* synthetic */ DataRow copy$default(DataRow dataRow, Position position, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                position = dataRow.position;
            }
            if ((n2 & 2) != 0) {
                n = dataRow.indexInGroup;
            }
            return dataRow.copy(position, n);
        }

        @NotNull
        public String toString() {
            return "DataRow(position=" + this.position + ", indexInGroup=" + this.indexInGroup + ")";
        }

        public int hashCode() {
            int result = this.position.hashCode();
            result = result * 31 + Integer.hashCode(this.indexInGroup);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DataRow)) {
                return false;
            }
            DataRow dataRow = (DataRow)other;
            if (!Intrinsics.areEqual((Object)this.position, (Object)dataRow.position)) {
                return false;
            }
            return this.indexInGroup == dataRow.indexInGroup;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/xorrus/trading/lot/app/view/optionviewer/PositionTableRow$GroupHeader;", "Lcom/xorrus/trading/lot/app/view/optionviewer/PositionTableRow;", "label", "", "<init>", "(Ljava/lang/String;)V", "getLabel", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "laboftrades-app"})
    public static final class GroupHeader
    extends PositionTableRow {
        @NotNull
        private final String label;

        public GroupHeader(@NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            super(null);
            this.label = label;
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @NotNull
        public final String component1() {
            return this.label;
        }

        @NotNull
        public final GroupHeader copy(@NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            return new GroupHeader(label);
        }

        public static /* synthetic */ GroupHeader copy$default(GroupHeader groupHeader, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = groupHeader.label;
            }
            return groupHeader.copy(string);
        }

        @NotNull
        public String toString() {
            return "GroupHeader(label=" + this.label + ")";
        }

        public int hashCode() {
            return this.label.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GroupHeader)) {
                return false;
            }
            GroupHeader groupHeader = (GroupHeader)other;
            return Intrinsics.areEqual((Object)this.label, (Object)groupHeader.label);
        }
    }
}

