/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.utils.optionstrat;

import com.xorrus.trading.common.DateKt;
import com.xorrus.trading.common.XbignumKt;
import com.xorrus.trading.common.bignum.XBigNum;
import com.xorrus.trading.common.contract.Combo;
import com.xorrus.trading.common.contract.Contract;
import com.xorrus.trading.common.contract.Future;
import com.xorrus.trading.common.contract.Index;
import com.xorrus.trading.common.contract.Option;
import com.xorrus.trading.common.contract.Stock;
import com.xorrus.trading.lot.app.utils.optionstrat.Leg;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.datetime.LocalDate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\f\u0010\u0010\u001a\u00020\u000f*\u00020\nH\u0002J\f\u0010\u0011\u001a\u00020\u000f*\u00020\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\bR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/xorrus/trading/lot/app/utils/optionstrat/OptionStratUrlBuilder;", "", "<init>", "()V", "legs", "", "Lcom/xorrus/trading/lot/app/utils/optionstrat/Leg;", "addLeg", "", "contract", "Lcom/xorrus/trading/common/contract/Contract;", "size", "Lcom/xorrus/trading/common/bignum/XBigNum;", "price", "buildUrl", "", "toOptionStratTicker", "urlEncoded", "check", "", "canBuild", "laboftrades-app"})
@SourceDebugExtension(value={"SMAP\nOptionStratUrlBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptionStratUrlBuilder.kt\ncom/xorrus/trading/lot/app/utils/optionstrat/OptionStratUrlBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,94:1\n1617#2,9:95\n1869#2:104\n1870#2:106\n1626#2:107\n774#2:108\n865#2,2:109\n1#3:105\n1#3:111\n*S KotlinDebug\n*F\n+ 1 OptionStratUrlBuilder.kt\ncom/xorrus/trading/lot/app/utils/optionstrat/OptionStratUrlBuilder\n*L\n18#1:95,9\n18#1:104\n18#1:106\n18#1:107\n29#1:108\n29#1:109,2\n18#1:105\n*E\n"})
public final class OptionStratUrlBuilder {
    @NotNull
    private final List<Leg> legs = new ArrayList();

    public final boolean addLeg(@NotNull Contract contract, @NotNull XBigNum size, @Nullable XBigNum price) {
        Intrinsics.checkNotNullParameter((Object)contract, (String)"contract");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        return this.legs.add(new Leg(contract, size, price));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String buildUrl() {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        StringBuilder stringBuilder;
        void $this$mapNotNullTo$iv$iv;
        this.check();
        Iterable $this$mapNotNull$iv = this.legs;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo22 = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Leg it = (Leg)element$iv$iv;
            boolean bl2 = false;
            Contract contract = it.getContract();
            if ((contract instanceof Option ? this.toOptionStratTicker((Contract)((Option)it.getContract()).getUnderlying()) : (contract instanceof Stock ? this.toOptionStratTicker(it.getContract()) : null)) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        String baseSymbol = (String)CollectionsKt.single((List)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)));
        StringBuilder $this$buildUrl_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildUrl_u24lambda_u241.append("https://optionstrat.com/build/custom/" + this.urlEncoded(baseSymbol) + "/");
        Iterable $i$f$mapNotNullTo22 = this.legs;
        StringBuilder stringBuilder2 = $this$buildUrl_u24lambda_u241;
        boolean $i$f$filter = false;
        iterator = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Leg it = (Leg)element$iv$iv;
            boolean bl4 = false;
            Contract contract = it.getContract();
            boolean bl5 = contract instanceof Index ? true : (contract instanceof Option ? true : (contract instanceof Stock ? true : contract instanceof Future));
            if (!bl5) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)",", null, null, (int)0, null, arg_0 -> OptionStratUrlBuilder.buildUrl$lambda$1$1(this, arg_0), (int)30, null));
        String s = stringBuilder.toString();
        return s;
    }

    private final String toOptionStratTicker(Contract $this$toOptionStratTicker) {
        Object object;
        Contract contract = $this$toOptionStratTicker;
        if (contract instanceof Option) {
            if (((Option)$this$toOptionStratTicker).getUnderlying() instanceof Future) {
                object = this.toOptionStratTicker((Contract)((Option)$this$toOptionStratTicker).getUnderlying());
            } else {
                object = ((Option)$this$toOptionStratTicker).getTradingClass();
                if (object == null) {
                    object = ((Option)$this$toOptionStratTicker).getUnderlying().getTickerSymbol();
                }
            }
        } else if (contract instanceof Stock) {
            object = ((Stock)$this$toOptionStratTicker).getTickerSymbol();
        } else if (contract instanceof Index) {
            object = ((Index)$this$toOptionStratTicker).getTickerSymbol();
        } else if (contract instanceof Future) {
            object = "/" + ((Future)$this$toOptionStratTicker).getFamily().getRootSymbol() + ((Future)$this$toOptionStratTicker).getMonthCode() + ((Future)$this$toOptionStratTicker).getYear() % 100;
        } else {
            throw new IllegalStateException("not supported".toString());
        }
        return object;
    }

    private final String urlEncoded(String $this$urlEncoded) {
        String string = URLEncoder.encode($this$urlEncoded, Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
        return string;
    }

    private final void check() {
    }

    public final boolean canBuild() {
        Object object;
        OptionStratUrlBuilder optionStratUrlBuilder = this;
        try {
            OptionStratUrlBuilder $this$canBuild_u24lambda_u240 = optionStratUrlBuilder;
            boolean bl = false;
            $this$canBuild_u24lambda_u240.check();
            object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        return Result.isSuccess-impl((Object)object);
    }

    private static final CharSequence buildUrl$lambda$1$1(OptionStratUrlBuilder this$0, Leg leg) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)leg, (String)"leg");
        StringBuilder $this$buildUrl_u24lambda_u241_u241_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$buildUrl_u24lambda_u241_u241_u240.append(Intrinsics.areEqual((Object)leg.getSize(), (Object)XbignumKt.toXBigNum((String)"-1")) ? "-" : "");
        $this$buildUrl_u24lambda_u241_u241_u240.append(".");
        Contract contract = leg.getContract();
        if (contract instanceof Index) {
            v0 = $this$buildUrl_u24lambda_u241_u241_u240.append(this$0.urlEncoded(this$0.toOptionStratTicker(leg.getContract())));
        } else if (contract instanceof Option) {
            $this$buildUrl_u24lambda_u241_u241_u240.append(this$0.urlEncoded(this$0.toOptionStratTicker(leg.getContract())));
            if (!(((Option)leg.getContract()).getUnderlying() instanceof Future)) {
                $this$buildUrl_u24lambda_u241_u241_u240.append(DateKt.toString$default((LocalDate)((Option)leg.getContract()).getExpiration(), (String)"yyMMdd", null, (int)2, null));
            }
            $this$buildUrl_u24lambda_u241_u241_u240.append(StringsKt.first((CharSequence)((Option)leg.getContract()).getRight().name()));
            v0 = $this$buildUrl_u24lambda_u241_u241_u240.append(((Option)leg.getContract()).getStrike().toMinScale());
        } else if (contract instanceof Stock) {
            v0 = $this$buildUrl_u24lambda_u241_u241_u240.append(this$0.urlEncoded(this$0.toOptionStratTicker(leg.getContract())));
        } else if (contract instanceof Future) {
            v0 = $this$buildUrl_u24lambda_u241_u241_u240.append(this$0.urlEncoded(this$0.toOptionStratTicker(leg.getContract())));
        } else {
            if (contract instanceof Combo) {
                throw new IllegalStateException("not supported".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        $this$buildUrl_u24lambda_u241_u241_u240.append((String)(!Intrinsics.areEqual((Object)leg.getSize().abs(), (Object)XBigNum.Companion.getONE()) ? "x" + leg.getSize().toMinScale() : ""));
        $this$buildUrl_u24lambda_u241_u241_u240.append((String)(leg.getPrice() != null ? "@" + leg.getPrice().toMinScale() : ""));
        return stringBuilder.toString();
    }
}

