/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.lifecycle;

import com.xorrus.trading.lot.app.config.Configuration;
import com.xorrus.trading.lot.app.license.LicenseManager;
import com.xorrus.trading.lot.app.utils.Sentry;
import com.xorrus.trading.lot.app.utils.SystemKt;
import com.xorrus.trading.lot.app.view.MainPaneKt;
import com.xorrus.trading.lot.app.view.common.LicenseDialogKt;
import com.xorrus.trading.lot.business.backup.BackupManager;
import com.xorrus.trading.lot.business.backup.BackupResult;
import java.nio.file.Path;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.stage.Stage;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B?\u00126\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0012\u001a\u00020\nJ\u000e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015RA\u0010\u0002\u001a2\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\t\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/xorrus/trading/lot/app/lifecycle/AppInitializer;", "", "notification", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "progress", "", "text", "", "<init>", "(Lkotlin/jvm/functions/Function2;)V", "getNotification", "()Lkotlin/jvm/functions/Function2;", "licenseKey", "", "licenseAgreementAccepted", "runStep1UIless", "runStep2WithUI", "primaryStage", "Ljavafx/stage/Stage;", "Companion", "laboftrades-app"})
public final class AppInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function2<Double, String, Unit> notification;
    private boolean licenseKey;
    private boolean licenseAgreementAccepted;
    @NotNull
    private static final Logger logger;

    public AppInitializer(@NotNull Function2<? super Double, ? super String, Unit> notification) {
        Intrinsics.checkNotNullParameter(notification, (String)"notification");
        this.notification = notification;
    }

    @NotNull
    public final Function2<Double, String, Unit> getNotification() {
        return this.notification;
    }

    public final void runStep1UIless() {
        logger.info("Lab of Trades " + Configuration.INSTANCE.getVersion() + " wird gestartet.");
        if (Configuration.INSTANCE.getSentryEnabledProperty().getValue().booleanValue()) {
            this.notification.invoke((Object)0.0, (Object)"Diagnostik initialisieren.");
            Sentry.INSTANCE.sentryInit();
            logger.info("Sentry initialisiert.");
        }
        this.notification.invoke((Object)0.1, (Object)"OS spezifische Konfiguration initialisieren.");
        SystemKt.configureSystemSpecific();
        logger.info("System spezifische Konfiguration initialisiert.");
        this.notification.invoke((Object)0.2, (Object)"Lizenzmanager initialisieren.");
        LicenseManager.INSTANCE.getLicenseKeyProperty().bind((ObservableValue)Configuration.INSTANCE.getLicenseKeyProperty());
        this.licenseKey = LicenseManager.INSTANCE.getLicenseKeyProperty().getValue() != null;
        this.licenseAgreementAccepted = Configuration.INSTANCE.getLicenseAcceptedProperty().getValue() != null;
        logger.info("Lizenzmanager initialisiert.");
        this.notification.invoke((Object)0.3, (Object)"Erstelle Backup von Datenbank.");
        BackupResult backupResult = BackupManager.createBackup$default((BackupManager)BackupManager.INSTANCE, (Path)Configuration.INSTANCE.getDatabaseDir(), (Path)Configuration.INSTANCE.getBackupDir(), (int)0, (int)4, null);
        if (!(backupResult instanceof BackupResult.Success)) {
            logger.warn("Fehler beim Erstellen eines Datenbankbackups {}", (Object)backupResult);
        } else {
            logger.info("Backup erfolgreich durchgef\u00fchrt.");
        }
        this.notification.invoke((Object)0.4, (Object)"Initialisiere Datenbank.");
        if (Configuration.INSTANCE.getTwsAutoConnectProperty().getValue().booleanValue()) {
            this.notification.invoke((Object)0.5, (Object)"TWS-Verbindung initialisieren.");
            logger.info("TWS Verbindung initialisiert.");
        }
    }

    public final void runStep2WithUI(@NotNull Stage primaryStage) {
        Intrinsics.checkNotNullParameter((Object)primaryStage, (String)"primaryStage");
        Platform.runLater(() -> AppInitializer.runStep2WithUI$lambda$0(primaryStage));
    }

    private static final void runStep2WithUI$lambda$0(Stage $primaryStage) {
        if (Configuration.INSTANCE.getLicenseAcceptedProperty().getValue() == null) {
            LicenseDialogKt.showAndWaitLicenseDialog(new Stage());
            if (Configuration.INSTANCE.getLicenseAcceptedProperty().getValue() == null) {
                return;
            }
        }
        MainPaneKt.showMainPane($primaryStage);
    }

    static {
        Logger logger = LoggerFactory.getLogger(AppInitializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        AppInitializer.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/xorrus/trading/lot/app/lifecycle/AppInitializer$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "laboftrades-app"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

