/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.plot.renderer;

import com.xorrus.trading.lot.app.plot.ChartTheme;
import com.xorrus.trading.lot.app.plot.PnLDiagramState;
import com.xorrus.trading.lot.app.plot.layout.DiagramLayout;
import com.xorrus.trading.lot.app.plot.layout.YAxisLayout;
import com.xorrus.trading.lot.app.plot.renderer.PnLRenderer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMetrics;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/xorrus/trading/lot/app/plot/renderer/YAxisRenderer;", "Lcom/xorrus/trading/lot/app/plot/renderer/PnLRenderer;", "<init>", "()V", "render", "", "canvas", "Lorg/jetbrains/skia/Canvas;", "Lcom/xorrus/trading/lot/app/plot/SkiaCanvas;", "state", "Lcom/xorrus/trading/lot/app/plot/PnLDiagramState;", "laboftrades-app"})
@SourceDebugExtension(value={"SMAP\nYAxisRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAxisRenderer.kt\ncom/xorrus/trading/lot/app/plot/renderer/YAxisRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,53:1\n1869#2,2:54\n*S KotlinDebug\n*F\n+ 1 YAxisRenderer.kt\ncom/xorrus/trading/lot/app/plot/renderer/YAxisRenderer\n*L\n38#1:54,2\n*E\n"})
public final class YAxisRenderer
implements PnLRenderer {
    @Override
    public void render(@NotNull Canvas canvas, @NotNull PnLDiagramState state) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ChartTheme theme = state.getTheme();
        DiagramLayout layout = state.getLayout();
        YAxisLayout yLayout = layout.getYAxis();
        float axisX = layout.getOriginX();
        float axisTop = 0.0f;
        float axisBottom = layout.getOriginY();
        canvas.drawLine(axisX, axisTop, axisX, axisBottom, theme.getAxisPaint());
        Font font = theme.getAxisLabelFont();
        FontMetrics metrics = font.getMetrics();
        float plotHeight = axisBottom - axisTop;
        float tickLength = theme.getTickLength();
        ClosedRange<Double> yRange = state.getYRange();
        Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)yLayout.getTicks(), (Iterable)yLayout.getLabels());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            double value = ((Number)pair.component1()).doubleValue();
            String label = (String)pair.component2();
            float y = YAxisRenderer.render$mapValueToY(yRange, axisBottom, plotHeight, value);
            canvas.drawLine(axisX - tickLength, y, axisX, y, theme.getAxisPaint());
            float textWidth = font.measureText(label, theme.getAxisLabelPaint()).getWidth();
            float labelX = axisX - tickLength - theme.getAxisLabelPadding() - textWidth;
            float baselineY = y - (metrics.getAscent() + metrics.getDescent()) / 2.0f;
            canvas.drawString(label, labelX, baselineY, font, theme.getAxisLabelPaint());
        }
    }

    private static final float render$mapValueToY(ClosedRange<Double> yRange, float axisBottom, float plotHeight, double value) {
        float ratio = (float)((value - ((Number)((Object)yRange.getStart())).doubleValue()) / (((Number)((Object)yRange.getEndInclusive())).doubleValue() - ((Number)((Object)yRange.getStart())).doubleValue()));
        return axisBottom - ratio * plotHeight;
    }
}

