/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.plot;

import com.xorrus.trading.lot.app.plot.ChartTheme;
import com.xorrus.trading.lot.app.plot.CursorInfo;
import com.xorrus.trading.lot.app.plot.CursorPixels;
import com.xorrus.trading.lot.app.plot.PnLCalculator;
import com.xorrus.trading.lot.app.plot.PnLDiagramData;
import com.xorrus.trading.lot.app.plot.layout.DiagramLayout;
import com.xorrus.trading.lot.app.plot.layout.DiagramLayoutCalculator;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0016\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001aR\u001b\u0010\u001d\u001a\u00020\u001e8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b\u001f\u0010 R\u001d\u0010#\u001a\u0004\u0018\u00010$8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\"\u001a\u0004\b%\u0010&\u00a8\u0006+"}, d2={"Lcom/xorrus/trading/lot/app/plot/PnLDiagramState;", "", "data", "Lcom/xorrus/trading/lot/app/plot/PnLDiagramData;", "initialXRange", "Lkotlin/ranges/ClosedRange;", "", "initialYRange", "theme", "Lcom/xorrus/trading/lot/app/plot/ChartTheme;", "width", "", "height", "cursorPixels", "Lcom/xorrus/trading/lot/app/plot/CursorPixels;", "<init>", "(Lcom/xorrus/trading/lot/app/plot/PnLDiagramData;Lkotlin/ranges/ClosedRange;Lkotlin/ranges/ClosedRange;Lcom/xorrus/trading/lot/app/plot/ChartTheme;FFLcom/xorrus/trading/lot/app/plot/CursorPixels;)V", "getData", "()Lcom/xorrus/trading/lot/app/plot/PnLDiagramData;", "getTheme", "()Lcom/xorrus/trading/lot/app/plot/ChartTheme;", "getWidth", "()F", "getHeight", "xRange", "getXRange", "()Lkotlin/ranges/ClosedRange;", "yRange", "getYRange", "layout", "Lcom/xorrus/trading/lot/app/plot/layout/DiagramLayout;", "getLayout", "()Lcom/xorrus/trading/lot/app/plot/layout/DiagramLayout;", "layout$delegate", "Lkotlin/Lazy;", "cursor", "Lcom/xorrus/trading/lot/app/plot/CursorInfo;", "getCursor", "()Lcom/xorrus/trading/lot/app/plot/CursorInfo;", "cursor$delegate", "copyWithSize", "newWidth", "newHeight", "laboftrades-app"})
public final class PnLDiagramState {
    @NotNull
    private final PnLDiagramData data;
    @NotNull
    private final ChartTheme theme;
    private final float width;
    private final float height;
    @Nullable
    private final CursorPixels cursorPixels;
    @NotNull
    private final ClosedRange<Double> xRange;
    @NotNull
    private final ClosedRange<Double> yRange;
    @NotNull
    private final Lazy layout$delegate;
    @NotNull
    private final Lazy cursor$delegate;

    public PnLDiagramState(@NotNull PnLDiagramData data, @Nullable ClosedRange<Double> initialXRange, @Nullable ClosedRange<Double> initialYRange, @NotNull ChartTheme theme, float width, float height, @Nullable CursorPixels cursorPixels) {
        ClosedRange<Double> closedRange;
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        this.data = data;
        this.theme = theme;
        this.width = width;
        this.height = height;
        this.cursorPixels = cursorPixels;
        ClosedRange<Double> closedRange2 = initialXRange;
        if (closedRange2 == null) {
            closedRange2 = this.xRange = PnLCalculator.INSTANCE.computeAutoXRange(this.data);
        }
        if ((closedRange = initialYRange) == null) {
            closedRange = PnLCalculator.INSTANCE.estimatePnLRange(this.data, this.xRange);
        }
        this.yRange = closedRange;
        this.layout$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> PnLDiagramState.layout_delegate$lambda$0(this));
        this.cursor$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> PnLDiagramState.cursor_delegate$lambda$0(this));
    }

    public /* synthetic */ PnLDiagramState(PnLDiagramData pnLDiagramData, ClosedRange closedRange, ClosedRange closedRange2, ChartTheme chartTheme, float f, float f2, CursorPixels cursorPixels, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            closedRange = null;
        }
        if ((n & 4) != 0) {
            closedRange2 = null;
        }
        if ((n & 0x40) != 0) {
            cursorPixels = null;
        }
        this(pnLDiagramData, (ClosedRange<Double>)closedRange, (ClosedRange<Double>)closedRange2, chartTheme, f, f2, cursorPixels);
    }

    @NotNull
    public final PnLDiagramData getData() {
        return this.data;
    }

    @NotNull
    public final ChartTheme getTheme() {
        return this.theme;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    @NotNull
    public final ClosedRange<Double> getXRange() {
        return this.xRange;
    }

    @NotNull
    public final ClosedRange<Double> getYRange() {
        return this.yRange;
    }

    @NotNull
    public final DiagramLayout getLayout() {
        Lazy lazy = this.layout$delegate;
        return (DiagramLayout)lazy.getValue();
    }

    @Nullable
    public final CursorInfo getCursor() {
        Lazy lazy = this.cursor$delegate;
        return (CursorInfo)lazy.getValue();
    }

    @NotNull
    public final PnLDiagramState copyWithSize(float newWidth, float newHeight) {
        return new PnLDiagramState(this.data, this.xRange, this.yRange, this.theme, newWidth, newHeight, this.cursorPixels);
    }

    private static final DiagramLayout layout_delegate$lambda$0(PnLDiagramState this$0) {
        return DiagramLayoutCalculator.INSTANCE.computeFullLayout(this$0.xRange, this$0.yRange, this$0.data.getCurrency(), this$0.height, this$0.width, this$0.theme);
    }

    private static final CursorInfo cursor_delegate$lambda$0(PnLDiagramState this$0) {
        float y;
        float x;
        float plotBottom;
        float plotTop;
        float plotRight;
        float plotLeft;
        block6: {
            block5: {
                CursorPixels cursorPixels = this$0.cursorPixels;
                if (cursorPixels == null) {
                    return null;
                }
                CursorPixels cursor = cursorPixels;
                DiagramLayout diagramLayout = this$0.getLayout();
                plotLeft = diagramLayout.getOriginX();
                plotRight = this$0.width;
                plotTop = 0.0f;
                plotBottom = diagramLayout.getOriginY();
                x = (float)cursor.getX();
                y = (float)cursor.getY();
                boolean bl = plotLeft <= x ? x <= plotRight : false;
                if (!bl) break block5;
                if (plotTop <= y ? y <= plotBottom : false) break block6;
            }
            return null;
        }
        float plotWidth = plotRight - plotLeft;
        float plotHeight = plotBottom - plotTop;
        if (plotWidth <= 0.0f || plotHeight <= 0.0f) {
            return null;
        }
        double xRatio = (x - plotLeft) / plotWidth;
        double yRatio = (plotBottom - y) / plotHeight;
        double dataX = ((Number)((Object)this$0.xRange.getStart())).doubleValue() + xRatio * (((Number)((Object)this$0.xRange.getEndInclusive())).doubleValue() - ((Number)((Object)this$0.xRange.getStart())).doubleValue());
        double dataY = ((Number)((Object)this$0.yRange.getStart())).doubleValue() + yRatio * (((Number)((Object)this$0.yRange.getEndInclusive())).doubleValue() - ((Number)((Object)this$0.yRange.getStart())).doubleValue());
        return new CursorInfo(x, y, dataX, dataY);
    }
}

