/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.plot;

import com.xorrus.trading.lot.app.plot.PnLDiagramData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u001e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0006H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/xorrus/trading/lot/app/plot/PnLCalculator;", "", "<init>", "()V", "computeAutoXRange", "Lkotlin/ranges/ClosedRange;", "", "data", "Lcom/xorrus/trading/lot/app/plot/PnLDiagramData;", "estimatePnLRange", "xRange", "computePnLAtPrice", "underlyingPrice", "timeFraction", "computeTargetInstant", "Lkotlin/time/Instant;", "currentTime", "latestExpiration", "computePnLWithoutOptions", "laboftrades-app"})
public final class PnLCalculator {
    @NotNull
    public static final PnLCalculator INSTANCE = new PnLCalculator();

    private PnLCalculator() {
    }

    @NotNull
    public final ClosedRange<Double> computeAutoXRange(@NotNull PnLDiagramData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Double d = data.getUnderlyingPrice();
        if (d == null) {
            return (ClosedRange)RangesKt.rangeTo((double)0.0, (double)0.0);
        }
        double spot = d;
        double percentage = 0.05;
        return (ClosedRange)RangesKt.rangeTo((double)(spot * (1.0 - percentage)), (double)(spot * (1.0 + percentage)));
    }

    @NotNull
    public final ClosedRange<Double> estimatePnLRange(@NotNull PnLDiagramData data, @NotNull ClosedRange<Double> xRange) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter(xRange, (String)"xRange");
        return (ClosedRange)RangesKt.rangeTo((double)-2.7, (double)12.8);
    }

    public final double computePnLAtPrice(@NotNull PnLDiagramData data, double underlyingPrice, double timeFraction) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Instant firstExpiration = data.getFirstExpiration();
        if (firstExpiration == null) {
            return this.computePnLWithoutOptions(data, underlyingPrice);
        }
        Instant targetInstant = this.computeTargetInstant(data.getCurrentTime(), firstExpiration, timeFraction);
        return data.getExpectedPnL(targetInstant, underlyingPrice);
    }

    private final Instant computeTargetInstant(Instant currentTime, Instant latestExpiration, double timeFraction) {
        long totalDuration = latestExpiration.minus-UwyO8pc(currentTime);
        long targetDuration = Duration.times-UwyO8pc((long)totalDuration, (double)timeFraction);
        return currentTime.plus-LRDsOJo(targetDuration);
    }

    private final double computePnLWithoutOptions(PnLDiagramData data, double underlyingPrice) {
        double d;
        if (data.getUnderlyingQuantity() == 0.0) {
            d = 0.0;
        } else {
            Double d2 = data.getUnderlyingEntryPrice();
            Intrinsics.checkNotNull((Object)d2);
            d = (underlyingPrice - d2) * data.getUnderlyingQuantity();
        }
        return d;
    }
}

