/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.plot;

import java.util.Arrays;
import javafx.beans.value.ObservableValue;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Region;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.Color;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ColorType;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMgr;
import org.jetbrains.skia.FontStyle;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.Typeface;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH&J\u0018\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u0011H\u0016J\u0006\u0010!\u001a\u00020\u0019J \u0010\"\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J \u0010$\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u00060\u0014j\u0002`\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/xorrus/trading/lot/app/plot/SkiaNode;", "Ljavafx/scene/layout/Region;", "<init>", "()V", "canvas", "Ljavafx/scene/canvas/Canvas;", "cachedSurface", "Lorg/jetbrains/skia/Surface;", "cachedImage", "Ljavafx/scene/image/WritableImage;", "cachedWidth", "", "cachedHeight", "lastFpsSampleTimeNs", "", "frameCounter", "currentFps", "", "lastFrameTimeMs", "perfTextPaint", "Lorg/jetbrains/skia/Paint;", "Lcom/xorrus/trading/lot/app/plot/SkiaPaint;", "perfTextFont", "Lorg/jetbrains/skia/Font;", "draw", "", "Lorg/jetbrains/skia/Canvas;", "width", "", "height", "resize", "p0", "p1", "repaint", "getOrCreateImage", "surface", "drawPerfOverlay", "laboftrades-app"})
@SourceDebugExtension(value={"SMAP\nSkiaNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkiaNode.kt\ncom/xorrus/trading/lot/app/plot/SkiaNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,197:1\n1#2:198\n*E\n"})
public abstract class SkiaNode
extends Region {
    @NotNull
    private final Canvas canvas = new Canvas();
    @Nullable
    private Surface cachedSurface;
    @Nullable
    private WritableImage cachedImage;
    private int cachedWidth;
    private int cachedHeight;
    private long lastFpsSampleTimeNs = System.nanoTime();
    private int frameCounter;
    private double currentFps;
    private double lastFrameTimeMs;
    @NotNull
    private final Paint perfTextPaint;
    @NotNull
    private final Font perfTextFont;

    public SkiaNode() {
        SkiaNode $this$perfTextPaint_u24lambda_u240;
        Paint paint;
        Paint paint2 = paint = new Paint();
        SkiaNode skiaNode = this;
        boolean bl = false;
        $this$perfTextPaint_u24lambda_u240.setColor(Color.INSTANCE.makeRGB(255, 255, 255));
        skiaNode.perfTextPaint = paint;
        $this$perfTextPaint_u24lambda_u240 = this;
        skiaNode = this;
        boolean bl2 = false;
        Typeface typeface = FontMgr.Companion.getDefault().matchFamilyStyle("Helvetica Neue", FontStyle.Companion.getNORMAL());
        if (typeface == null && (typeface = FontMgr.Companion.getDefault().matchFamilyStyle("Arial", FontStyle.Companion.getNORMAL())) == null) {
            typeface = FontMgr.Companion.getDefault().matchFamilyStyle(null, FontStyle.Companion.getNORMAL());
        }
        Typeface typeface2 = typeface;
        skiaNode.perfTextFont = new Font(typeface2, 12.0f);
        this.canvas.widthProperty().bind((ObservableValue)this.widthProperty());
        this.canvas.heightProperty().bind((ObservableValue)this.heightProperty());
        this.getChildren().add((Object)this.canvas);
    }

    public abstract void draw(@NotNull org.jetbrains.skia.Canvas var1, float var2, float var3);

    public void resize(double p0, double p1) {
        super.resize(p0, p1);
        this.repaint();
    }

    public final void repaint() {
        Surface surface;
        Object it;
        if (this.getWidth() <= 0.0 || this.getHeight() <= 0.0) {
            return;
        }
        int w = (int)this.getWidth();
        int h = (int)this.getHeight();
        long startNs = System.nanoTime();
        if (this.cachedSurface == null || w != this.cachedWidth || h != this.cachedHeight) {
            Surface surface2 = this.cachedSurface;
            if (surface2 != null) {
                surface2.close();
            }
            ImageInfo imageInfo = new ImageInfo(w, h, ColorType.BGRA_8888, ColorAlphaType.UNPREMUL);
            Surface surface3 = Surface.Companion.makeRaster(imageInfo);
            it = surface3;
            boolean bl = false;
            this.cachedSurface = it;
            this.cachedWidth = w;
            this.cachedHeight = h;
            surface = surface3;
        } else {
            Surface surface4 = this.cachedSurface;
            surface = surface4;
            Intrinsics.checkNotNull((Object)surface4);
        }
        Surface surface5 = surface;
        org.jetbrains.skia.Canvas canvas = surface5.getCanvas();
        if (canvas == null) {
            it = "Required value was null.";
            throw new IllegalArgumentException(it.toString());
        }
        org.jetbrains.skia.Canvas skiaCanvas = canvas;
        skiaCanvas.clear(0);
        this.draw(skiaCanvas, w, h);
        this.drawPerfOverlay(skiaCanvas, w, h);
        WritableImage fxImage = this.getOrCreateImage(surface5, w, h);
        GraphicsContext graphicsContext = this.canvas.getGraphicsContext2D();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsContext, (String)"getGraphicsContext2D(...)");
        GraphicsContext gc = graphicsContext;
        gc.drawImage((Image)fxImage, 0.0, 0.0);
        long endNs = System.nanoTime();
        this.lastFrameTimeMs = (double)(endNs - startNs) / 1000000.0;
        int n = this.frameCounter;
        this.frameCounter = n + 1;
        long elapsedSinceSampleNs = endNs - this.lastFpsSampleTimeNs;
        if (elapsedSinceSampleNs >= 1000000000L) {
            this.currentFps = (double)this.frameCounter * 1.0E9 / (double)elapsedSinceSampleNs;
            this.frameCounter = 0;
            this.lastFpsSampleTimeNs = endNs;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final WritableImage getOrCreateImage(Surface surface, int width, int height) {
        if (this.cachedImage == null) ** GOTO lbl-1000
        v0 = this.cachedImage;
        Intrinsics.checkNotNull((Object)v0);
        if ((int)v0.getWidth() != width) ** GOTO lbl-1000
        v1 = this.cachedImage;
        Intrinsics.checkNotNull((Object)v1);
        if ((int)v1.getHeight() != height) lbl-1000:
        // 3 sources

        {
            it = var5_4 = new WritableImage(width, height);
            $i$a$-also-SkiaNode$getOrCreateImage$image$1 = false;
            this.cachedImage = it;
            v2 = var5_4;
        } else {
            v3 = this.cachedImage;
            v2 = v3;
            Intrinsics.checkNotNull((Object)v3);
        }
        image = v2;
        snapshot = surface.makeImageSnapshot();
        bitmap = Bitmap.Companion.makeFromImage(snapshot);
        v4 = Bitmap.readPixels$default((Bitmap)bitmap, null, (int)0, (int)0, (int)0, (int)15, null);
        if (v4 == null) {
            var8_9 = "Required value was null.";
            throw new IllegalArgumentException(var8_9.toString());
        }
        pixelData = v4;
        image.getPixelWriter().setPixels(0, 0, width, height, (PixelFormat)PixelFormat.getByteBgraPreInstance(), pixelData, 0, 4 * width);
        return image;
    }

    private final void drawPerfOverlay(org.jetbrains.skia.Canvas canvas, float width, float height) {
        Paint paint;
        String string = "FPS: %.1f | Frame: %.2f ms";
        Object[] objectArray = new Object[]{this.currentFps, this.lastFrameTimeMs};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String text = string2;
        float padding = 6.0f;
        Rect bounds = this.perfTextFont.measureText(text, this.perfTextPaint);
        float textWidth = bounds.getWidth();
        float textHeight = bounds.getHeight();
        float boxWidth = textWidth + (float)2 * padding;
        float boxHeight = textHeight + (float)2 * padding;
        float boxLeft = width - boxWidth - padding;
        float boxTop = padding;
        float boxRight = boxLeft + boxWidth;
        float boxBottom = boxTop + boxHeight;
        Paint $this$drawPerfOverlay_u24lambda_u240 = paint = new Paint();
        boolean bl = false;
        $this$drawPerfOverlay_u24lambda_u240.setColor(Color.INSTANCE.makeARGB(160, 0, 0, 0));
        $this$drawPerfOverlay_u24lambda_u240.setAntiAlias(true);
        Paint bgPaint = paint;
        Rect rect = new Rect(boxLeft, boxTop, boxRight, boxBottom);
        canvas.drawRect(rect, bgPaint);
        float textX = boxLeft + padding;
        float textBaselineY = boxTop + padding + textHeight;
        canvas.drawString(text, textX, textBaselineY, this.perfTextFont, this.perfTextPaint);
    }
}

