/*
 * Decompiled with CFR 0.152.
 */
package com.xorrus.trading.lot.app.plot;

import com.xorrus.trading.lot.app.plot.DistributionType;
import com.xorrus.trading.lot.app.plot.RiskMode;
import com.xorrus.trading.lot.app.plot.SkiaNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Color;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMgr;
import org.jetbrains.skia.FontStyle;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.PaintMode;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.Typeface;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010S\u001a\u00020TH\u0002J(\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020\u00052\u0006\u0010W\u001a\u00020\u00052\u0006\u0010X\u001a\u00020+2\u0006\u0010Y\u001a\u00020ZH\u0002J$\u0010[\u001a\u00020T2\n\u0010\\\u001a\u00060]j\u0002`^2\u0006\u0010_\u001a\u00020A2\u0006\u0010`\u001a\u00020AH\u0016J4\u0010a\u001a\u00020T2\n\u0010\\\u001a\u00060]j\u0002`^2\u0006\u0010b\u001a\u00020A2\u0006\u0010c\u001a\u00020A2\u0006\u0010d\u001a\u00020A2\u0006\u0010e\u001a\u00020AH\u0002J<\u0010f\u001a\u00020T2\n\u0010\\\u001a\u00060]j\u0002`^2\u0012\u0010g\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020A0h2\u0012\u0010i\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020A0hH\u0002JD\u0010j\u001a\u00020T2\n\u0010\\\u001a\u00060]j\u0002`^2\u0006\u0010b\u001a\u00020A2\u0006\u0010c\u001a\u00020A2\u0006\u0010d\u001a\u00020A2\u0006\u0010e\u001a\u00020A2\u0006\u0010k\u001a\u00020\u00052\u0006\u0010l\u001a\u00020\u0005H\u0002J&\u0010m\u001a\b\u0012\u0004\u0012\u00020\u00050;2\u0006\u0010n\u001a\u00020\u00052\u0006\u0010o\u001a\u00020\u00052\u0006\u0010p\u001a\u00020\u000bH\u0002J\u001c\u0010q\u001a\u00020T2\n\u0010\\\u001a\u00060]j\u0002`^2\u0006\u0010_\u001a\u00020AH\u0002J\u0010\u0010r\u001a\u00020s2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R$\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\nR$\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\b\"\u0004\b\u0019\u0010\nR\u0011\u0010\u001a\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\bR$\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u001c@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R$\u0010\"\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\b\"\u0004\b$\u0010\nR$\u0010%\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\b\"\u0004\b'\u0010\nR$\u0010(\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\b\"\u0004\b*\u0010\nR$\u0010,\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020+@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R$\u00101\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\b\"\u0004\b3\u0010\nR$\u00104\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020+@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010.\"\u0004\b6\u00100R$\u00107\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\b\"\u0004\b9\u0010\nR\u0014\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010=\u001a\b\u0012\u0004\u0012\u00020<0>X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010?R\u000e\u0010@\u001a\u00020AX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020AX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020AX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020AX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010F\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010G\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010I\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020OX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010P\u001a\u00020OX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020RX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006t"}, d2={"Lcom/xorrus/trading/lot/app/plot/MonteCarloChartNode;", "Lcom/xorrus/trading/lot/app/plot/SkiaNode;", "<init>", "()V", "value", "", "initialPortfolio", "getInitialPortfolio", "()D", "setInitialPortfolio", "(D)V", "", "numberOfPortfolios", "getNumberOfPortfolios", "()I", "setNumberOfPortfolios", "(I)V", "tradesPerPortfolio", "getTradesPerPortfolio", "setTradesPerPortfolio", "winProbability", "getWinProbability", "setWinProbability", "breakevenProbability", "getBreakevenProbability", "setBreakevenProbability", "lossProbability", "getLossProbability", "Lcom/xorrus/trading/lot/app/plot/RiskMode;", "riskMode", "getRiskMode", "()Lcom/xorrus/trading/lot/app/plot/RiskMode;", "setRiskMode", "(Lcom/xorrus/trading/lot/app/plot/RiskMode;)V", "riskValue", "getRiskValue", "setRiskValue", "riskStdDev", "getRiskStdDev", "setRiskStdDev", "winMultiple", "getWinMultiple", "setWinMultiple", "Lcom/xorrus/trading/lot/app/plot/DistributionType;", "winDistribution", "getWinDistribution", "()Lcom/xorrus/trading/lot/app/plot/DistributionType;", "setWinDistribution", "(Lcom/xorrus/trading/lot/app/plot/DistributionType;)V", "winStdDev", "getWinStdDev", "setWinStdDev", "lossDistribution", "getLossDistribution", "setLossDistribution", "lossStdDev", "getLossStdDev", "setLossStdDev", "paths", "", "", "percentiles", "", "[[D", "padding", "", "topPadding", "bottomPadding", "rightPadding", "pathColor", "medianColor", "percentile25Color", "percentile5Color", "axisColor", "textColor", "backgroundColor", "gridColor", "zeroLineColor", "labelFont", "Lorg/jetbrains/skia/Font;", "smallFont", "random", "Ljava/util/Random;", "runSimulation", "", "calculateDistributedValue", "baseValue", "stdDev", "distribution", "positive", "", "draw", "canvas", "Lorg/jetbrains/skia/Canvas;", "Lcom/xorrus/trading/lot/app/plot/SkiaCanvas;", "width", "height", "drawGrid", "chartLeft", "chartRight", "chartTop", "chartBottom", "drawPercentileLines", "xToScreen", "Lkotlin/Function1;", "yToScreen", "drawAxes", "yMin", "yMax", "calculateNiceTicks", "min", "max", "targetCount", "drawLegend", "formatValue", "", "laboftrades-app"})
@SourceDebugExtension(value={"SMAP\nMonteCarloChartNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonteCarloChartNode.kt\ncom/xorrus/trading/lot/app/plot/MonteCarloChartNode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,563:1\n1563#2:564\n1634#2,3:565\n1374#2:569\n1460#2,5:570\n1#3:568\n*S KotlinDebug\n*F\n+ 1 MonteCarloChartNode.kt\ncom/xorrus/trading/lot/app/plot/MonteCarloChartNode\n*L\n225#1:564\n225#1:565,3\n300#1:569\n300#1:570,5\n*E\n"})
public final class MonteCarloChartNode
extends SkiaNode {
    private double initialPortfolio = 10000.0;
    private int numberOfPortfolios = 500;
    private int tradesPerPortfolio = 100;
    private double winProbability = 0.4;
    private double breakevenProbability = 0.1;
    @NotNull
    private RiskMode riskMode = RiskMode.ABSOLUTE;
    private double riskValue = 100.0;
    private double riskStdDev;
    private double winMultiple = 2.0;
    @NotNull
    private DistributionType winDistribution = DistributionType.NORMAL;
    private double winStdDev = 0.5;
    @NotNull
    private DistributionType lossDistribution = DistributionType.NORMAL;
    private double lossStdDev = 0.2;
    @NotNull
    private List<double[]> paths = CollectionsKt.emptyList();
    @NotNull
    private double[][] percentiles = new double[0][];
    private final float padding;
    private final float topPadding;
    private final float bottomPadding;
    private final float rightPadding;
    private final int pathColor = Color.INSTANCE.makeARGB(70, 100, 150, 255);
    private final int medianColor = Color.INSTANCE.makeRGB(255, 255, 100);
    private final int percentile25Color = Color.INSTANCE.makeRGB(100, 200, 100);
    private final int percentile5Color = Color.INSTANCE.makeRGB(255, 100, 100);
    private final int axisColor = Color.INSTANCE.makeRGB(200, 200, 200);
    private final int textColor = Color.INSTANCE.makeRGB(220, 220, 220);
    private final int backgroundColor = Color.INSTANCE.makeRGB(30, 30, 30);
    private final int gridColor = Color.INSTANCE.makeARGB(50, 200, 200, 200);
    private final int zeroLineColor = Color.INSTANCE.makeARGB(100, 255, 255, 255);
    @NotNull
    private final Font labelFont;
    @NotNull
    private final Font smallFont;
    @NotNull
    private final Random random;

    public MonteCarloChartNode() {
        this.padding = 70.0f;
        this.topPadding = 30.0f;
        this.bottomPadding = 40.0f;
        this.rightPadding = 20.0f;
        MonteCarloChartNode monteCarloChartNode = this;
        MonteCarloChartNode monteCarloChartNode2 = this;
        boolean bl = false;
        Typeface typeface = FontMgr.Companion.getDefault().matchFamilyStyle("Helvetica Neue", FontStyle.Companion.getNORMAL());
        if (typeface == null && (typeface = FontMgr.Companion.getDefault().matchFamilyStyle("Arial", FontStyle.Companion.getNORMAL())) == null) {
            typeface = FontMgr.Companion.getDefault().matchFamilyStyle(null, FontStyle.Companion.getNORMAL());
        }
        Typeface typeface2 = typeface;
        monteCarloChartNode2.labelFont = new Font(typeface2, 11.0f);
        MonteCarloChartNode $this$labelFont_u24lambda_u240 = this;
        monteCarloChartNode2 = this;
        boolean bl2 = false;
        Typeface typeface3 = FontMgr.Companion.getDefault().matchFamilyStyle("Helvetica Neue", FontStyle.Companion.getNORMAL());
        if (typeface3 == null && (typeface3 = FontMgr.Companion.getDefault().matchFamilyStyle("Arial", FontStyle.Companion.getNORMAL())) == null) {
            typeface3 = FontMgr.Companion.getDefault().matchFamilyStyle(null, FontStyle.Companion.getNORMAL());
        }
        typeface2 = typeface3;
        monteCarloChartNode2.smallFont = new Font(typeface2, 9.0f);
        this.random = new Random();
        this.runSimulation();
    }

    public final double getInitialPortfolio() {
        return this.initialPortfolio;
    }

    public final void setInitialPortfolio(double value) {
        this.initialPortfolio = RangesKt.coerceAtLeast((double)value, (double)1.0);
        this.runSimulation();
    }

    public final int getNumberOfPortfolios() {
        return this.numberOfPortfolios;
    }

    public final void setNumberOfPortfolios(int value) {
        this.numberOfPortfolios = RangesKt.coerceIn((int)value, (int)10, (int)2000);
        this.runSimulation();
    }

    public final int getTradesPerPortfolio() {
        return this.tradesPerPortfolio;
    }

    public final void setTradesPerPortfolio(int value) {
        this.tradesPerPortfolio = RangesKt.coerceIn((int)value, (int)10, (int)1000);
        this.runSimulation();
    }

    public final double getWinProbability() {
        return this.winProbability;
    }

    public final void setWinProbability(double value) {
        this.winProbability = RangesKt.coerceIn((double)value, (double)0.0, (double)1.0);
        this.runSimulation();
    }

    public final double getBreakevenProbability() {
        return this.breakevenProbability;
    }

    public final void setBreakevenProbability(double value) {
        this.breakevenProbability = RangesKt.coerceIn((double)value, (double)0.0, (double)1.0);
        this.runSimulation();
    }

    public final double getLossProbability() {
        return RangesKt.coerceAtLeast((double)(1.0 - this.winProbability - this.breakevenProbability), (double)0.0);
    }

    @NotNull
    public final RiskMode getRiskMode() {
        return this.riskMode;
    }

    public final void setRiskMode(@NotNull RiskMode value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.riskMode = value;
        this.runSimulation();
    }

    public final double getRiskValue() {
        return this.riskValue;
    }

    public final void setRiskValue(double value) {
        this.riskValue = RangesKt.coerceAtLeast((double)value, (double)0.01);
        this.runSimulation();
    }

    public final double getRiskStdDev() {
        return this.riskStdDev;
    }

    public final void setRiskStdDev(double value) {
        this.riskStdDev = RangesKt.coerceAtLeast((double)value, (double)0.0);
        this.runSimulation();
    }

    public final double getWinMultiple() {
        return this.winMultiple;
    }

    public final void setWinMultiple(double value) {
        this.winMultiple = RangesKt.coerceAtLeast((double)value, (double)0.1);
        this.runSimulation();
    }

    @NotNull
    public final DistributionType getWinDistribution() {
        return this.winDistribution;
    }

    public final void setWinDistribution(@NotNull DistributionType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.winDistribution = value;
        this.runSimulation();
    }

    public final double getWinStdDev() {
        return this.winStdDev;
    }

    public final void setWinStdDev(double value) {
        this.winStdDev = RangesKt.coerceAtLeast((double)value, (double)0.0);
        this.runSimulation();
    }

    @NotNull
    public final DistributionType getLossDistribution() {
        return this.lossDistribution;
    }

    public final void setLossDistribution(@NotNull DistributionType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.lossDistribution = value;
        this.runSimulation();
    }

    public final double getLossStdDev() {
        return this.lossStdDev;
    }

    public final void setLossStdDev(double value) {
        this.lossStdDev = RangesKt.coerceAtLeast((double)value, (double)0.0);
        this.runSimulation();
    }

    /*
     * WARNING - void declaration
     */
    private final void runSimulation() {
        int sim;
        List allPaths = new ArrayList();
        int n = this.numberOfPortfolios;
        for (sim = 0; sim < n; ++sim) {
            double[] path = new double[this.tradesPerPortfolio + 1];
            path[0] = this.initialPortfolio;
            int t = 1;
            int n2 = this.tradesPerPortfolio;
            if (t <= n2) {
                while (true) {
                    double d;
                    double currentPortfolio = path[t - 1];
                    double baseRisk = switch (WhenMappings.$EnumSwitchMapping$0[this.riskMode.ordinal()]) {
                        case 1 -> this.riskValue;
                        case 2 -> currentPortfolio * this.riskValue / 100.0;
                        default -> throw new NoWhenBranchMatchedException();
                    };
                    double actualRisk = this.riskStdDev > 0.0 ? RangesKt.coerceAtLeast((double)(baseRisk + this.random.nextGaussian() * this.riskStdDev * baseRisk), (double)0.01) : baseRisk;
                    double roll = this.random.nextDouble();
                    if (roll < this.winProbability) {
                        double winR = this.calculateDistributedValue(this.winMultiple, this.winStdDev, this.winDistribution, true);
                        d = actualRisk * winR;
                    } else if (roll < this.winProbability + this.breakevenProbability) {
                        d = 0.0;
                    } else {
                        double lossR = this.calculateDistributedValue(1.0, this.lossStdDev, this.lossDistribution, false);
                        d = -actualRisk * lossR;
                    }
                    double tradeResult = d;
                    path[t] = currentPortfolio + tradeResult;
                    if (t == n2) break;
                    ++t;
                }
            }
            allPaths.add(path);
        }
        this.paths = allPaths;
        sim = 0;
        double[][] dArrayArray = new double[5][];
        Object object = this;
        while (sim < 5) {
            int path = sim++;
            dArrayArray[path] = new double[this.tradesPerPortfolio + 1];
        }
        ((MonteCarloChartNode)((Object)object)).percentiles = dArrayArray;
        int t = 0;
        int n3 = this.tradesPerPortfolio;
        if (t <= n3) {
            while (true) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = allPaths;
                boolean $i$f$map = false;
                Iterable currentPortfolio = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    double[] dArray = (double[])item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl = false;
                    object.add((double)it[t]);
                }
                List valuesAtT = CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                int n4 = this.numberOfPortfolios;
                this.percentiles[0][t] = ((Number)valuesAtT.get(RangesKt.coerceIn((int)((int)((double)n4 * 0.05)), (int)0, (int)(n4 - 1)))).doubleValue();
                this.percentiles[1][t] = ((Number)valuesAtT.get(RangesKt.coerceIn((int)((int)((double)n4 * 0.25)), (int)0, (int)(n4 - 1)))).doubleValue();
                this.percentiles[2][t] = ((Number)valuesAtT.get(RangesKt.coerceIn((int)((int)((double)n4 * 0.5)), (int)0, (int)(n4 - 1)))).doubleValue();
                this.percentiles[3][t] = ((Number)valuesAtT.get(RangesKt.coerceIn((int)((int)((double)n4 * 0.75)), (int)0, (int)(n4 - 1)))).doubleValue();
                this.percentiles[4][t] = ((Number)valuesAtT.get(RangesKt.coerceIn((int)((int)((double)n4 * 0.95)), (int)0, (int)(n4 - 1)))).doubleValue();
                if (t == n3) break;
                ++t;
            }
        }
        this.repaint();
    }

    private final double calculateDistributedValue(double baseValue, double stdDev, DistributionType distribution, boolean positive) {
        if (stdDev <= 0.0) {
            return baseValue;
        }
        return switch (WhenMappings.$EnumSwitchMapping$1[distribution.ordinal()]) {
            case 1 -> baseValue + (this.random.nextDouble() * (double)2 - 1.0) * stdDev;
            case 2 -> baseValue + this.random.nextGaussian() * stdDev;
            case 3 -> {
                int degreesOfFreedom = 4;
                double z = this.random.nextGaussian();
                double chiSquared = 0.0;
                for (int i = 0; i < degreesOfFreedom; ++i) {
                    double x = this.random.nextGaussian();
                    chiSquared += x * x;
                }
                double t = z / Math.sqrt(chiSquared / (double)degreesOfFreedom);
                yield baseValue + t * stdDev;
            }
            case 4 -> baseValue + Math.abs(this.random.nextGaussian()) * stdDev;
            case 5 -> baseValue + Math.abs(this.random.nextGaussian()) * stdDev;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw(@NotNull Canvas canvas, float width, float height) {
        Paint zeroLinePaint;
        Paint paint;
        void $this$flatMapTo$iv$iv;
        Paint paint2;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Paint $this$draw_u24lambda_u240 = paint2 = new Paint();
        boolean bl = false;
        $this$draw_u24lambda_u240.setColor(this.backgroundColor);
        Paint bgPaint = paint2;
        canvas.drawRect(new Rect(0.0f, 0.0f, width, height), bgPaint);
        float chartLeft = this.padding;
        float chartRight = width - this.rightPadding;
        float chartTop = this.topPadding;
        float chartBottom = height - this.bottomPadding;
        float chartWidth = chartRight - chartLeft;
        float chartHeight = chartBottom - chartTop;
        if (chartWidth <= 0.0f || chartHeight <= 0.0f || this.paths.isEmpty()) {
            return;
        }
        Iterable $this$flatMap$iv = this.paths;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            double[] it = (double[])element$iv$iv;
            boolean bl2 = false;
            Iterable list$iv$iv = ArraysKt.toList((double[])it);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List allValues = (List)destination$iv$iv;
        Double d = CollectionsKt.minOrNull((Iterable)allValues);
        double yMin = d != null ? d : 0.0;
        Double d2 = CollectionsKt.maxOrNull((Iterable)allValues);
        double yMax = d2 != null ? d2 : 1.0;
        double yRange = yMax - yMin;
        double yPadding = yRange * 0.05;
        double displayYMin = yMin - yPadding;
        double displayYMax = yMax + yPadding;
        this.drawGrid(canvas, chartLeft, chartRight, chartTop, chartBottom);
        float startLineY = MonteCarloChartNode.draw$yToScreen(chartBottom, displayYMin, displayYMax, chartHeight, this.initialPortfolio);
        Paint $this$draw_u24lambda_u242 = paint = new Paint();
        boolean bl3 = false;
        $this$draw_u24lambda_u242.setColor(this.zeroLineColor);
        $this$draw_u24lambda_u242.setStrokeWidth(1.0f);
        $this$draw_u24lambda_u242.setAntiAlias(true);
        Paint startLinePaint = paint;
        canvas.drawLine(chartLeft, startLineY, chartRight, startLineY, startLinePaint);
        if (displayYMin <= 0.0 && displayYMax >= 0.0) {
            float zeroY = MonteCarloChartNode.draw$yToScreen(chartBottom, displayYMin, displayYMax, chartHeight, 0.0);
            Paint $this$draw_u24lambda_u243 = bl3 = new Paint();
            boolean bl4 = false;
            $this$draw_u24lambda_u243.setColor(Color.INSTANCE.makeARGB(150, 255, 100, 100));
            $this$draw_u24lambda_u243.setStrokeWidth(1.5f);
            $this$draw_u24lambda_u243.setAntiAlias(true);
            zeroLinePaint = bl3;
            canvas.drawLine(chartLeft, zeroY, chartRight, zeroY, zeroLinePaint);
        }
        Paint $this$draw_u24lambda_u244 = zeroLinePaint = new Paint();
        boolean bl5 = false;
        $this$draw_u24lambda_u244.setColor(this.pathColor);
        $this$draw_u24lambda_u244.setStrokeWidth(1.0f);
        $this$draw_u24lambda_u244.setAntiAlias(true);
        $this$draw_u24lambda_u244.setMode(PaintMode.STROKE);
        Paint pathPaint = zeroLinePaint;
        List pathsToShow = this.paths.size() > 200 ? CollectionsKt.take((Iterable)CollectionsKt.shuffled((Iterable)this.paths), (int)200) : this.paths;
        block1: for (double[] path : pathsToShow) {
            int t = 1;
            int n = this.tradesPerPortfolio;
            if (t > n) continue;
            while (true) {
                canvas.drawLine(MonteCarloChartNode.draw$xToScreen(chartLeft, this, chartWidth, t - 1), MonteCarloChartNode.draw$yToScreen(chartBottom, displayYMin, displayYMax, chartHeight, path[t - 1]), MonteCarloChartNode.draw$xToScreen(chartLeft, this, chartWidth, t), MonteCarloChartNode.draw$yToScreen(chartBottom, displayYMin, displayYMax, chartHeight, path[t]), pathPaint);
                if (t == n) continue block1;
                ++t;
            }
        }
        this.drawPercentileLines(canvas, (Function1<? super Integer, Float>)((Function1)new Function1<Integer, Float>(chartLeft, this, chartWidth){
            final /* synthetic */ float $chartLeft;
            final /* synthetic */ MonteCarloChartNode this$0;
            final /* synthetic */ float $chartWidth;
            {
                this.$chartLeft = $chartLeft;
                this.this$0 = $receiver;
                this.$chartWidth = $chartWidth;
                super(1, Intrinsics.Kotlin.class, "xToScreen", "draw$xToScreen(FLcom/xorrus/trading/lot/app/plot/MonteCarloChartNode;FI)F", 0);
            }

            public final Float invoke(int p0) {
                return Float.valueOf(MonteCarloChartNode.access$draw$xToScreen(this.$chartLeft, this.this$0, this.$chartWidth, p0));
            }
        }), (Function1<? super Double, Float>)((Function1)new Function1<Double, Float>(chartBottom, displayYMin, displayYMax, chartHeight){
            final /* synthetic */ float $chartBottom;
            final /* synthetic */ double $displayYMin;
            final /* synthetic */ double $displayYMax;
            final /* synthetic */ float $chartHeight;
            {
                this.$chartBottom = $chartBottom;
                this.$displayYMin = $displayYMin;
                this.$displayYMax = $displayYMax;
                this.$chartHeight = $chartHeight;
                super(1, Intrinsics.Kotlin.class, "yToScreen", "draw$yToScreen(FDDFD)F", 0);
            }

            public final Float invoke(double p0) {
                return Float.valueOf(MonteCarloChartNode.access$draw$yToScreen(this.$chartBottom, this.$displayYMin, this.$displayYMax, this.$chartHeight, p0));
            }
        }));
        this.drawAxes(canvas, chartLeft, chartRight, chartTop, chartBottom, displayYMin, displayYMax);
        this.drawLegend(canvas, width);
    }

    private final void drawGrid(Canvas canvas, float chartLeft, float chartRight, float chartTop, float chartBottom) {
        Paint paint;
        Paint $this$drawGrid_u24lambda_u240 = paint = new Paint();
        boolean bl = false;
        $this$drawGrid_u24lambda_u240.setColor(this.gridColor);
        $this$drawGrid_u24lambda_u240.setStrokeWidth(1.0f);
        $this$drawGrid_u24lambda_u240.setAntiAlias(true);
        Paint gridPaint = paint;
        for (int i = 0; i < 6; ++i) {
            float y = chartBottom - (float)i * (chartBottom - chartTop) / (float)5;
            canvas.drawLine(chartLeft, y, chartRight, y, gridPaint);
            float x = chartLeft + (float)i * (chartRight - chartLeft) / (float)5;
            canvas.drawLine(x, chartTop, x, chartBottom, gridPaint);
        }
    }

    private final void drawPercentileLines(Canvas canvas, Function1<? super Integer, Float> xToScreen, Function1<? super Double, Float> yToScreen) {
        Paint paint;
        Paint $this$drawPercentileLines_u24lambda_u240 = paint = new Paint();
        boolean bl = false;
        $this$drawPercentileLines_u24lambda_u240.setColor(this.percentile5Color);
        $this$drawPercentileLines_u24lambda_u240.setStrokeWidth(2.0f);
        $this$drawPercentileLines_u24lambda_u240.setAntiAlias(true);
        $this$drawPercentileLines_u24lambda_u240.setMode(PaintMode.STROKE);
        Paint p5Paint = paint;
        Paint $this$drawPercentileLines_u24lambda_u241 = $this$drawPercentileLines_u24lambda_u240 = new Paint();
        boolean bl2 = false;
        $this$drawPercentileLines_u24lambda_u241.setColor(this.percentile25Color);
        $this$drawPercentileLines_u24lambda_u241.setStrokeWidth(2.0f);
        $this$drawPercentileLines_u24lambda_u241.setAntiAlias(true);
        $this$drawPercentileLines_u24lambda_u241.setMode(PaintMode.STROKE);
        Paint p25Paint = $this$drawPercentileLines_u24lambda_u240;
        Paint $this$drawPercentileLines_u24lambda_u242 = $this$drawPercentileLines_u24lambda_u241 = new Paint();
        boolean bl3 = false;
        $this$drawPercentileLines_u24lambda_u242.setColor(this.medianColor);
        $this$drawPercentileLines_u24lambda_u242.setStrokeWidth(3.0f);
        $this$drawPercentileLines_u24lambda_u242.setAntiAlias(true);
        $this$drawPercentileLines_u24lambda_u242.setMode(PaintMode.STROKE);
        Paint medianPaint = $this$drawPercentileLines_u24lambda_u241;
        int t = 1;
        int n = this.tradesPerPortfolio;
        if (t <= n) {
            while (true) {
                canvas.drawLine(((Number)xToScreen.invoke((Object)(t - 1))).floatValue(), ((Number)yToScreen.invoke((Object)this.percentiles[0][t - 1])).floatValue(), ((Number)xToScreen.invoke((Object)t)).floatValue(), ((Number)yToScreen.invoke((Object)this.percentiles[0][t])).floatValue(), p5Paint);
                canvas.drawLine(((Number)xToScreen.invoke((Object)(t - 1))).floatValue(), ((Number)yToScreen.invoke((Object)this.percentiles[4][t - 1])).floatValue(), ((Number)xToScreen.invoke((Object)t)).floatValue(), ((Number)yToScreen.invoke((Object)this.percentiles[4][t])).floatValue(), p5Paint);
                canvas.drawLine(((Number)xToScreen.invoke((Object)(t - 1))).floatValue(), ((Number)yToScreen.invoke((Object)this.percentiles[1][t - 1])).floatValue(), ((Number)xToScreen.invoke((Object)t)).floatValue(), ((Number)yToScreen.invoke((Object)this.percentiles[1][t])).floatValue(), p25Paint);
                canvas.drawLine(((Number)xToScreen.invoke((Object)(t - 1))).floatValue(), ((Number)yToScreen.invoke((Object)this.percentiles[3][t - 1])).floatValue(), ((Number)xToScreen.invoke((Object)t)).floatValue(), ((Number)yToScreen.invoke((Object)this.percentiles[3][t])).floatValue(), p25Paint);
                canvas.drawLine(((Number)xToScreen.invoke((Object)(t - 1))).floatValue(), ((Number)yToScreen.invoke((Object)this.percentiles[2][t - 1])).floatValue(), ((Number)xToScreen.invoke((Object)t)).floatValue(), ((Number)yToScreen.invoke((Object)this.percentiles[2][t])).floatValue(), medianPaint);
                if (t == n) break;
                ++t;
            }
        }
    }

    private final void drawAxes(Canvas canvas, float chartLeft, float chartRight, float chartTop, float chartBottom, double yMin, double yMax) {
        Paint paint;
        Paint $this$drawAxes_u24lambda_u240 = paint = new Paint();
        boolean bl = false;
        $this$drawAxes_u24lambda_u240.setColor(this.axisColor);
        $this$drawAxes_u24lambda_u240.setStrokeWidth(1.0f);
        $this$drawAxes_u24lambda_u240.setAntiAlias(true);
        Paint axisPaint = paint;
        Paint $this$drawAxes_u24lambda_u241 = $this$drawAxes_u24lambda_u240 = new Paint();
        boolean bl2 = false;
        $this$drawAxes_u24lambda_u241.setColor(this.textColor);
        $this$drawAxes_u24lambda_u241.setAntiAlias(true);
        Paint labelPaint = $this$drawAxes_u24lambda_u240;
        canvas.drawLine(chartLeft, chartBottom, chartRight, chartBottom, axisPaint);
        canvas.drawLine(chartLeft, chartTop, chartLeft, chartBottom, axisPaint);
        for (int i = 0; i < 6; ++i) {
            float x = chartLeft + (float)i * (chartRight - chartLeft) / (float)5;
            int trade = i * this.tradesPerPortfolio / 5;
            canvas.drawLine(x, chartBottom, x, chartBottom + 5.0f, axisPaint);
            String valueStr = String.valueOf(trade);
            Rect textBounds = this.smallFont.measureText(valueStr, labelPaint);
            canvas.drawString(valueStr, x - textBounds.getWidth() / (float)2, chartBottom + 18.0f, this.smallFont, labelPaint);
        }
        List<Double> yTicks = this.calculateNiceTicks(yMin, yMax, 5);
        float chartHeight = chartBottom - chartTop;
        Iterator<Double> iterator = yTicks.iterator();
        while (iterator.hasNext()) {
            double tickValue = ((Number)iterator.next()).doubleValue();
            float y = chartBottom - (float)((tickValue - yMin) / (yMax - yMin) * (double)chartHeight);
            canvas.drawLine(chartLeft - 5.0f, y, chartLeft, y, axisPaint);
            String valueStr = this.formatValue(tickValue);
            Rect textBounds = this.smallFont.measureText(valueStr, labelPaint);
            canvas.drawString(valueStr, chartLeft - textBounds.getWidth() - 8.0f, y + 4.0f, this.smallFont, labelPaint);
        }
        canvas.drawString("Trade #", chartLeft + (chartRight - chartLeft) / (float)2 - 20.0f, chartBottom + 32.0f, this.labelFont, labelPaint);
    }

    private final List<Double> calculateNiceTicks(double min, double max, int targetCount) {
        double range = max - min;
        if (range <= 0.0) {
            return CollectionsKt.listOf((Object)min);
        }
        double roughStep = range / (double)targetCount;
        double magnitude = Math.pow(10.0, Math.floor(Math.log10(roughStep)));
        double normalized = roughStep / magnitude;
        double niceStep = (normalized <= 1.0 ? 1.0 : (normalized <= 2.0 ? 2.0 : (normalized <= 5.0 ? 5.0 : 10.0))) * magnitude;
        double niceMin = Math.floor(min / niceStep) * niceStep;
        double niceMax = Math.ceil(max / niceStep) * niceStep;
        List ticks = new ArrayList();
        for (double tick = niceMin; tick <= niceMax; tick += niceStep) {
            if (!(tick >= min) || !(tick <= max)) continue;
            ticks.add(tick);
        }
        return ticks;
    }

    private final void drawLegend(Canvas canvas, float width) {
        Paint paint;
        Paint paint2;
        Paint $this$drawLegend_u24lambda_u240 = paint2 = new Paint();
        boolean bl = false;
        $this$drawLegend_u24lambda_u240.setColor(this.textColor);
        $this$drawLegend_u24lambda_u240.setAntiAlias(true);
        Paint legendPaint = paint2;
        float y = 15.0f;
        float x = 10.0f;
        double ev = this.winProbability * this.winMultiple - this.getLossProbability();
        String string = "EV: %.2fR";
        Object[] objectArray = new Object[]{ev};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String evText = string2;
        canvas.drawString(evText, x, y, this.labelFont, legendPaint);
        x += 80.0f;
        objectArray = "W:%.0f%% B:%.0f%% L:%.0f%%";
        Object[] objectArray2 = new Object[]{this.winProbability * (double)100, this.breakevenProbability * (double)100, this.getLossProbability() * (double)100};
        String string3 = String.format((String)objectArray, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String probText = string3;
        canvas.drawString(probText, x, y, this.labelFont, legendPaint);
        Object[] $this$drawLegend_u24lambda_u241 = objectArray = new Paint();
        boolean bl2 = false;
        $this$drawLegend_u24lambda_u241.setColor(this.medianColor);
        Object[] medianPaint = objectArray;
        canvas.drawRect(new Rect(x += 130.0f, y - 8.0f, x + 15.0f, y - 4.0f), (Paint)medianPaint);
        canvas.drawString("50%", x += 18.0f, y, this.smallFont, legendPaint);
        Object[] $this$drawLegend_u24lambda_u242 = $this$drawLegend_u24lambda_u241 = new Paint();
        boolean bl3 = false;
        $this$drawLegend_u24lambda_u242.setColor(this.percentile25Color);
        Object[] p25Paint = $this$drawLegend_u24lambda_u241;
        canvas.drawRect(new Rect(x += 30.0f, y - 8.0f, x + 15.0f, y - 4.0f), (Paint)p25Paint);
        canvas.drawString("25/75%", x += 18.0f, y, this.smallFont, legendPaint);
        Paint $this$drawLegend_u24lambda_u243 = paint = new Paint();
        boolean bl4 = false;
        $this$drawLegend_u24lambda_u243.setColor(this.percentile5Color);
        Paint p5Paint = paint;
        canvas.drawRect(new Rect(x += 45.0f, y - 8.0f, x + 15.0f, y - 4.0f), p5Paint);
        canvas.drawString("5/95%", x += 18.0f, y, this.smallFont, legendPaint);
    }

    private final String formatValue(double value) {
        String string;
        if (value >= 1000000.0) {
            String string2 = "%.1fM";
            Object[] objectArray = new Object[]{value / (double)1000000};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else if (value >= 1000.0) {
            String string4 = "%.1fK";
            Object[] objectArray = new Object[]{value / (double)1000};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        } else if (value >= 100.0) {
            String string6 = "%.0f";
            Object[] objectArray = new Object[]{value};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
        } else if (value >= 10.0) {
            String string8 = "%.1f";
            Object[] objectArray = new Object[]{value};
            String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(...)");
        } else {
            String string10 = "%.2f";
            Object[] objectArray = new Object[]{value};
            String string11 = String.format(string10, Arrays.copyOf(objectArray, objectArray.length));
            string = string11;
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"format(...)");
        }
        return string;
    }

    private static final float draw$xToScreen(float chartLeft, MonteCarloChartNode this$0, float chartWidth, int t) {
        return chartLeft + (float)t / (float)this$0.tradesPerPortfolio * chartWidth;
    }

    private static final float draw$yToScreen(float chartBottom, double displayYMin, double displayYMax, float chartHeight, double v) {
        return chartBottom - (float)((v - displayYMin) / (displayYMax - displayYMin) * (double)chartHeight);
    }

    public static final /* synthetic */ float access$draw$xToScreen(float chartLeft, MonteCarloChartNode this$0, float chartWidth, int t) {
        return MonteCarloChartNode.draw$xToScreen(chartLeft, this$0, chartWidth, t);
    }

    public static final /* synthetic */ float access$draw$yToScreen(float chartBottom, double displayYMin, double displayYMax, float chartHeight, double v) {
        return MonteCarloChartNode.draw$yToScreen(chartBottom, displayYMin, displayYMax, chartHeight, v);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RiskMode.values().length];
            try {
                nArray[RiskMode.ABSOLUTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RiskMode.PERCENTAGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[DistributionType.values().length];
            try {
                nArray[DistributionType.UNIFORM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.NORMAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.STUDENT_T.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.HALF_NORMAL_RIGHT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DistributionType.TRUNCATED_LEFT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

