/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0006\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0007R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0012\u001a\u0004\b\u0013\u0010\u0007R\u0017\u0010\u0015\u001a\u00020\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lio/ktor/network/tls/OID;", "", "", "identifier", "<init>", "(Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "copy", "(Ljava/lang/String;)Lio/ktor/network/tls/OID;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getIdentifier", "", "asArray", "[I", "getAsArray", "()[I", "Companion", "ktor-network-tls"})
@SourceDebugExtension(value={"SMAP\nOID.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OID.kt\nio/ktor/network/tls/OID\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1563#2:86\n1634#2,3:87\n*S KotlinDebug\n*F\n+ 1 OID.kt\nio/ktor/network/tls/OID\n*L\n8#1:86\n8#1:87,3\n*E\n"})
public final class OID {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String identifier;
    @NotNull
    private final int[] asArray;
    @NotNull
    private static final OID OrganizationName = new OID("2.5.4.10");
    @NotNull
    private static final OID OrganizationalUnitName = new OID("2.5.4.11");
    @NotNull
    private static final OID CountryName = new OID("2.5.4.6");
    @NotNull
    private static final OID CommonName = new OID("2.5.4.3");
    @NotNull
    private static final OID SubjectAltName = new OID("2.5.29.17");
    @NotNull
    private static final OID BasicConstraints = new OID("2.5.29.19");
    @NotNull
    private static final OID KeyUsage = new OID("2.5.29.15");
    @NotNull
    private static final OID ExtKeyUsage = new OID("2.5.29.37");
    @NotNull
    private static final OID ServerAuth = new OID("1.3.6.1.5.5.7.3.1");
    @NotNull
    private static final OID ClientAuth = new OID("1.3.6.1.5.5.7.3.2");
    @NotNull
    private static final OID RSAEncryption = new OID("1 2 840 113549 1 1 1");
    @NotNull
    private static final OID ECEncryption = new OID("1.2.840.10045.2.1");
    @NotNull
    private static final OID ECDSAwithSHA384Encryption = new OID("1.2.840.10045.4.3.3");
    @NotNull
    private static final OID ECDSAwithSHA256Encryption = new OID("1.2.840.10045.4.3.2");
    @NotNull
    private static final OID RSAwithSHA512Encryption = new OID("1.2.840.113549.1.1.13");
    @NotNull
    private static final OID RSAwithSHA384Encryption = new OID("1.2.840.113549.1.1.12");
    @NotNull
    private static final OID RSAwithSHA256Encryption = new OID("1.2.840.113549.1.1.11");
    @NotNull
    private static final OID RSAwithSHA1Encryption = new OID("1.2.840.113549.1.1.5");
    @NotNull
    private static final OID secp256r1 = new OID("1.2.840.10045.3.1.7");

    /*
     * WARNING - void declaration
     */
    public OID(@NotNull String identifier) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        this.identifier = identifier;
        Object object = new String[]{".", " "};
        object = StringsKt.split$default((CharSequence)this.identifier, (String[])object, (boolean)false, (int)0, (int)6, null);
        OID oID = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Integer.parseInt(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString()));
        }
        oID.asArray = CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
    }

    @NotNull
    public final String getIdentifier() {
        return this.identifier;
    }

    @NotNull
    public final int[] getAsArray() {
        return this.asArray;
    }

    @NotNull
    public final String component1() {
        return this.identifier;
    }

    @NotNull
    public final OID copy(@NotNull String identifier) {
        Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
        return new OID(identifier);
    }

    public static /* synthetic */ OID copy$default(OID oID, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = oID.identifier;
        }
        return oID.copy(string);
    }

    @NotNull
    public String toString() {
        return "OID(identifier=" + this.identifier + ')';
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OID)) {
            return false;
        }
        OID oID = (OID)other;
        return Intrinsics.areEqual((Object)this.identifier, (Object)oID.identifier);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b+\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\u0010\u0010\fR\u0017\u0010\u0011\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u0012\u0010\fR\u0017\u0010\u0013\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\n\u001a\u0004\b\u0014\u0010\fR\u0017\u0010\u0015\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\n\u001a\u0004\b\u0016\u0010\fR\u0017\u0010\u0017\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0017\u0010\n\u001a\u0004\b\u0018\u0010\fR\u0017\u0010\u0019\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\n\u001a\u0004\b\u001a\u0010\fR\u0017\u0010\u001b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\n\u001a\u0004\b\u001c\u0010\fR\u0017\u0010\u001d\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\n\u001a\u0004\b\u001e\u0010\fR\u0017\u0010\u001f\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010\n\u001a\u0004\b \u0010\fR\u0017\u0010!\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b!\u0010\n\u001a\u0004\b\"\u0010\fR\u0017\u0010#\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b#\u0010\n\u001a\u0004\b$\u0010\fR\u0017\u0010%\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b%\u0010\n\u001a\u0004\b&\u0010\fR\u0017\u0010'\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b'\u0010\n\u001a\u0004\b(\u0010\fR\u0017\u0010)\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b)\u0010\n\u001a\u0004\b*\u0010\fR\u0017\u0010+\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b+\u0010\n\u001a\u0004\b,\u0010\fR\u0017\u0010-\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b-\u0010\n\u001a\u0004\b.\u0010\fR\u0017\u0010/\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b/\u0010\n\u001a\u0004\b0\u0010\f\u00a8\u00061"}, d2={"Lio/ktor/network/tls/OID$Companion;", "", "<init>", "()V", "", "algorithm", "Lio/ktor/network/tls/OID;", "fromAlgorithm", "(Ljava/lang/String;)Lio/ktor/network/tls/OID;", "OrganizationName", "Lio/ktor/network/tls/OID;", "getOrganizationName", "()Lio/ktor/network/tls/OID;", "OrganizationalUnitName", "getOrganizationalUnitName", "CountryName", "getCountryName", "CommonName", "getCommonName", "SubjectAltName", "getSubjectAltName", "BasicConstraints", "getBasicConstraints", "KeyUsage", "getKeyUsage", "ExtKeyUsage", "getExtKeyUsage", "ServerAuth", "getServerAuth", "ClientAuth", "getClientAuth", "RSAEncryption", "getRSAEncryption", "ECEncryption", "getECEncryption", "ECDSAwithSHA384Encryption", "getECDSAwithSHA384Encryption", "ECDSAwithSHA256Encryption", "getECDSAwithSHA256Encryption", "RSAwithSHA512Encryption", "getRSAwithSHA512Encryption", "RSAwithSHA384Encryption", "getRSAwithSHA384Encryption", "RSAwithSHA256Encryption", "getRSAwithSHA256Encryption", "RSAwithSHA1Encryption", "getRSAwithSHA1Encryption", "secp256r1", "getSecp256r1", "ktor-network-tls"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OID getOrganizationName() {
            return OrganizationName;
        }

        @NotNull
        public final OID getOrganizationalUnitName() {
            return OrganizationalUnitName;
        }

        @NotNull
        public final OID getCountryName() {
            return CountryName;
        }

        @NotNull
        public final OID getCommonName() {
            return CommonName;
        }

        @NotNull
        public final OID getSubjectAltName() {
            return SubjectAltName;
        }

        @NotNull
        public final OID getBasicConstraints() {
            return BasicConstraints;
        }

        @NotNull
        public final OID getKeyUsage() {
            return KeyUsage;
        }

        @NotNull
        public final OID getExtKeyUsage() {
            return ExtKeyUsage;
        }

        @NotNull
        public final OID getServerAuth() {
            return ServerAuth;
        }

        @NotNull
        public final OID getClientAuth() {
            return ClientAuth;
        }

        @NotNull
        public final OID getRSAEncryption() {
            return RSAEncryption;
        }

        @NotNull
        public final OID getECEncryption() {
            return ECEncryption;
        }

        @NotNull
        public final OID getECDSAwithSHA384Encryption() {
            return ECDSAwithSHA384Encryption;
        }

        @NotNull
        public final OID getECDSAwithSHA256Encryption() {
            return ECDSAwithSHA256Encryption;
        }

        @NotNull
        public final OID getRSAwithSHA512Encryption() {
            return RSAwithSHA512Encryption;
        }

        @NotNull
        public final OID getRSAwithSHA384Encryption() {
            return RSAwithSHA384Encryption;
        }

        @NotNull
        public final OID getRSAwithSHA256Encryption() {
            return RSAwithSHA256Encryption;
        }

        @NotNull
        public final OID getRSAwithSHA1Encryption() {
            return RSAwithSHA1Encryption;
        }

        @NotNull
        public final OID getSecp256r1() {
            return secp256r1;
        }

        @NotNull
        public final OID fromAlgorithm(@NotNull String algorithm) {
            OID oID;
            Intrinsics.checkNotNullParameter((Object)algorithm, (String)"algorithm");
            switch (algorithm) {
                case "SHA1withRSA": {
                    oID = this.getRSAwithSHA1Encryption();
                    break;
                }
                case "SHA384withECDSA": {
                    oID = this.getECDSAwithSHA384Encryption();
                    break;
                }
                case "SHA256withECDSA": {
                    oID = this.getECDSAwithSHA256Encryption();
                    break;
                }
                case "SHA384withRSA": {
                    oID = this.getRSAwithSHA384Encryption();
                    break;
                }
                case "SHA256withRSA": {
                    oID = this.getRSAwithSHA256Encryption();
                    break;
                }
                default: {
                    throw new IllegalStateException(("Could't find OID for " + algorithm).toString());
                }
            }
            return oID;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

