/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CookieDateBuilder;
import io.ktor.http.CookieUtilsKt;
import io.ktor.http.InvalidCookieDateException;
import io.ktor.http.StringLexer;
import io.ktor.util.date.GMTDate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\n\u001a\u00020\t\"\u0004\b\u0000\u0010\u00042\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00018\u0000H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ-\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lio/ktor/http/CookieDateParser;", "", "<init>", "()V", "T", "", "source", "name", "field", "", "checkFieldNotNull", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "", "requirement", "Lkotlin/Function0;", "msg", "checkRequirement", "(Ljava/lang/String;ZLkotlin/jvm/functions/Function0;)V", "Lio/ktor/util/date/GMTDate;", "parse", "(Ljava/lang/String;)Lio/ktor/util/date/GMTDate;", "ktor-http"})
@SourceDebugExtension(value={"SMAP\nCookieUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CookieUtils.kt\nio/ktor/http/CookieDateParser\n+ 2 CookieUtils.kt\nio/ktor/http/StringLexer\n*L\n1#1,349:1\n56#2,3:350\n*S KotlinDebug\n*F\n+ 1 CookieUtils.kt\nio/ktor/http/CookieDateParser\n*L\n294#1:350,3\n*E\n"})
public final class CookieDateParser {
    private final <T> void checkFieldNotNull(String source, String name, T field) {
        if (field == null) {
            throw new InvalidCookieDateException(source, "Could not find " + name);
        }
    }

    private final void checkRequirement(String source, boolean requirement, Function0<String> msg) {
        if (!requirement) {
            throw new InvalidCookieDateException(source, (String)msg.invoke());
        }
    }

    @NotNull
    public final GMTDate parse(@NotNull String source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        StringLexer lexer = new StringLexer(source);
        CookieDateBuilder builder = new CookieDateBuilder();
        lexer.acceptWhile((Function1<? super Character, Boolean>)((Function1)CookieDateParser::parse$lambda$0));
        while (lexer.getHasRemaining()) {
            String token;
            if (!lexer.test((Function1<? super Character, Boolean>)((Function1)CookieDateParser::parse$lambda$1))) continue;
            StringLexer this_$iv = lexer;
            boolean $i$f$capture = false;
            int start$iv = this_$iv.getIndex();
            StringLexer $this$parse_u24lambda_u242 = this_$iv;
            boolean bl = false;
            $this$parse_u24lambda_u242.acceptWhile((Function1<? super Character, Boolean>)((Function1)CookieDateParser::parse$lambda$2$0));
            Intrinsics.checkNotNullExpressionValue((Object)this_$iv.getSource().substring(start$iv, this_$iv.getIndex()), (String)"substring(...)");
            CookieUtilsKt.handleToken(builder, token);
            lexer.acceptWhile((Function1<? super Character, Boolean>)((Function1)CookieDateParser::parse$lambda$3));
        }
        Integer n = builder.getYear();
        Object object = new IntRange(70, 99);
        if (n != null && object.contains(n.intValue())) {
            Integer n2 = builder.getYear();
            Intrinsics.checkNotNull((Object)n2);
            builder.setYear(n2 + 1900);
        } else {
            object = new IntRange(0, 69);
            if (n != null && object.contains(n.intValue())) {
                Integer n3 = builder.getYear();
                Intrinsics.checkNotNull((Object)n3);
                builder.setYear(n3 + 2000);
            }
        }
        this.checkFieldNotNull(source, "day-of-month", builder.getDayOfMonth());
        this.checkFieldNotNull(source, "month", builder.getMonth());
        this.checkFieldNotNull(source, "year", builder.getYear());
        this.checkFieldNotNull(source, "time", builder.getHours());
        this.checkFieldNotNull(source, "time", builder.getMinutes());
        this.checkFieldNotNull(source, "time", builder.getSeconds());
        n = new IntRange(1, 31);
        object = builder.getDayOfMonth();
        this.checkRequirement(source, object != null && n.contains((Integer)object), (Function0<String>)((Function0)CookieDateParser::parse$lambda$4));
        Integer n4 = builder.getYear();
        Intrinsics.checkNotNull((Object)n4);
        this.checkRequirement(source, n4 >= 1601, (Function0<String>)((Function0)CookieDateParser::parse$lambda$5));
        Integer n5 = builder.getHours();
        Intrinsics.checkNotNull((Object)n5);
        this.checkRequirement(source, n5 <= 23, (Function0<String>)((Function0)CookieDateParser::parse$lambda$6));
        Integer n6 = builder.getMinutes();
        Intrinsics.checkNotNull((Object)n6);
        this.checkRequirement(source, n6 <= 59, (Function0<String>)((Function0)CookieDateParser::parse$lambda$7));
        Integer n7 = builder.getSeconds();
        Intrinsics.checkNotNull((Object)n7);
        this.checkRequirement(source, n7 <= 59, (Function0<String>)((Function0)CookieDateParser::parse$lambda$8));
        return builder.build();
    }

    private static final boolean parse$lambda$0(char it) {
        return CookieUtilsKt.isDelimiter(it);
    }

    private static final boolean parse$lambda$1(char it) {
        return CookieUtilsKt.isNonDelimiter(it);
    }

    private static final boolean parse$lambda$2$0(char it) {
        return CookieUtilsKt.isNonDelimiter(it);
    }

    private static final boolean parse$lambda$3(char it) {
        return CookieUtilsKt.isDelimiter(it);
    }

    private static final String parse$lambda$4() {
        return "day-of-month not in [1,31]";
    }

    private static final String parse$lambda$5() {
        return "year >= 1601";
    }

    private static final String parse$lambda$6() {
        return "hours > 23";
    }

    private static final String parse$lambda$7() {
        return "minutes > 59";
    }

    private static final String parse$lambda$8() {
        return "seconds > 59";
    }
}

