/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.migration;

import io.ebean.migration.ConfigurationAware;
import io.ebean.migration.JdbcMigration;
import io.ebean.migration.JdbcMigrationFactory;
import io.ebean.migration.MigrationException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class MigrationConfig {
    private String migrationPath = "dbmigration";
    private String migrationInitPath = "dbinit";
    private String metaTable = "db_migration";
    private String runPlaceholders;
    private Map<String, String> runPlaceholderMap;
    private boolean skipMigrationRun;
    private boolean skipChecksum;
    private ClassLoader classLoader;
    private String dbUsername;
    private String dbPassword;
    private String dbUrl;
    private String dbSchema;
    private boolean createSchemaIfNotExists = true;
    private boolean setCurrentSchema = true;
    private boolean allowErrorInRepeatable;
    private JdbcMigrationFactory jdbcMigrationFactory = new DefaultMigrationFactory();
    private Set<String> patchInsertOn;
    private Set<String> patchResetChecksumOn;
    private String minVersion;
    private String minVersionFailMessage;
    private String name;
    private String basePlatform;
    private String platform;
    private Properties properties;
    private boolean earlyChecksumMode;
    private boolean fastMode = true;

    public String getMetaTable() {
        return this.metaTable;
    }

    public void setMetaTable(String metaTable) {
        this.metaTable = metaTable;
    }

    private Set<String> parseCommaDelimited(String versionsCommaDelimited) {
        if (versionsCommaDelimited != null) {
            String[] split;
            HashSet<String> versions = new HashSet<String>();
            for (String version : split = versionsCommaDelimited.split(",")) {
                if (version.startsWith("R__")) {
                    version = version.substring(3);
                }
                versions.add(version);
            }
            return versions;
        }
        return null;
    }

    public boolean isAllowErrorInRepeatable() {
        return this.allowErrorInRepeatable;
    }

    public void setAllowErrorInRepeatable(boolean allowErrorInRepeatable) {
        this.allowErrorInRepeatable = allowErrorInRepeatable;
    }

    public void setPatchResetChecksumOn(String versionsCommaDelimited) {
        this.patchResetChecksumOn = this.parseCommaDelimited(versionsCommaDelimited);
    }

    public void setPatchResetChecksumOn(Set<String> patchResetChecksumOn) {
        this.patchResetChecksumOn = patchResetChecksumOn;
    }

    public Set<String> getPatchResetChecksumOn() {
        return this.patchResetChecksumOn;
    }

    public void setPatchInsertOn(String versionsCommaDelimited) {
        this.patchInsertOn = this.parseCommaDelimited(versionsCommaDelimited);
    }

    public void setPatchInsertOn(Set<String> patchInsertOn) {
        this.patchInsertOn = patchInsertOn;
    }

    public Set<String> getPatchInsertOn() {
        return this.patchInsertOn;
    }

    public boolean isSkipMigrationRun() {
        return this.skipMigrationRun;
    }

    public void setSkipMigrationRun(boolean skipMigrationRun) {
        this.skipMigrationRun = skipMigrationRun;
    }

    public boolean isSkipChecksum() {
        return this.skipChecksum;
    }

    public void setSkipChecksum(boolean skipChecksum) {
        this.skipChecksum = skipChecksum;
    }

    public String getRunPlaceholders() {
        return this.runPlaceholders;
    }

    public void setRunPlaceholders(String runPlaceholders) {
        this.runPlaceholders = runPlaceholders;
    }

    public Map<String, String> getRunPlaceholderMap() {
        return this.runPlaceholderMap;
    }

    public void setRunPlaceholderMap(Map<String, String> runPlaceholderMap) {
        this.runPlaceholderMap = runPlaceholderMap;
    }

    public String getMigrationPath() {
        return this.migrationPath;
    }

    public void setMigrationPath(String migrationPath) {
        this.migrationPath = migrationPath;
    }

    public String getMigrationInitPath() {
        return this.migrationInitPath;
    }

    public void setMigrationInitPath(String migrationInitPath) {
        this.migrationInitPath = migrationInitPath;
    }

    public String getDbUsername() {
        return this.dbUsername;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public String getDbPassword() {
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    @Deprecated
    public void setDbDriver(String dbDriver) {
    }

    public String getDbUrl() {
        return this.dbUrl;
    }

    public void setDbUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    public String getDbSchema() {
        return this.dbSchema;
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public boolean isCreateSchemaIfNotExists() {
        return this.createSchemaIfNotExists;
    }

    public void setCreateSchemaIfNotExists(boolean createSchemaIfNotExists) {
        this.createSchemaIfNotExists = createSchemaIfNotExists;
    }

    public boolean isSetCurrentSchema() {
        return this.setCurrentSchema;
    }

    public void setSetCurrentSchema(boolean setCurrentSchema) {
        this.setCurrentSchema = setCurrentSchema;
    }

    @Deprecated
    public String getPlatformName() {
        return this.getPlatform();
    }

    @Deprecated
    public void setPlatformName(String platformName) {
        this.setPlatform(platformName);
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
            if (this.classLoader == null) {
                this.classLoader = this.getClass().getClassLoader();
            }
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public JdbcMigrationFactory getJdbcMigrationFactory() {
        return this.jdbcMigrationFactory;
    }

    public void setJdbcMigrationFactory(JdbcMigrationFactory jdbcMigrationFactory) {
        this.jdbcMigrationFactory = jdbcMigrationFactory;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public void setMinVersion(String minVersion) {
        this.minVersion = minVersion;
    }

    public String getMinVersionFailMessage() {
        return this.minVersionFailMessage;
    }

    public void setMinVersionFailMessage(String minVersionFailMessage) {
        this.minVersionFailMessage = minVersionFailMessage;
    }

    public void load(Properties props) {
        String runPlaceholders;
        String patchResetChecksumOn;
        if (props == null) {
            return;
        }
        this.properties = props;
        this.dbUsername = this.property("username", this.dbUsername);
        this.dbPassword = this.property("password", this.dbPassword);
        this.dbUrl = this.property("url", this.dbUrl);
        this.dbSchema = this.property("schema", this.dbSchema);
        this.fastMode = this.property("fastMode", this.fastMode);
        this.skipMigrationRun = this.property("skipMigrationRun", this.skipMigrationRun);
        this.skipChecksum = this.property("skipChecksum", this.skipChecksum);
        this.earlyChecksumMode = this.property("earlyChecksumMode", this.earlyChecksumMode);
        this.createSchemaIfNotExists = this.property("createSchemaIfNotExists", this.createSchemaIfNotExists);
        this.setCurrentSchema = this.property("setCurrentSchema", this.setCurrentSchema);
        this.basePlatform = this.property("basePlatform", this.basePlatform);
        this.platform = this.property("platform", this.property("platformName", this.platform));
        this.metaTable = this.property("metaTable", this.metaTable);
        this.migrationPath = this.property("migrationPath", this.migrationPath);
        this.migrationInitPath = this.property("migrationInitPath", this.migrationInitPath);
        this.runPlaceholders = this.property("placeholders", this.runPlaceholders);
        this.minVersion = this.property("minVersion", this.minVersion);
        this.minVersionFailMessage = this.property("minVersionFailMessage", this.minVersionFailMessage);
        String patchInsertOn = this.property("patchInsertOn");
        if (patchInsertOn != null) {
            this.setPatchInsertOn(patchInsertOn);
        }
        if ((patchResetChecksumOn = this.property("patchResetChecksumOn")) != null) {
            this.setPatchResetChecksumOn(patchResetChecksumOn);
        }
        if ((runPlaceholders = this.property("runPlaceholders")) != null) {
            this.setRunPlaceholders(runPlaceholders);
        }
    }

    private boolean property(String key, boolean value) {
        String val = this.property(key);
        return val != null ? Boolean.parseBoolean(val) : value;
    }

    private String property(String key) {
        return this.property(key, null);
    }

    private String property(String key, String defaultVal) {
        String val = this.properties.getProperty("ebean." + this.name + ".migration." + key);
        if (val != null) {
            return val;
        }
        val = this.properties.getProperty("ebean.migration." + key);
        if (val != null) {
            return val;
        }
        return this.properties.getProperty("dbmigration." + key, defaultVal);
    }

    public Connection createConnection() {
        if (this.dbUsername == null) {
            throw new MigrationException("Database username is null?");
        }
        if (this.dbPassword == null) {
            throw new MigrationException("Database password is null?");
        }
        if (this.dbUrl == null) {
            throw new MigrationException("Database connection URL is null?");
        }
        try {
            Properties props = new Properties();
            props.setProperty("user", this.dbUsername);
            props.setProperty("password", this.dbPassword);
            return DriverManager.getConnection(this.dbUrl, props);
        }
        catch (SQLException e) {
            throw new MigrationException("Error trying to create Connection", e);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBasePlatform() {
        return this.basePlatform != null ? this.basePlatform : this.platform;
    }

    public void setBasePlatform(String basePlatform) {
        this.basePlatform = basePlatform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public boolean isEarlyChecksumMode() {
        return this.earlyChecksumMode;
    }

    public void setEarlyChecksumMode(boolean earlyChecksumMode) {
        this.earlyChecksumMode = earlyChecksumMode;
    }

    public boolean isFastMode() {
        return this.fastMode;
    }

    public void setFastMode(boolean fastMode) {
        this.fastMode = fastMode;
    }

    public class DefaultMigrationFactory
    implements JdbcMigrationFactory {
        @Override
        public JdbcMigration createInstance(String className) {
            try {
                Class<?> clazz = Class.forName(className, true, MigrationConfig.this.getClassLoader());
                JdbcMigration migration = (JdbcMigration)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                if (migration instanceof ConfigurationAware) {
                    ((ConfigurationAware)((Object)migration)).setMigrationConfig(MigrationConfig.this);
                }
                return migration;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(className + " is not a valid JdbcMigration", e);
            }
        }
    }
}

