/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.datasource.pool;

import io.ebean.datasource.pool.ConnectionPool;
import io.ebean.datasource.pool.Log;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ExecutorFactory {
    ExecutorFactory() {
    }

    static ExecutorService newExecutor() {
        ThreadFactory factory = Thread.ofVirtual().name("datasource.reaper").factory();
        return Executors.newThreadPerTaskExecutor(factory);
    }

    static ConnectionPool.Heartbeat newHeartBeat(ConnectionPool pool, int freqMillis) {
        return new VTHeartbeat(pool, freqMillis).start();
    }

    private static final class VTHeartbeat
    implements ConnectionPool.Heartbeat {
        private final AtomicBoolean running = new AtomicBoolean(false);
        private final ConnectionPool pool;
        private final int freqMillis;
        private final Thread thread;

        private VTHeartbeat(ConnectionPool pool, int freqMillis) {
            this.pool = pool;
            this.freqMillis = freqMillis;
            this.thread = Thread.ofVirtual().name(VTHeartbeat.nm(pool.name())).unstarted(this::run);
        }

        private static String nm(String poolName) {
            return poolName.isEmpty() ? "datasource.heartbeat" : "datasource." + poolName + ".heartbeat";
        }

        private void run() {
            while (this.running.get()) {
                try {
                    Thread.sleep(this.freqMillis);
                    this.pool.heartbeat();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                catch (Exception e) {
                    Log.warn("Error during heartbeat", e);
                }
            }
        }

        private ConnectionPool.Heartbeat start() {
            this.running.set(true);
            this.thread.start();
            return this;
        }

        @Override
        public void stop() {
            this.running.set(false);
            this.thread.interrupt();
        }
    }
}

