/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.core.type;

import io.ebean.annotation.Platform;
import io.ebean.config.dbplatform.DatabasePlatform;
import java.sql.SQLException;
import org.postgresql.util.PGobject;

public final class PostgresHelper {
    public static final String JSON_TYPE = "json";
    public static final String JSONB_TYPE = "jsonb";
    static final String INET_TYPE = "inet";

    public static Object asInet(String value) throws SQLException {
        return PostgresHelper.asObject(INET_TYPE, value);
    }

    public static Object asObject(String pgType, String rawJson) throws SQLException {
        PGobject pgo = new PGobject();
        pgo.setType(pgType);
        pgo.setValue(rawJson);
        return pgo;
    }

    public static boolean isPostgresCompatible(DatabasePlatform databasePlatform) {
        return databasePlatform.isPlatform(Platform.POSTGRES) || databasePlatform.isPlatform(Platform.YUGABYTE) || databasePlatform.isPlatform(Platform.COCKROACH);
    }
}

