/*
 * Decompiled with CFR 0.152.
 */
package io.ebean.core.type;

import io.ebean.core.type.ScalarTypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.UUID;

public final class BasicTypeConverter {
    public static final int UTIL_CALENDAR = -999998986;
    public static final int UTIL_DATE = -999998988;

    private BasicTypeConverter() {
    }

    public static Object convert(Object value, int toDataType) {
        try {
            switch (toDataType) {
                case -999998988: {
                    return BasicTypeConverter.toUtilDate(value);
                }
                case -999998986: {
                    return BasicTypeConverter.toCalendar(value);
                }
                case -5: {
                    return BasicTypeConverter.toLong(value);
                }
                case 4: {
                    return BasicTypeConverter.toInteger(value);
                }
                case -7: 
                case 16: {
                    return BasicTypeConverter.toBoolean(value);
                }
                case -6: {
                    return BasicTypeConverter.toByte(value);
                }
                case 5: {
                    return BasicTypeConverter.toShort(value);
                }
                case 2: 
                case 3: {
                    return BasicTypeConverter.toBigDecimal(value);
                }
                case 7: {
                    return BasicTypeConverter.toFloat(value);
                }
                case 6: 
                case 8: {
                    return BasicTypeConverter.toDouble(value);
                }
                case 93: {
                    return BasicTypeConverter.toTimestamp(value);
                }
                case 91: {
                    return BasicTypeConverter.toDate(value);
                }
                case 1: 
                case 12: {
                    return BasicTypeConverter.toString(value);
                }
                case -4: 
                case -2: 
                case -1: 
                case 1111: 
                case 2000: 
                case 2004: 
                case 2005: {
                    return value;
                }
            }
            throw new RuntimeException("Unhandled data type - " + toDataType);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("ClassCastException converting to data type: " + toDataType + " value: " + String.valueOf(value));
        }
    }

    public static String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof char[]) {
            return String.valueOf((char[])value);
        }
        return value.toString();
    }

    public static Boolean toBoolean(Object value, String trueValue) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() == 1;
        }
        return value.toString().equalsIgnoreCase(trueValue);
    }

    public static Boolean toBoolean(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.valueOf(value.toString());
    }

    public static UUID toUUID(Object value, boolean optimizedBinary) {
        if (value == null) {
            return null;
        }
        if (value instanceof UUID) {
            return (UUID)value;
        }
        if (value instanceof String) {
            return UUID.fromString((String)value);
        }
        if (value instanceof byte[]) {
            return ScalarTypeUtils.uuidFromBytes((byte[])value, optimizedBinary);
        }
        return UUID.fromString(value.toString());
    }

    public static BigDecimal toBigDecimal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        return new BigDecimal(value.toString());
    }

    public static Float toFloat(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        return Float.valueOf(value.toString());
    }

    public static Short toShort(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return ((Number)value).shortValue();
        }
        return Short.valueOf(value.toString());
    }

    public static Byte toByte(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte) {
            return (Byte)value;
        }
        return Byte.valueOf(value.toString());
    }

    public static Integer toInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.valueOf(value.toString());
    }

    public static Long toLong(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            return Long.valueOf((String)value);
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof java.util.Date) {
            return ((java.util.Date)value).getTime();
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime().getTime();
        }
        return Long.valueOf(value.toString());
    }

    public static BigInteger toBigInteger(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        return new BigInteger(value.toString());
    }

    public static Double toDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.valueOf(value.toString());
    }

    public static Timestamp toTimestamp(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof java.util.Date) {
            return new Timestamp(((java.util.Date)value).getTime());
        }
        if (value instanceof Calendar) {
            return new Timestamp(((Calendar)value).getTime().getTime());
        }
        if (value instanceof String) {
            return Timestamp.valueOf((String)value);
        }
        if (value instanceof LocalDateTime) {
            return Timestamp.valueOf((LocalDateTime)value);
        }
        if (value instanceof Number) {
            return new Timestamp(((Number)value).longValue());
        }
        throw new RuntimeException("Unable to convert " + String.valueOf(value));
    }

    public static Time toTime(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Time) {
            return (Time)value;
        }
        if (value instanceof String) {
            return Time.valueOf((String)value);
        }
        if (value instanceof LocalTime) {
            return Time.valueOf((LocalTime)value);
        }
        throw new RuntimeException("Unable to convert " + String.valueOf(value));
    }

    public static Date toDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof java.util.Date) {
            return new Date(((java.util.Date)value).getTime());
        }
        if (value instanceof Calendar) {
            return new Date(((Calendar)value).getTime().getTime());
        }
        if (value instanceof String) {
            return Date.valueOf((String)value);
        }
        if (value instanceof Number) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof LocalDate) {
            return Date.valueOf((LocalDate)value);
        }
        throw new RuntimeException("Unable to convert " + String.valueOf(value));
    }

    public static java.util.Date toUtilDate(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return new java.util.Date(((Timestamp)value).getTime());
        }
        if (value instanceof Date) {
            return new java.util.Date(((Date)value).getTime());
        }
        if (value instanceof java.util.Date) {
            return (java.util.Date)value;
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTime();
        }
        if (value instanceof String) {
            return new java.util.Date(Timestamp.valueOf((String)value).getTime());
        }
        if (value instanceof Number) {
            return new java.util.Date(((Number)value).longValue());
        }
        throw new RuntimeException("Unable to convert " + String.valueOf(value));
    }

    public static Calendar toCalendar(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Calendar) {
            return (Calendar)value;
        }
        if (value instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)value;
            return BasicTypeConverter.toCalendarFromDate(date);
        }
        if (value instanceof String) {
            java.util.Date date = BasicTypeConverter.toUtilDate(value);
            return BasicTypeConverter.toCalendarFromDate(date);
        }
        if (value instanceof Number) {
            long timeMillis = ((Number)value).longValue();
            java.util.Date date = new java.util.Date(timeMillis);
            return BasicTypeConverter.toCalendarFromDate(date);
        }
        throw new RuntimeException("Unable to convert " + String.valueOf(value));
    }

    private static Calendar toCalendarFromDate(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }
}

