/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.config.CurrentTenantProvider;
import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.transaction.DataSourceSupplier;
import io.ebeaninternal.server.transaction.ImplicitReadOnlyTransaction;
import io.ebeaninternal.server.transaction.TransactionFactory;
import io.ebeaninternal.server.transaction.TransactionManager;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.SQLException;

class TransactionFactoryTenant
extends TransactionFactory {
    final DataSourceSupplier dataSourceSupplier;
    final CurrentTenantProvider tenantProvider;

    TransactionFactoryTenant(TransactionManager manager, DataSourceSupplier dataSourceSupplier, CurrentTenantProvider tenantProvider) {
        super(manager);
        this.dataSourceSupplier = dataSourceSupplier;
        this.tenantProvider = tenantProvider;
    }

    @Override
    public SpiTransaction createReadOnlyTransaction(Object tenantId, boolean useMaster) {
        Connection connection = null;
        try {
            if (tenantId == null) {
                tenantId = this.tenantProvider.currentId();
            }
            connection = this.dataSourceSupplier.readOnlyConnection(tenantId, useMaster);
            return new ImplicitReadOnlyTransaction(this.manager, connection, tenantId);
        }
        catch (PersistenceException ex) {
            JdbcClose.close(connection);
            throw ex;
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    @Override
    public final SpiTransaction createTransaction(boolean explicit, int isolationLevel) {
        Connection connection = null;
        try {
            Object tenantId = this.tenantProvider.currentId();
            connection = this.dataSourceSupplier.connection(tenantId);
            SpiTransaction transaction = this.createTransaction(explicit, connection);
            transaction.setTenantId(tenantId);
            return this.setIsolationLevel(transaction, isolationLevel);
        }
        catch (PersistenceException ex) {
            JdbcClose.close(connection);
            throw ex;
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }
}

