/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.transaction.JdbcAutoCommitTransaction;
import io.ebeaninternal.server.transaction.JdbcTransaction;
import io.ebeaninternal.server.transaction.TransactionManager;
import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.SQLException;

abstract class TransactionFactory {
    final TransactionManager manager;
    private final boolean autoCommitMode;

    TransactionFactory(TransactionManager manager) {
        this.manager = manager;
        this.autoCommitMode = manager.isAutoCommitMode();
    }

    SpiTransaction createTransaction(boolean explicit, Connection connection) {
        return this.autoCommitMode ? new JdbcAutoCommitTransaction(explicit, connection, this.manager) : new JdbcTransaction(explicit, connection, this.manager);
    }

    abstract SpiTransaction createReadOnlyTransaction(Object var1, boolean var2);

    abstract SpiTransaction createTransaction(boolean var1, int var2);

    final SpiTransaction setIsolationLevel(SpiTransaction t, int isolationLevel) {
        if (isolationLevel > -1) {
            Connection connection = t.internalConnection();
            try {
                connection.setTransactionIsolation(isolationLevel);
            }
            catch (SQLException e) {
                JdbcClose.close((Connection)connection);
                throw new PersistenceException((Throwable)e);
            }
        }
        return t;
    }
}

