/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.querydefn;

import io.ebeaninternal.server.querydefn.OrmQueryDetail;
import io.ebeaninternal.server.querydefn.OrmQueryProperties;
import io.ebeaninternal.server.querydefn.SimpleTextParser;
import jakarta.persistence.PersistenceException;

public final class OrmQueryDetailParser {
    private final OrmQueryDetail detail = new OrmQueryDetail();
    private final SimpleTextParser parser;

    public OrmQueryDetailParser(String oql) {
        this.parser = new SimpleTextParser(oql);
    }

    public OrmQueryDetail parse() throws PersistenceException {
        if (this.parser.isEmpty()) {
            return this.detail;
        }
        this.parser.nextWord();
        this.processInitial();
        return this.detail;
    }

    private void processInitial() {
        if (this.parser.isMatch("select")) {
            this.readSelect();
        } else if (this.parser.isMatch("find")) {
            OrmQueryProperties props = this.readFindFetch();
            this.detail.setBase(props);
        } else {
            this.process();
        }
        while (!this.parser.isFinished()) {
            this.process();
        }
    }

    private boolean isFetch() {
        return this.parser.isMatch("fetch") || this.parser.isMatch("join");
    }

    private void process() {
        if (!this.isFetch()) {
            throw new PersistenceException("Query expected 'fetch', 'where','order by' or 'limit' keyword but got [" + this.parser.getWord() + "] \r " + this.parser.getOql());
        }
        this.detail.fetch(this.readFindFetch());
    }

    private void readSelect() {
        String props = this.parser.nextWord();
        if (props.startsWith("(")) {
            props = props.substring(1, props.length() - 1);
            OrmQueryProperties base = new OrmQueryProperties(null, props);
            this.detail.setBase(base);
            this.parser.nextWord();
        } else {
            this.process();
        }
    }

    private OrmQueryProperties readFindFetch() {
        String token;
        boolean readAlias = false;
        String props = null;
        String path = this.parser.nextWord();
        while ((token = this.parser.nextWord()) != null) {
            if (!readAlias && this.parser.isMatch("as")) {
                this.parser.nextWord();
                readAlias = true;
                continue;
            }
            if ('(' == token.charAt(0)) {
                props = token;
                this.parser.nextWord();
                break;
            }
            if (this.isFindFetchEnd()) break;
            if (!readAlias) {
                readAlias = true;
                continue;
            }
            throw new PersistenceException("Expected (props) or new 'fetch' 'where' but got " + token);
        }
        if (props != null) {
            props = props.substring(1, props.length() - 1);
        }
        return new OrmQueryProperties(path, props);
    }

    private boolean isFindFetchEnd() {
        return this.isFetch() || this.parser.isMatch("where") || this.parser.isMatch("order", "by");
    }
}

