/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.query.STreeProperty;
import io.ebeaninternal.server.query.STreePropertyAssocMany;
import io.ebeaninternal.server.query.SqlTreeNode;
import io.ebeaninternal.server.query.SqlTreePlan;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

final class SqlTree {
    private final SqlTreeNode rootNode;
    private final STreePropertyAssocMany manyProperty;
    private final String distinctOn;
    private final String selectSql;
    private final String fromSql;
    private final String groupBy;
    private final STreeProperty[] encryptedProps;
    private final String inheritanceWhereSql;
    private final boolean noJoins;

    SqlTree(SqlTreeNode rootNode, String distinctOn, String selectSql, String fromSql, String groupBy, String inheritanceWhereSql, STreeProperty[] encryptedProps, STreePropertyAssocMany manyProperty, boolean includeJoins) {
        this.rootNode = rootNode;
        this.distinctOn = distinctOn;
        this.selectSql = selectSql;
        this.fromSql = fromSql;
        this.groupBy = groupBy;
        this.inheritanceWhereSql = inheritanceWhereSql;
        this.encryptedProps = encryptedProps;
        this.manyProperty = manyProperty;
        this.noJoins = !includeJoins;
    }

    SqlTreePlan plan() {
        return new SqlTreePlan(this.rootNode.createLoad(), this.manyProperty, this.encryptedProps, this.dependentTables());
    }

    boolean isSqlDistinct() {
        return this.rootNode.isSqlDistinct();
    }

    boolean noJoins() {
        return this.noJoins;
    }

    void addAsOfTableAlias(SpiQuery<?> query) {
        this.rootNode.addAsOfTableAlias(query);
    }

    void addSoftDeletePredicate(SpiQuery<?> query) {
        this.rootNode.addSoftDeletePredicate(query);
    }

    public List<String> buildRawSqlSelectChain() {
        ArrayList<String> list = new ArrayList<String>();
        this.rootNode.buildRawSqlSelectChain(list);
        return list;
    }

    String distinctOn() {
        return this.distinctOn;
    }

    String selectSql() {
        assert (this.selectSql != null) : "selectSql was null";
        return this.selectSql;
    }

    String fromSql() {
        return this.fromSql;
    }

    String groupBy() {
        return this.groupBy;
    }

    String inheritanceWhereSql() {
        return this.inheritanceWhereSql;
    }

    STreePropertyAssocMany manyProperty() {
        return this.manyProperty;
    }

    boolean hasMany() {
        return this.manyProperty != null || this.rootNode.hasMany();
    }

    boolean isSingleProperty() {
        return this.rootNode.isSingleProperty();
    }

    private Set<String> dependentTables() {
        LinkedHashSet<String> tables = new LinkedHashSet<String>();
        this.rootNode.dependentTables(tables);
        return tables;
    }
}

