/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiDbQueryPlan;
import io.ebeaninternal.api.SpiQueryPlan;
import io.ebeaninternal.server.bind.capture.BindCapture;
import io.ebeaninternal.server.query.QueryPlanLogger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public final class QueryPlanLoggerOracle
extends QueryPlanLogger {
    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public SpiDbQueryPlan collectPlan(Connection conn, SpiQueryPlan plan, BindCapture bind) {
        try (Statement stmt = conn.createStatement();){
            SpiDbQueryPlan spiDbQueryPlan;
            block21: {
                try (PreparedStatement explainStmt = conn.prepareStatement("EXPLAIN PLAN FOR " + plan.sql());){
                    bind.prepare(explainStmt, conn);
                    explainStmt.execute();
                }
                ResultSet rset = stmt.executeQuery("select plan_table_output from table(dbms_xplan.display())");
                try {
                    spiDbQueryPlan = this.readQueryPlan(plan, bind, rset);
                    if (rset == null) break block21;
                }
                catch (Throwable throwable) {
                    if (rset != null) {
                        try {
                            rset.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rset.close();
            }
            return spiDbQueryPlan;
        }
        catch (SQLException e) {
            CoreLog.log.log(System.Logger.Level.WARNING, "Could not log query plan", (Throwable)e);
            return null;
        }
    }
}

