/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.FutureMap;
import io.ebean.Query;
import io.ebeaninternal.server.query.BaseFuture;
import io.ebeaninternal.server.query.CallableQueryMap;
import jakarta.persistence.PersistenceException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class QueryFutureMap<K, T>
extends BaseFuture<Map<K, T>>
implements FutureMap<K, T> {
    private final CallableQueryMap<K, T> call;

    public QueryFutureMap(CallableQueryMap<K, T> call) {
        super(new FutureTask(call));
        this.call = call;
    }

    public FutureTask<Map<K, T>> futureTask() {
        return this.futureTask;
    }

    public Query<T> getQuery() {
        return this.call.query;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.call.query.cancel();
        return super.cancel(mayInterruptIfRunning);
    }

    public Map<K, T> getUnchecked() {
        try {
            return (Map)this.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PersistenceException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public Map<K, T> getUnchecked(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            return (Map)this.get(timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PersistenceException((Throwable)e);
        }
        catch (ExecutionException e) {
            throw new PersistenceException((Throwable)e);
        }
    }
}

