/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.QueryIterator;
import io.ebean.Transaction;
import io.ebean.Version;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.event.BeanFindController;
import io.ebeaninternal.server.core.OrmQueryEngine;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.core.SpiResultSet;
import io.ebeaninternal.server.persist.Binder;
import io.ebeaninternal.server.query.CQueryEngine;
import jakarta.persistence.PersistenceException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

public final class DefaultOrmQueryEngine
implements OrmQueryEngine {
    private final CQueryEngine queryEngine;
    private final Binder binder;
    private final int forwardOnlyFetchSize;

    public DefaultOrmQueryEngine(CQueryEngine queryEngine, Binder binder) {
        this.queryEngine = queryEngine;
        this.forwardOnlyFetchSize = queryEngine.forwardOnlyFetchSize();
        this.binder = binder;
    }

    @Override
    public <T> PersistenceException translate(OrmQueryRequest<T> request, String bindLog, String sql, SQLException e) {
        return this.queryEngine.translate(request, bindLog, sql, e);
    }

    @Override
    public int forwardOnlyFetchSize() {
        return this.forwardOnlyFetchSize;
    }

    @Override
    public boolean isMultiValueSupported(Class<?> cls) {
        return this.binder.isMultiValueSupported(cls);
    }

    private <T> void flushJdbcBatchOnQuery(OrmQueryRequest<T> request) {
        if (request.query().isUsingFuture()) {
            return;
        }
        Transaction t = request.transaction();
        if (t.isFlushOnQuery()) {
            t.flush();
        }
    }

    @Override
    public <T> int delete(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.delete(request);
    }

    @Override
    public <T> int update(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.update(request);
    }

    @Override
    public <T> SpiResultSet findResultSet(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.findResultSet(request);
    }

    @Override
    public <T> int findCount(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.findCount(request);
    }

    @Override
    public <A> List<A> findIds(OrmQueryRequest<?> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.findIds(request);
    }

    @Override
    public <A extends Collection<?>> A findSingleAttributeCollection(OrmQueryRequest<?> request, A collection) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.findSingleAttributeList(request, collection);
    }

    @Override
    public <T> QueryIterator<T> findIterate(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.findIterate(request);
    }

    @Override
    public <T> List<Version<T>> findVersions(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        return this.queryEngine.findVersions(request);
    }

    @Override
    public <T> Object findMany(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        BeanFindController finder = request.finder();
        BeanCollection result = finder != null && finder.isInterceptFindMany(request) ? finder.findMany(request) : this.queryEngine.findMany(request);
        if (finder != null) {
            result = finder.postProcessMany(request, result);
        }
        if (result != null && request.isBeanCachePutMany()) {
            request.descriptor().cacheBeanPutAll(result.actualDetails());
        }
        request.mergeCacheHits(result);
        Object finalResult = result;
        if (request.query().isUnmodifiable()) {
            BeanCollection beanCollection = finalResult = result == null ? null : result.freeze();
            if (request.isQueryCachePut()) {
                request.putToQueryCache(finalResult);
            }
        }
        return finalResult;
    }

    @Override
    public <T> T findId(OrmQueryRequest<T> request) {
        this.flushJdbcBatchOnQuery(request);
        BeanFindController finder = request.finder();
        Object result = finder != null && finder.isInterceptFind(request) ? finder.find(request) : this.queryEngine.find(request);
        if (finder != null) {
            result = finder.postProcess(request, result);
        }
        if (result != null && request.isBeanCachePut()) {
            request.descriptor().cacheBeanPut((EntityBean)result);
        }
        return result;
    }
}

