/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.DbSqlContext;
import io.ebeaninternal.server.deploy.TableJoinColumn;
import io.ebeaninternal.server.query.CQueryHistorySupport;
import io.ebeaninternal.server.query.SqlJoinType;
import io.ebeaninternal.server.query.SqlTreeAlias;
import io.ebeaninternal.server.query.SqlTreeJoin;
import io.ebeaninternal.server.util.ArrayStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

final class DefaultDbSqlContext
implements DbSqlContext {
    private static final String COMMA = ", ";
    private static final String PERIOD = ".";
    private static final int STRING_BUILDER_INITIAL_CAPACITY = 140;
    private static final String tableAliasPlaceHolder = "${ta}";
    private static final String tableAliasManyPlaceHolder = "${mta}";
    private final String columnAliasPrefix;
    private final ArrayStack<String> tableAliasStack = new ArrayStack();
    private final ArrayStack<String> joinStack = new ArrayStack();
    private final ArrayStack<String> prefixStack = new ArrayStack();
    private final String fromForUpdate;
    private final String dbFilterManyJoin;
    private boolean useColumnAlias;
    private int columnIndex;
    private int asOfTableCount;
    private StringBuilder sb = new StringBuilder(140);
    private HashSet<String> formulaJoins;
    private HashSet<String> tableJoins;
    private final SqlTreeAlias alias;
    private String currentPrefix;
    private List<BeanProperty> encryptedProps;
    private List<SqlTreeJoin> extraJoins;
    private final CQueryHistorySupport historySupport;
    private final boolean historyQuery;
    private boolean joinSuppressed;

    DefaultDbSqlContext(SqlTreeAlias alias, String columnAliasPrefix, CQueryHistorySupport historySupport, String fromForUpdate, String dbFilterManyJoin) {
        this.alias = alias;
        this.columnAliasPrefix = columnAliasPrefix;
        this.useColumnAlias = columnAliasPrefix != null;
        this.historySupport = historySupport;
        this.historyQuery = historySupport != null;
        this.fromForUpdate = fromForUpdate;
        this.dbFilterManyJoin = dbFilterManyJoin;
    }

    @Override
    public void includeFilterMany() {
        if (this.dbFilterManyJoin != null) {
            this.sb.append(" and ").append(this.dbFilterManyJoin);
        }
    }

    @Override
    public boolean joinAdded() {
        return !this.joinSuppressed;
    }

    @Override
    public boolean isIncludeSoftDelete() {
        return this.alias.isIncludeSoftDelete();
    }

    @Override
    public void addExtraJoin(SqlTreeJoin treeJoin) {
        if (this.extraJoins == null) {
            this.extraJoins = new ArrayList<SqlTreeJoin>();
        }
        this.extraJoins.add(treeJoin);
    }

    @Override
    public void flushExtraJoins() {
        if (this.extraJoins != null) {
            for (SqlTreeJoin extra : this.extraJoins) {
                extra.addJoin(this);
            }
            this.extraJoins = null;
        }
    }

    @Override
    public void appendFromForUpdate() {
        if (this.fromForUpdate != null) {
            this.append(" ").append(this.fromForUpdate);
        }
    }

    @Override
    public void startGroupBy() {
        this.useColumnAlias = false;
    }

    @Override
    public void addEncryptedProp(BeanProperty p) {
        if (this.encryptedProps == null) {
            this.encryptedProps = new ArrayList<BeanProperty>();
        }
        this.encryptedProps.add(p);
    }

    @Override
    public BeanProperty[] encryptedProps() {
        if (this.encryptedProps == null) {
            return null;
        }
        return this.encryptedProps.toArray(new BeanProperty[0]);
    }

    @Override
    public void popJoin() {
        this.joinStack.pop();
    }

    @Override
    public void pushJoin(String node) {
        this.joinStack.push(node);
    }

    @Override
    public void addJoin(String type, String table, TableJoinColumn[] cols, String a1, String a2, String extraWhere) {
        String joinKey;
        if (this.tableJoins == null) {
            this.tableJoins = new HashSet();
        }
        if (this.tableJoins.contains(joinKey = table + "-" + a1 + "-" + a2)) {
            this.joinSuppressed = true;
            return;
        }
        this.joinSuppressed = false;
        this.tableJoins.add(joinKey);
        this.sb.append(' ').append(type);
        boolean addAsOfOnClause = false;
        if (!this.historyQuery) {
            this.sb.append(' ').append(table).append(' ');
        } else {
            String asOfView = this.historySupport.asOfView(table);
            this.appendTable(table, asOfView);
            if (asOfView != null) {
                if (this.historySupport.isStandardsBased()) {
                    ++this.asOfTableCount;
                }
                addAsOfOnClause = !this.historySupport.isStandardsBased();
            }
        }
        this.sb.append(a2);
        this.sb.append(" on ");
        for (int i = 0; i < cols.length; ++i) {
            TableJoinColumn pair = cols[i];
            if (i > 0) {
                this.sb.append(" and ");
            }
            if (pair.getForeignSqlFormula() != null) {
                this.sb.append(pair.getForeignSqlFormula().replace(tableAliasPlaceHolder, a2));
            } else {
                this.sb.append(a2).append('.').append(pair.getForeignDbColumn());
            }
            this.sb.append(" = ");
            if (pair.getLocalSqlFormula() != null) {
                this.sb.append(pair.getLocalSqlFormula().replace(tableAliasPlaceHolder, a1));
                continue;
            }
            this.sb.append(a1).append('.').append(pair.getLocalDbColumn());
        }
        if (addAsOfOnClause) {
            this.sb.append(" and ").append(this.historySupport.asOfPredicate(a2));
            ++this.asOfTableCount;
        }
        if (extraWhere != null && !extraWhere.isEmpty()) {
            this.sb.append(" and ");
            this.sb.append(extraWhere.replace(tableAliasPlaceHolder, a2).replace(tableAliasManyPlaceHolder, a1));
        }
    }

    private void appendTable(String table, String draftTable) {
        if (draftTable != null) {
            this.sb.append(' ').append(draftTable).append(' ');
        } else {
            this.sb.append(' ').append(table).append(' ');
        }
    }

    @Override
    public int asOfTableCount() {
        return this.asOfTableCount;
    }

    @Override
    public String tableAlias(String prefix) {
        return this.alias.tableAlias(prefix);
    }

    @Override
    public String tableAliasManyWhere(String prefix) {
        return prefix == null ? this.tableAliasStack.peek() : this.alias.tableAliasManyWhere(prefix);
    }

    @Override
    public String relativePrefix(String propName) {
        return this.currentPrefix == null ? propName : this.currentPrefix + PERIOD + propName;
    }

    @Override
    public void pushTableAlias(String prefix) {
        this.prefixStack.push(this.currentPrefix);
        this.currentPrefix = prefix;
        this.tableAliasStack.push(this.tableAlias(prefix));
    }

    @Override
    public void popTableAlias() {
        this.tableAliasStack.pop();
        this.currentPrefix = this.prefixStack.pop();
    }

    @Override
    public DefaultDbSqlContext append(String s) {
        this.sb.append(s);
        return this;
    }

    @Override
    public void appendFormulaJoin(String sqlFormulaJoin, SqlJoinType joinType, String tableAlias) {
        String converted = sqlFormulaJoin.replace(tableAliasPlaceHolder, tableAlias);
        if (this.formulaJoins == null) {
            this.formulaJoins = new HashSet();
        } else if (this.formulaJoins.contains(converted)) {
            return;
        }
        this.formulaJoins.add(converted);
        this.sb.append(' ');
        if (joinType == SqlJoinType.OUTER && "join".equalsIgnoreCase(converted.substring(0, 4))) {
            this.sb.append("left ");
        }
        if (joinType == SqlJoinType.INNER && "left join".equalsIgnoreCase(converted.substring(0, 9))) {
            converted = converted.substring(5);
        }
        this.sb.append(converted);
    }

    @Override
    public void appendParseSelect(String parseSelect, String columnAlias) {
        String converted = this.alias.parse(parseSelect);
        this.sb.append(COMMA);
        this.sb.append(converted);
        if (columnAlias != null) {
            this.sb.append(' ').append(columnAlias);
        } else {
            this.appendColumnAlias();
        }
    }

    @Override
    public void appendFormulaSelect(String sqlFormulaSelect) {
        String tableAlias = this.tableAliasStack.peek();
        this.sb.append(COMMA);
        this.sb.append(sqlFormulaSelect.replace(tableAliasPlaceHolder, tableAlias));
        this.appendColumnAlias();
    }

    @Override
    public void appendHistorySysPeriod() {
        String tableAlias = this.tableAliasStack.peek();
        this.sb.append(COMMA);
        this.sb.append(this.historySupport.sysPeriodLower(tableAlias));
        this.appendColumnAlias();
        this.sb.append(COMMA);
        this.sb.append(this.historySupport.sysPeriodUpper(tableAlias));
        this.appendColumnAlias();
    }

    private void appendColumnAlias() {
        if (this.useColumnAlias) {
            this.sb.append(' ');
            this.sb.append(this.columnAliasPrefix);
            this.sb.append(this.columnIndex++);
        }
    }

    @Override
    public void appendColumn(String column) {
        this.appendColumn(this.tableAliasStack.peek(), column);
    }

    @Override
    public void appendColumn(String tableAlias, String column) {
        this.sb.append(COMMA);
        if (column.contains("${}")) {
            this.sb.append(column.replace("${}", tableAlias));
        } else {
            this.sb.append(tableAlias);
            this.sb.append(PERIOD);
            this.sb.append(column);
        }
        this.appendColumnAlias();
    }

    @Override
    public String peekTableAlias() {
        return this.tableAliasStack.peek();
    }

    @Override
    public void appendRawColumn(String rawColumnWithTableAlias) {
        this.sb.append(COMMA);
        this.sb.append(rawColumnWithTableAlias);
    }

    @Override
    public int length() {
        return this.sb.length();
    }

    @Override
    public String content() {
        String s = this.sb.toString();
        this.sb = new StringBuilder(140);
        return s;
    }

    public String toString() {
        return "DefaultDbSqlContext: " + String.valueOf(this.sb);
    }
}

