/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.OrderBy;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssoc;
import io.ebeaninternal.server.deploy.DeployParser;
import io.ebeaninternal.server.deploy.id.IdBinder;
import io.ebeaninternal.server.el.ElPropertyValue;
import java.util.List;

final class CQueryOrderBy {
    private final BeanDescriptor<?> desc;
    private final OrderBy<?> orderBy;
    private final DeployParser parser;

    static String parse(DeployParser parser, BeanDescriptor<?> desc, OrderBy<?> orderBy) {
        return new CQueryOrderBy(parser, desc, orderBy).parseInternal();
    }

    private CQueryOrderBy(DeployParser parser, BeanDescriptor<?> desc, OrderBy<?> orderBy) {
        this.desc = desc;
        this.parser = parser;
        this.orderBy = orderBy;
    }

    private String parseInternal() {
        List properties = this.orderBy.getProperties();
        if (properties.isEmpty()) {
            return null;
        }
        StringAppend append = new StringAppend(this.parser);
        for (int i = 0; i < properties.size(); ++i) {
            if (i > 0) {
                append.append(", ");
            }
            this.parseProperty((OrderBy.Property)properties.get(i), append);
        }
        return append.toString();
    }

    private void parseProperty(OrderBy.Property p, StringAppend append) {
        BeanProperty beanProperty;
        ElPropertyValue el = this.desc.elGetValue(p.getProperty());
        if (el != null && (beanProperty = el.beanProperty()) instanceof BeanPropertyAssoc) {
            BeanPropertyAssoc ap = (BeanPropertyAssoc)beanProperty;
            IdBinder idBinder = ap.targetDescriptor().idBinder();
            append.parse(idBinder.orderBy(el.elName(), p.isAscending()));
            return;
        }
        p.toStringFormat((OrderBy.Append)append);
    }

    private static class StringAppend
    implements OrderBy.Append {
        private final StringBuilder builder = new StringBuilder();
        private final DeployParser parser;

        StringAppend(DeployParser parser) {
            this.parser = parser;
        }

        public String toString() {
            return this.builder.toString();
        }

        public OrderBy.Append property(String property) {
            this.builder.append(this.parser.property(property));
            return this;
        }

        public OrderBy.Append append(String literal) {
            this.builder.append(literal);
            return this;
        }

        public OrderBy.Append parse(String raw) {
            this.builder.append(this.parser.parse(raw));
            return this;
        }
    }
}

