/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.profile;

import io.ebean.ProfileLocation;
import io.ebean.util.StackWalkFilter;
import io.ebeaninternal.server.profile.UtilLocation;
import java.util.stream.Stream;

class DProfileLocation
implements ProfileLocation {
    private static final String UNKNOWN = "unknown";
    private final boolean withLine;
    private String fullLocation;
    private String location;
    private String label;
    private int traceCount;

    DProfileLocation(boolean withLine) {
        this.withLine = withLine;
    }

    public String toString() {
        return "location: " + this.location;
    }

    public void add(long executionTime) {
    }

    public boolean obtain() {
        if (this.fullLocation != null) {
            return false;
        }
        String loc = this.create();
        String location = UtilLocation.loc(loc, this.withLine);
        this.label = UtilLocation.label(location);
        this.location = location;
        this.fullLocation = loc;
        this.initWith(this.label);
        return true;
    }

    protected void initWith(String label) {
    }

    public String label() {
        return this.label;
    }

    public String location() {
        return this.location;
    }

    public String fullLocation() {
        return this.fullLocation;
    }

    public boolean trace() {
        if (this.traceCount <= 0) {
            return false;
        }
        --this.traceCount;
        return true;
    }

    public void setTraceCount(int traceCount) {
        this.traceCount = traceCount;
    }

    private String create() {
        return StackWalker.getInstance().walk(this::filter);
    }

    private String filter(Stream<StackWalker.StackFrame> frames) {
        return frames.filter(StackWalkFilter.filter()).findFirst().map(Object::toString).orElse(UNKNOWN);
    }
}

