/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebean.core.type.DataReader;
import io.ebean.core.type.PostgresHelper;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.api.BindParams;
import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiLogManager;
import io.ebeaninternal.server.bind.DataBind;
import io.ebeaninternal.server.core.timezone.DataTimeZone;
import io.ebeaninternal.server.expression.platform.DbExpressionHandler;
import io.ebeaninternal.server.persist.MultiValueWrapper;
import io.ebeaninternal.server.persist.platform.MultiValueBind;
import io.ebeaninternal.server.type.GeoTypeBinder;
import io.ebeaninternal.server.type.RsetDataReader;
import io.ebeaninternal.server.type.TypeManager;
import jakarta.persistence.PersistenceException;
import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;

public final class Binder {
    private final TypeManager typeManager;
    private final int asOfBindCount;
    private final boolean asOfStandardsBased;
    private final DbExpressionHandler dbExpressionHandler;
    private final DataTimeZone dataTimeZone;
    private final MultiValueBind multiValueBind;
    private final boolean enableBindLog;
    private final GeoTypeBinder geoTypeBinder;

    public Binder(TypeManager typeManager, SpiLogManager logManager, int asOfBindCount, boolean asOfStandardsBased, DbExpressionHandler dbExpressionHandler, DataTimeZone dataTimeZone, MultiValueBind multiValueBind) {
        this.typeManager = typeManager;
        this.geoTypeBinder = typeManager.geoTypeBinder();
        this.asOfBindCount = asOfBindCount;
        this.asOfStandardsBased = asOfStandardsBased;
        this.dbExpressionHandler = dbExpressionHandler;
        this.dataTimeZone = dataTimeZone;
        this.multiValueBind = multiValueBind;
        this.enableBindLog = logManager.enableBindLog();
    }

    public boolean isEnableBindLog() {
        return this.enableBindLog;
    }

    public int getAsOfBindCount() {
        return this.asOfBindCount;
    }

    public boolean isAsOfStandardsBased() {
        return this.asOfStandardsBased;
    }

    public String bind(BindParams bindParams, PreparedStatement statement, Connection connection) throws SQLException {
        return this.bind(bindParams, new DataBind(this.dataTimeZone, statement, connection));
    }

    private String bind(BindParams bindParams, DataBind dataBind) throws SQLException {
        StringBuilder bindLog = new StringBuilder();
        this.bind(bindParams, dataBind, bindLog);
        return bindLog.toString();
    }

    public void bind(BindParams bindParams, DataBind dataBind, StringBuilder bindLog) throws SQLException {
        this.bind(bindParams.positionedParameters(), dataBind, bindLog);
    }

    private void bind(List<BindParams.Param> list, DataBind dataBind, StringBuilder bindLog) throws SQLException {
        CallableStatement cstmt = null;
        if (dataBind.getPstmt() instanceof CallableStatement) {
            cstmt = (CallableStatement)dataBind.getPstmt();
        }
        Object value = null;
        try {
            for (BindParams.Param param : list) {
                if (param.isOutParam() && cstmt != null) {
                    cstmt.registerOutParameter(dataBind.nextPos(), param.type());
                    if (param.isInParam()) {
                        dataBind.decrementPos();
                    }
                }
                if (!param.isInParam()) continue;
                value = param.inValue();
                if (bindLog != null) {
                    if (bindLog.length() > 0) {
                        bindLog.append(", ");
                    }
                    if (param.isEncryptionKey()) {
                        bindLog.append("****");
                    } else {
                        Object sv = String.valueOf(value);
                        if (((String)sv).length() > 50) {
                            sv = ((String)sv).substring(0, 47) + "...";
                        }
                        bindLog.append((String)sv);
                    }
                }
                if (value instanceof Collection) {
                    for (Object entry : (Collection)value) {
                        this.bindObject(dataBind, entry);
                    }
                    continue;
                }
                if (value == null) {
                    this.bindObject(dataBind, null, param.type());
                    continue;
                }
                this.bindObject(dataBind, value);
            }
        }
        catch (SQLException ex) {
            CoreLog.log.log(System.Logger.Level.WARNING, "error binding parameter [{0}][{1}]", dataBind.currentPos() - 1, value);
            throw ex;
        }
    }

    public boolean isMultiValueSupported(Class<?> cls) {
        try {
            ScalarType<?> scalarType = this.getScalarType(cls);
            return this.multiValueBind.isTypeSupported(scalarType.jdbcType());
        }
        catch (PersistenceException e) {
            return false;
        }
    }

    public ScalarType<?> getScalarType(Class<?> clazz) {
        ScalarType<?> type = this.typeManager.type(clazz);
        if (type == null) {
            throw new PersistenceException("No ScalarType registered for " + String.valueOf(clazz));
        }
        return type;
    }

    public void bindObject(DataBind dataBind, Object value) throws SQLException {
        if (value == null) {
            this.bindObject(dataBind, null, 1111);
        } else if (value instanceof MultiValueWrapper) {
            MultiValueWrapper wrapper = (MultiValueWrapper)value;
            Collection<?> values = wrapper.getValues();
            ScalarType<?> type = this.getScalarType(wrapper.getType());
            int dbType = type.jdbcType();
            this.multiValueBind.bindMultiValues(dataBind, values, type, one -> this.bindObject(dataBind, one, dbType));
        } else {
            ScalarType<?> type = this.getScalarType(value.getClass());
            if (!type.jdbcNative()) {
                value = type.toJdbcType(value);
            }
            this.bindObject(dataBind, value, type.jdbcType());
        }
    }

    public String getInExpression(boolean not, List<Object> bindValues) {
        ScalarType<?> type = this.getScalarType(bindValues.get(0).getClass());
        return this.multiValueBind.getInExpression(not, type, bindValues.size());
    }

    private void bindObject(DataBind dataBind, Object data, int dbType) throws SQLException {
        if (data == null) {
            dataBind.setNull(dbType);
            return;
        }
        switch (dbType) {
            case -1: {
                this.bindLongVarChar(dataBind, data);
                break;
            }
            case -4: {
                this.bindLongVarBinary(dataBind, data);
                break;
            }
            case 2005: {
                this.bindClob(dataBind, data);
                break;
            }
            case 2004: {
                this.bindBlob(dataBind, data);
                break;
            }
            default: {
                this.bindSimpleData(dataBind, dbType, data);
            }
        }
    }

    private void bindSimpleData(DataBind b, int dataType, Object data) {
        try {
            switch (dataType) {
                case -7: 
                case 16: {
                    b.setBoolean((Boolean)data);
                    break;
                }
                case 12: {
                    b.setString((String)data);
                    break;
                }
                case 1: {
                    b.setString(data.toString());
                    break;
                }
                case -6: {
                    b.setByte((Byte)data);
                    break;
                }
                case 5: {
                    b.setShort((Short)data);
                    break;
                }
                case 4: {
                    b.setInt((Integer)data);
                    break;
                }
                case -5: {
                    b.setLong((Long)data);
                    break;
                }
                case 7: {
                    b.setFloat(((Float)data).floatValue());
                    break;
                }
                case 6: 
                case 8: {
                    b.setDouble((Double)data);
                    break;
                }
                case 2: 
                case 3: {
                    b.setBigDecimal((BigDecimal)data);
                    break;
                }
                case 92: {
                    b.setTime((Time)data);
                    break;
                }
                case 91: {
                    b.setDate((Date)data);
                    break;
                }
                case 93: 
                case 5009: {
                    b.setTimestamp((Timestamp)data);
                    break;
                }
                case -3: 
                case -2: {
                    b.setBytes((byte[])data);
                    break;
                }
                case 2000: 
                case 5010: {
                    b.setObject(data);
                    break;
                }
                case 5020: {
                    b.setObject(PostgresHelper.asInet((String)data.toString()));
                    break;
                }
                case 6000: 
                case 6001: 
                case 6002: 
                case 6005: 
                case 6006: 
                case 6007: {
                    this.geoTypeBinder.bind(b, dataType, data);
                    break;
                }
                case 7000: 
                case 7001: 
                case 7002: 
                case 7003: {
                    b.setObject(data);
                    break;
                }
                case 1111: {
                    b.setObject(data, dataType);
                    break;
                }
                default: {
                    throw new SQLException("Unhandled data type:" + dataType + " bind number:" + b.currentPos());
                }
            }
        }
        catch (Exception e) {
            String dataClass = "Data is null?";
            if (data != null) {
                dataClass = data.getClass().getName();
            }
            throw new PersistenceException("Error with property:" + b.currentPos() + " dt:" + dataType + " data:" + String.valueOf(data) + " " + dataClass, (Throwable)e);
        }
    }

    private void bindLongVarChar(DataBind dataBind, Object data) throws SQLException {
        dataBind.setClob((String)data);
    }

    private void bindLongVarBinary(DataBind dataBind, Object data) throws SQLException {
        dataBind.setBlob((byte[])data);
    }

    private void bindClob(DataBind dataBind, Object data) throws SQLException {
        dataBind.setClob((String)data);
    }

    private void bindBlob(DataBind dataBind, Object data) throws SQLException {
        dataBind.setBlob((byte[])data);
    }

    private boolean isLob(int dbType) {
        switch (dbType) {
            case -4: 
            case -1: 
            case 2004: 
            case 2005: {
                return true;
            }
        }
        return false;
    }

    public DbExpressionHandler getDbExpressionHandler() {
        return this.dbExpressionHandler;
    }

    public DataBind dataBind(PreparedStatement stmt, Connection connection) {
        return new DataBind(this.dataTimeZone, stmt, connection);
    }

    public DataReader createDataReader(boolean unmodifiable, ResultSet resultSet) {
        return new RsetDataReader(unmodifiable, this.dataTimeZone, resultSet);
    }
}

