/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.api.SpiProfileTransactionEvent;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.persist.BatchPostExecute;
import io.ebeaninternal.server.persist.DB2GetKeys;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public final class BatchedPstmt
implements SpiProfileTransactionEvent {
    private static final DB2GetKeys DB2_HACK = new DB2GetKeys();
    private PreparedStatement pstmt;
    private final boolean isGenKeys;
    private final List<BatchPostExecute> list = new ArrayList<BatchPostExecute>();
    private final String sql;
    private final SpiTransaction transaction;
    private long profileStart;
    private long timedStart;
    private int[] results;
    private List<InputStream> inputStreams;

    public BatchedPstmt(PreparedStatement pstmt, boolean isGenKeys, String sql, SpiTransaction transaction) throws SQLException {
        this.pstmt = pstmt;
        this.pstmt.clearBatch();
        this.isGenKeys = isGenKeys;
        this.sql = sql;
        this.transaction = transaction;
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public String sql() {
        return this.sql;
    }

    public PreparedStatement statement(BatchPostExecute postExecute) throws SQLException {
        if (postExecute.isFlushQueue() && this.list.size() >= 20) {
            this.flushStatementBatch();
        }
        this.list.add(postExecute);
        return this.pstmt;
    }

    private void flushStatementBatch() throws SQLException {
        int[] rows = this.pstmt.executeBatch();
        if (this.transaction.isLogSql()) {
            this.transaction.logSql(" -- executeBatch() size:{0} sql:{1}", rows.length, this.sql);
        }
        if (rows.length != this.list.size()) {
            throw new IllegalStateException("Invalid state on executeBatch, rows:" + rows.length + " != " + this.list.size());
        }
        this.postExecute();
        this.list.clear();
    }

    public void add(BatchPostExecute batchExecute) {
        this.list.add(batchExecute);
    }

    public void executeBatch(boolean getGeneratedKeys) throws SQLException {
        if (this.list.isEmpty()) {
            return;
        }
        this.timedStart = System.nanoTime();
        this.profileStart = this.transaction.profileOffset();
        this.executeAndCheckRowCounts();
        if (this.isGenKeys && getGeneratedKeys) {
            this.getGeneratedKeys();
        }
        this.postExecute();
        this.addTimingMetrics();
        this.list.clear();
        this.transaction.profileEvent(this);
    }

    private void addTimingMetrics() {
        this.list.get(0).addTimingBatch(this.timedStart, this.list.size());
    }

    @Override
    public void profile() {
        this.list.get(0).profile(this.profileStart, this.list.size());
    }

    public void close() {
        if (this.pstmt != null) {
            try {
                this.pstmt.close();
            }
            catch (SQLException e) {
                CoreLog.log.log(System.Logger.Level.WARNING, "BatchedPstmt Error closing statement", (Throwable)e);
            }
            finally {
                this.pstmt = null;
            }
        }
    }

    private void postExecute() {
        for (BatchPostExecute item : this.list) {
            item.postExecute();
        }
    }

    private void executeAndCheckRowCounts() throws SQLException {
        try {
            this.results = this.pstmt.executeBatch();
            if (this.transaction.isLogSql()) {
                this.transaction.logSql(" -- executeBatch() size:{0} sql:{1}", this.results.length, this.sql);
            }
            if (this.results.length != this.list.size()) {
                throw new SQLException("Invalid state on executeBatch, rows:" + this.results.length + " != " + this.list.size());
            }
            for (int i = 0; i < this.results.length; ++i) {
                this.list.get(i).checkRowCount(this.results[i]);
            }
        }
        finally {
            this.closeInputStreams();
        }
    }

    private void getGeneratedKeys() throws SQLException {
        if (DB2GetKeys.getGeneratedKeys(this.pstmt, this.list)) {
            return;
        }
        int index = 0;
        try (ResultSet rset = this.pstmt.getGeneratedKeys();){
            while (rset.next()) {
                Object idValue = rset.getObject(1);
                this.list.get(index++).setGeneratedKey(idValue);
            }
        }
    }

    public int[] results() {
        return this.results;
    }

    public void registerInputStreams(List<InputStream> streams) {
        if (streams != null) {
            if (this.inputStreams == null) {
                this.inputStreams = new ArrayList<InputStream>();
            }
            this.inputStreams.addAll(streams);
        }
    }

    private void closeInputStreams() {
        if (this.inputStreams != null) {
            for (InputStream inputStream : this.inputStreams) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    CoreLog.log.log(System.Logger.Level.WARNING, "BatchedPstmt Error closing inputStream ", (Throwable)e);
                }
            }
            this.inputStreams = null;
        }
    }
}

