/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.loadcontext;

import io.ebean.CacheMode;
import io.ebean.ProfileLocation;
import io.ebean.Query;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.CallOrigin;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.ObjectGraphNode;
import io.ebean.bean.ObjectGraphOrigin;
import io.ebean.bean.PersistenceContext;
import io.ebeaninternal.api.LoadContext;
import io.ebeaninternal.api.LoadSecondaryQuery;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiQuerySecondary;
import io.ebeaninternal.server.autotune.ProfilingListener;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssoc;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.loadcontext.DLoadBeanContext;
import io.ebeaninternal.server.loadcontext.DLoadManyContext;
import io.ebeaninternal.server.querydefn.OrmQueryProperties;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class DLoadContext
implements LoadContext {
    private final SpiEbeanServer ebeanServer;
    private final BeanDescriptor<?> rootDescriptor;
    private final Map<String, DLoadBeanContext> beanMap = new HashMap<String, DLoadBeanContext>();
    private final Map<String, DLoadManyContext> manyMap = new HashMap<String, DLoadManyContext>();
    private final DLoadBeanContext rootBeanContext;
    private final Timestamp asOf;
    private final boolean unmodifiable;
    private final CacheMode useBeanCache;
    private final int defaultBatchSize;
    private final boolean disableLazyLoading;
    private final boolean includeSoftDeletes;
    private final String relativePath;
    private final ObjectGraphOrigin origin;
    private final String planLabel;
    private final ProfileLocation profileLocation;
    private final ProfilingListener profilingListener;
    private final Map<String, ObjectGraphNode> nodePathMap = new HashMap<String, ObjectGraphNode>();
    private final PersistenceContext persistenceContext;
    private List<OrmQueryProperties> secQuery;
    private Object tenantId;
    private final Set<BeanProperty> secondaryProperties;

    public DLoadContext(BeanDescriptor<?> rootDescriptor, PersistenceContext persistenceContext) {
        this.rootDescriptor = rootDescriptor;
        this.ebeanServer = rootDescriptor.ebeanServer();
        this.persistenceContext = persistenceContext;
        this.origin = this.initOrigin();
        this.defaultBatchSize = 100;
        this.useBeanCache = CacheMode.OFF;
        this.asOf = null;
        this.unmodifiable = false;
        this.disableLazyLoading = false;
        this.includeSoftDeletes = false;
        this.relativePath = null;
        this.planLabel = null;
        this.profileLocation = null;
        this.profilingListener = null;
        this.rootBeanContext = new DLoadBeanContext(this, rootDescriptor, null, null);
        this.secondaryProperties = null;
    }

    private ObjectGraphOrigin initOrigin() {
        CallOrigin callOrigin = this.ebeanServer.createCallOrigin();
        return new ObjectGraphOrigin(0, callOrigin, this.rootDescriptor.fullName());
    }

    public DLoadContext(OrmQueryRequest<?> request, SpiQuerySecondary secondaryQueries) {
        this.tenantId = request.tenantId();
        this.persistenceContext = request.persistenceContext();
        this.ebeanServer = request.server();
        this.defaultBatchSize = request.lazyLoadBatchSize();
        this.rootDescriptor = request.descriptor();
        Query query = request.query();
        this.asOf = query.getAsOf();
        this.includeSoftDeletes = query.isIncludeSoftDeletes() && query.mode() == SpiQuery.Mode.NORMAL;
        this.unmodifiable = query.isUnmodifiable();
        this.disableLazyLoading = query.isDisableLazyLoading();
        this.useBeanCache = query.beanCacheMode();
        this.profilingListener = query.profilingListener();
        this.planLabel = query.planLabel();
        this.profileLocation = query.profileLocation();
        this.secondaryProperties = query.isUnmodifiable() ? new HashSet() : null;
        ObjectGraphNode parentNode = query.parentNode();
        if (parentNode != null) {
            this.origin = parentNode.origin();
            this.relativePath = parentNode.path();
        } else {
            this.origin = null;
            this.relativePath = null;
        }
        this.rootBeanContext = new DLoadBeanContext(this, this.rootDescriptor, null, null);
        this.registerSecondaryQueries(secondaryQueries);
    }

    String planLabel() {
        return this.planLabel;
    }

    public ProfileLocation profileLocation() {
        return this.profileLocation;
    }

    private void registerSecondaryQueries(SpiQuerySecondary secondaryQueries) {
        List<OrmQueryProperties> lazyJoins;
        this.secQuery = secondaryQueries.queryJoins();
        if (this.secQuery != null) {
            for (OrmQueryProperties pathProperties : this.secQuery) {
                this.registerSecondaryQuery(pathProperties);
            }
        }
        if ((lazyJoins = secondaryQueries.lazyJoins()) != null) {
            for (OrmQueryProperties lazyJoin : lazyJoins) {
                this.registerSecondaryQuery(lazyJoin);
            }
        }
    }

    private void registerSecondaryQuery(OrmQueryProperties props) {
        ElPropertyValue elGetValue = this.rootDescriptor.elGetValue(props.getPath());
        boolean many = elGetValue.beanProperty().containsMany();
        this.registerSecondaryNode(many, props);
        if (many && this.secondaryProperties != null) {
            this.secondaryProperties.add(elGetValue.beanProperty());
        }
    }

    @Override
    public boolean includeSecondary(BeanPropertyAssocMany<?> many) {
        return this.secondaryProperties != null && this.secondaryProperties.contains(many);
    }

    boolean isBeanCacheGet() {
        return this.useBeanCache.isGet();
    }

    @Override
    public int secondaryQueriesMinBatchSize() {
        if (this.secQuery == null) {
            return -1;
        }
        int maxBatch = 0;
        for (OrmQueryProperties aSecQuery : this.secQuery) {
            int batchSize = aSecQuery.getBatchSize();
            if (batchSize == 0) {
                batchSize = 100;
            }
            maxBatch = Math.max(maxBatch, batchSize);
        }
        return maxBatch;
    }

    @Override
    public void executeSecondaryQueries(OrmQueryRequest<?> parentRequest, boolean forEach) {
        if (this.secQuery != null) {
            for (OrmQueryProperties aSecQuery : this.secQuery) {
                LoadSecondaryQuery load = this.loadSecondaryQuery(aSecQuery.getPath());
                load.loadSecondaryQuery(parentRequest, forEach);
            }
        }
    }

    private LoadSecondaryQuery loadSecondaryQuery(String path) {
        LoadSecondaryQuery beanLoad = this.beanMap.get(path);
        return beanLoad == null ? (LoadSecondaryQuery)this.manyMap.get(path) : beanLoad;
    }

    @Override
    public ObjectGraphNode objectGraphNode(String path) {
        return this.nodePathMap.computeIfAbsent(path, this::createObjectGraphNode);
    }

    private ObjectGraphNode createObjectGraphNode(String path) {
        if (this.relativePath != null) {
            path = path == null ? this.relativePath : this.relativePath + "." + (String)path;
        }
        return new ObjectGraphNode(this.origin, (String)path);
    }

    String fullPath(String path) {
        if (this.relativePath == null) {
            return path;
        }
        return this.relativePath + "." + path;
    }

    SpiEbeanServer server() {
        return this.ebeanServer;
    }

    @Override
    public PersistenceContext persistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public void register(String path, EntityBeanIntercept ebi) {
        this.beanContext(path).register(ebi);
    }

    @Override
    public void register(String path, EntityBeanIntercept ebi, BeanPropertyAssocOne<?> property) {
        this.beanContextWithInherit(path, property).register(ebi);
    }

    @Override
    public void register(String path, BeanPropertyAssocMany<?> many, BeanCollection<?> bc) {
        this.manyContext(path, many).register(bc);
    }

    int batchSize(OrmQueryProperties props) {
        if (props == null) {
            return this.defaultBatchSize;
        }
        int batchSize = props.getBatchSize();
        return batchSize == 0 ? this.defaultBatchSize : batchSize;
    }

    DLoadBeanContext beanContext(String path) {
        if (path == null) {
            return this.rootBeanContext;
        }
        return this.beanMap.computeIfAbsent(path, p -> this.createBeanContext((String)p, null));
    }

    DLoadBeanContext beanContextWithInherit(String path, BeanPropertyAssocOne<?> property) {
        String key = path + ":" + property.targetDescriptor().name();
        return this.beanMap.computeIfAbsent(key, p -> this.createBeanContext(property, path));
    }

    private void registerSecondaryNode(boolean many, OrmQueryProperties props) {
        String path = props.getPath();
        if (many) {
            this.manyMap.put(path, this.createManyContext(path, props));
        } else {
            this.beanMap.put(path, this.createBeanContext(path, props));
        }
    }

    DLoadManyContext manyContext(String path, BeanPropertyAssocMany<?> many) {
        return this.manyMap.computeIfAbsent(path, p -> this.createManyContext((String)p, many));
    }

    private DLoadManyContext createManyContext(String path, BeanPropertyAssocMany<?> many) {
        return new DLoadManyContext(this, many, path, null);
    }

    private DLoadManyContext createManyContext(String path, OrmQueryProperties queryProps) {
        BeanPropertyAssocMany p = (BeanPropertyAssocMany)this.beanProperty(this.rootDescriptor, path);
        return new DLoadManyContext(this, p, path, queryProps);
    }

    private DLoadBeanContext createBeanContext(String path, OrmQueryProperties queryProps) {
        BeanPropertyAssoc p = (BeanPropertyAssoc)this.beanProperty(this.rootDescriptor, path);
        return new DLoadBeanContext(this, p.targetDescriptor(), path, queryProps);
    }

    private DLoadBeanContext createBeanContext(BeanPropertyAssoc<?> property, String path) {
        return new DLoadBeanContext(this, property.targetDescriptor(), path, null);
    }

    private BeanProperty beanProperty(BeanDescriptor<?> desc, String path) {
        return desc.findPropertyFromPath(path);
    }

    void propagateQueryState(SpiQuery<?> query) {
        query.setUnmodifiable(this.unmodifiable);
        query.setDisableLazyLoading(this.disableLazyLoading);
        query.asOf(this.asOf);
        if (this.includeSoftDeletes) {
            query.setIncludeSoftDeletes();
        }
        if (this.profilingListener != null) {
            query.setProfilingListener(this.profilingListener);
        }
        if (this.tenantId != null) {
            query.setTenantId(this.tenantId);
        }
    }
}

